// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Base array class for user-defined extension types */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ExtensionArray extends Array {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ExtensionArray(Pointer p) { super(p); }

  /** \brief Construct an ExtensionArray from an ArrayData.
   * 
   *  The ArrayData must have the right ExtensionType. */
  public ExtensionArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data) { super((Pointer)null); allocate(data); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data);

  /** \brief Construct an ExtensionArray from a type and the underlying storage. */
  public ExtensionArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                   @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array storage) { super((Pointer)null); allocate(type, storage); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                   @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array storage);

  public native @Const ExtensionType extension_type();

  /** \brief The physical storage for the extension array */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array storage();
}
