// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;

@Name("std::vector<arrow::fs::FileStats>") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class FileStatsVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileStatsVector(Pointer p) { super(p); }
    public FileStatsVector(FileStats value) { this(1); put(0, value); }
    public FileStatsVector(FileStats ... array) { this(array.length); put(array); }
    public FileStatsVector()       { allocate();  }
    public FileStatsVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef FileStatsVector put(@ByRef FileStatsVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native @ByRef FileStats get(@Cast("size_t") long i);
    public native FileStatsVector put(@Cast("size_t") long i, FileStats value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, @ByRef FileStats value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @ByRef @Const FileStats get();
    }

    public FileStats[] get() {
        FileStats[] array = new FileStats[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public FileStats pop_back() {
        long size = size();
        FileStats value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public FileStatsVector push_back(FileStats value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public FileStatsVector put(FileStats value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public FileStatsVector put(FileStats ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

