// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief BinaryKernel implementing Filter operation */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class FilterKernel extends BinaryKernel {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FilterKernel(Pointer p) { super(p); }


  /** \brief BinaryKernel interface
   * 
   *  delegates to subclasses via Filter() */
  public native @ByVal Status Call(FunctionContext ctx, @Const @ByRef Datum values, @Const @ByRef Datum filter,
                Datum out);

  /** \brief output type of this kernel (identical to type of values filtered) */
  
  ///
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType out_type();

  /** \brief factory for FilterKernels
   * 
   *  @param value_type [in] constructed FilterKernel will support filtering
   *             values of this type
   *  @param out [out] created kernel */
  public static native @ByVal Status Make(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type,
                       @UniquePtr FilterKernel out);

  /** \brief single-array implementation */
  public native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef Array values,
                          @Const @ByRef BooleanArray filter, @Cast("int64_t") long out_length,
                          @SharedPtr Array out);
}
