// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Container for variables and options used by function evaluation */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class FunctionContext extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FunctionContext(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FunctionContext(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FunctionContext position(long position) {
        return (FunctionContext)super.position(position);
    }

  public FunctionContext(MemoryPool pool/*=arrow::default_memory_pool()*/) { super((Pointer)null); allocate(pool); }
  private native void allocate(MemoryPool pool/*=arrow::default_memory_pool()*/);
  public FunctionContext() { super((Pointer)null); allocate(); }
  private native void allocate();
  public native MemoryPool memory_pool();

  /** \brief Allocate buffer from the context's memory pool */
  
  ///
  public native @ByVal Status Allocate(@Cast("const int64_t") long nbytes, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

  /** \brief Indicate that an error has occurred, to be checked by a parent caller
   *  @param status [in] a Status instance
   * 
   *  \note Will not overwrite a prior set Status, so we will have the first
   *  error that occurred until FunctionContext::ResetStatus is called */
  public native void SetStatus(@Const @ByRef Status status);

  /** \brief Clear any error status */
  public native void ResetStatus();

  /** \brief Return true if an error has occurred */
  public native @Cast("bool") boolean HasError();

  /** \brief Return the current status of the context */
  public native @Const @ByRef Status status();

  public native CpuInfo cpu_info();
}
