// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


@Namespace("arrow::io") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class InputStream extends FileInterface {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public InputStream(Pointer p) { super(p); }
    public Readable asReadable() { return asReadable(this); }
    @Namespace public static native @Name("static_cast<arrow::io::Readable*>") Readable asReadable(InputStream pointer);

  /** \brief Advance or skip stream indicated number of bytes
   *  @param nbytes [in] the number to move forward
   *  @return Status */
  
  ///
  ///
  ///
  public native @ByVal Status Advance(@Cast("int64_t") long nbytes);

  /** \brief Return zero-copy string_view to upcoming bytes.
   * 
   *  Do not modify the stream position.  The view becomes invalid after
   *  any operation on the stream.  May trigger buffering if the requested
   *  size is larger than the number of buffered bytes.
   * 
   *  May return NotImplemented on streams that don't support it.
   * 
   *  @param nbytes [in] the maximum number of bytes to see */
  
  ///
  public native @ByVal StringViewResult Peek(@Cast("int64_t") long nbytes);

  /** \brief Return true if InputStream is capable of zero copy Buffer reads
   * 
   *  Zero copy reads imply the use of Buffer-returning Read() overloads. */
  public native @Cast("bool") boolean supports_zero_copy();

  // Deprecated APIs
}
