// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief A container for key-value pair type metadata. Not thread-safe */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class KeyValueMetadata extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public KeyValueMetadata(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public KeyValueMetadata(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public KeyValueMetadata position(long position) {
        return (KeyValueMetadata)super.position(position);
    }

  public KeyValueMetadata() { super((Pointer)null); allocate(); }
  private native void allocate();
  public KeyValueMetadata(@Const @ByRef StringVector keys,
                     @Const @ByRef StringVector values) { super((Pointer)null); allocate(keys, values); }
  private native void allocate(@Const @ByRef StringVector keys,
                     @Const @ByRef StringVector values);
  public KeyValueMetadata(@Const @ByRef StringStringMap map) { super((Pointer)null); allocate(map); }
  private native void allocate(@Const @ByRef StringStringMap map);

  public native void ToUnorderedMap(StringStringMap out);

  public native void Append(@StdString String key, @StdString String value);
  public native void Append(@StdString BytePointer key, @StdString BytePointer value);

  public native void reserve(@Cast("int64_t") long n);
  public native @Cast("int64_t") long size();

  public native @StdString String key(@Cast("int64_t") long i);
  public native @StdString String value(@Cast("int64_t") long i);
  public native @ByVal StringStringPairVector sorted_pairs();

  /** \brief Perform linear search for key, returning -1 if not found */
  public native int FindKey(@StdString String key);
  public native int FindKey(@StdString BytePointer key);

  public native @SharedPtr KeyValueMetadata Copy();

  public native @Cast("bool") boolean Equals(@Const @ByRef KeyValueMetadata other);
  public native @StdString String ToString();
}
