// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class ListBuilder
 *  \brief Builder class for variable-length list array value types
 * 
 *  To use this class, you must append values to the child array builder and use
 *  the Append function to delimit each distinct list value (once the values
 *  have been appended to the child array) or use the bulk API to append
 *  a sequence of offests and null values.
 * 
 *  A note on types.  Per arrow/type.h all types in the c++ implementation are
 *  logical so even though this class always builds list array, this can
 *  represent multiple different logical types.  If no logical type is provided
 *  at construction time, the class defaults to List<T> where t is taken from the
 *  value_builder/values that the object is constructed with. */
@Namespace("arrow") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ListBuilder extends BaseListBuilder {
    static { Loader.load(); }

  
    public ListBuilder(MemoryPool pool, @Const @SharedPtr @ByRef ArrayBuilder value_builder,
                      @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type) { super((Pointer)null); allocate(pool, value_builder, type); }
    private native void allocate(MemoryPool pool, @Const @SharedPtr @ByRef ArrayBuilder value_builder,
                      @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);
  
    public ListBuilder(MemoryPool pool, @Const @SharedPtr @ByRef ArrayBuilder value_builder) { super((Pointer)null); allocate(pool, value_builder); }
    private native void allocate(MemoryPool pool, @Const @SharedPtr @ByRef ArrayBuilder value_builder);
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ListBuilder(Pointer p) { super(p); }


  /** \cond FALSE */
  /** \endcond */

  public native @ByVal Status Finish(@SharedPtr ListArray out);
}
