// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class OpKernel
 *  \brief Base class for operator kernels
 * 
 *  Note to implementors:
 *  Operator kernels are intended to be the lowest level of an analytics/compute
 *  engine.  They will generally not be exposed directly to end-users.  Instead
 *  they will be wrapped by higher level constructs (e.g. top-level functions
 *  or physical execution plan nodes).  These higher level constructs are
 *  responsible for user input validation and returning the appropriate
 *  error Status.
 * 
 *  Due to this design, implementations of Call (the execution
 *  method on subclasses) should use assertions (i.e. DCHECK) to double-check
 *  parameter arguments when in higher level components returning an
 *  InvalidArgument error might be more appropriate.
 *  */
@Namespace("arrow::compute") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class OpKernel extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpKernel(Pointer p) { super(p); }

  /** \brief EXPERIMENTAL The output data type of the kernel
   *  @return the output type */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType out_type();
}
