// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Reads the record batch file format */
@Namespace("arrow::ipc") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class RecordBatchFileReader extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RecordBatchFileReader(Pointer p) { super(p); }


  /** \brief Open a RecordBatchFileReader
   * 
   *  Open a file-like object that is assumed to be self-contained; i.e., the
   *  end of the file interface is the end of the Arrow file. Note that there
   *  can be any amount of data preceding the Arrow-formatted data, because we
   *  need only locate the end of the Arrow file stream to discover the metadata
   *  and then proceed to read the data into memory. */
  
  ///
  public static native @ByVal Status Open(RandomAccessFile file,
                       @SharedPtr RecordBatchFileReader reader);

  /** \brief Open a RecordBatchFileReader
   *  If the file is embedded within some larger file or memory region, you can
   *  pass the absolute memory offset to the end of the file (which contains the
   *  metadata footer). The metadata must have been written with memory offsets
   *  relative to the start of the containing file
   * 
   *  @param file [in] the data source
   *  @param footer_offset [in] the position of the end of the Arrow file
   *  @param reader [out] the returned reader
   *  @return Status */
  
  ///
  public static native @ByVal Status Open(RandomAccessFile file, @Cast("int64_t") long footer_offset,
                       @SharedPtr RecordBatchFileReader reader);

  /** \brief Version of Open that retains ownership of file
   * 
   *  @param file [in] the data source
   *  @param reader [out] the returned reader
   *  @return Status */

  /** \brief Version of Open that retains ownership of file
   * 
   *  @param file [in] the data source
   *  @param footer_offset [in] the position of the end of the Arrow file
   *  @param reader [out] the returned reader
   *  @return Status */

  /** \brief The schema read from the file */
  public native @SharedPtr @ByVal Schema schema();

  /** \brief Returns the number of record batches in the file */
  public native int num_record_batches();

  /** \brief Return the metadata version from the file metadata */
  
  ///
  public native MetadataVersion version();

  /** \brief Read a particular record batch from the file. Does not copy memory
   *  if the input source supports zero-copy.
   * 
   *  @param i [in] the index of the record batch to return
   *  @param batch [out] the read batch
   *  @return Status */
  public native @ByVal Status ReadRecordBatch(int i, @SharedPtr RecordBatch batch);
}
