// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class RecordBatchStreamReader
 *  \brief Synchronous batch stream reader that reads from io::InputStream
 * 
 *  This class reads the schema (plus any dictionaries) as the first messages
 *  in the stream, followed by record batches. For more granular zero-copy
 *  reads see the ReadRecordBatch functions */
@Namespace("arrow::ipc") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class RecordBatchStreamReader extends RecordBatchReader {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RecordBatchStreamReader(Pointer p) { super(p); }


  /** Create batch reader from generic MessageReader.
   *  This will take ownership of the given MessageReader.
   * 
   *  @param message_reader [in] a MessageReader implementation
   *  @param out [out] the created RecordBatchReader object
   *  @return Status */
  public static native @ByVal Status Open(@UniquePtr MessageReader message_reader,
                       @SharedPtr RecordBatchReader out);

  /** \brief Record batch stream reader from InputStream
   * 
   *  @param stream [in] an input stream instance. Must stay alive throughout
   *  lifetime of stream reader
   *  @param out [out] the created RecordBatchStreamReader object
   *  @return Status */
  public static native @ByVal Status Open(InputStream stream, @SharedPtr RecordBatchReader out);

  /** \brief Open stream and retain ownership of stream object
   *  @param stream [in] the input stream
   *  @param out [out] the batch reader
   *  @return Status */

  /** \brief Returns the schema read from the stream */
  public native @SharedPtr @ByVal Schema schema();

  public native @ByVal Status ReadNext(@SharedPtr RecordBatch batch);
}
