// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class RecordBatchStreamWriter
 *  \brief Synchronous batch stream writer that writes the Arrow streaming
 *  format */
@Namespace("arrow::ipc") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class RecordBatchStreamWriter extends RecordBatchWriter {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RecordBatchStreamWriter(Pointer p) { super(p); }


  /** Create a new writer from stream sink and schema. User is responsible for
   *  closing the actual OutputStream.
   * 
   *  @param sink [in] output stream to write to
   *  @param schema [in] the schema of the record batches to be written
   *  @param out [out] the created stream writer
   *  @return Status */
  
  ///
  public static native @ByVal Status Open(OutputStream sink, @Const @SharedPtr @ByRef Schema schema,
                       @SharedPtr RecordBatchWriter out);

  /** Create a new writer from stream sink and schema. User is responsible for
   *  closing the actual OutputStream.
   * 
   *  @param sink [in] output stream to write to
   *  @param schema [in] the schema of the record batches to be written
   *  @return Result<std::shared_ptr<RecordBatchWriter>> */
  public static native @ByVal RecordBatchWriterSharedResult Open(
        OutputStream sink, @Const @SharedPtr @ByRef Schema schema);
  
  ///
  public static native @ByVal RecordBatchWriterSharedResult Open(
        OutputStream sink, @Const @SharedPtr @ByRef Schema schema,
        @Const @ByRef IpcOptions options);

  /** \brief Write a record batch to the stream
   * 
   *  @param batch [in] the record batch to write
   *  @return Status */
  public native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch);

  /** \brief Close the stream by writing a 4-byte int32 0 EOS market
   *  @return Status */
  public native @ByVal Status Close();

  public native void set_memory_pool(MemoryPool pool);
}
