// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class ResizableBuffer
 *  \brief A mutable buffer that can be resized */
@Namespace("arrow") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ResizableBuffer extends MutableBuffer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ResizableBuffer(Pointer p) { super(p); }

  /** Change buffer reported size to indicated size, allocating memory if
   *  necessary.  This will ensure that the capacity of the buffer is a multiple
   *  of 64 bytes as defined in Layout.md.
   *  Consider using ZeroPadding afterwards, to conform to the Arrow layout
   *  specification.
   * 
   *  @param new_size The new size for the buffer.
   *  @param shrink_to_fit Whether to shrink the capacity if new size < current size */
  public native @ByVal Status Resize(@Cast("const int64_t") long new_size, @Cast("bool") boolean shrink_to_fit/*=true*/);
  public native @ByVal Status Resize(@Cast("const int64_t") long new_size);

  /** Ensure that buffer has enough memory allocated to fit the indicated
   *  capacity (and meets the 64 byte padding requirement in Layout.md).
   *  It does not change buffer's reported size and doesn't zero the padding. */
  public native @ByVal Status Reserve(@Cast("const int64_t") long new_capacity);
}
