// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


// ----------------------------------------------------------------------
// Schema

/** \class Schema
 *  \brief Sequence of arrow::Field objects describing the columns of a record
 *  batch or table data structure */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Schema extends Fingerprintable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Schema(Pointer p) { super(p); }

  public Schema(@Const @ByRef FieldVector fields,
                    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata) { super((Pointer)null); allocate(fields, metadata); }
  private native void allocate(@Const @ByRef FieldVector fields,
                    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
  public Schema(@Const @ByRef FieldVector fields) { super((Pointer)null); allocate(fields); }
  private native void allocate(@Const @ByRef FieldVector fields);

  public Schema(@Const @ByRef Schema arg0) { super((Pointer)null); allocate(arg0); }
  private native void allocate(@Const @ByRef Schema arg0);

  /** Returns true if all of the schema fields are equal */
  public native @Cast("bool") boolean Equals(@Const @ByRef Schema other, @Cast("bool") boolean check_metadata/*=true*/);
  public native @Cast("bool") boolean Equals(@Const @ByRef Schema other);

  /** \brief Return the number of fields (columns) in the schema */
  public native int num_fields();

  /** Return the ith schema element. Does not boundscheck */
  public native @SharedPtr @ByVal Field field(int i);

  public native @Const @ByRef FieldVector fields();

  public native @ByVal StringVector field_names();

  /** Returns null if name not found */
  public native @SharedPtr @ByVal Field GetFieldByName(@StdString String name);
  public native @SharedPtr @ByVal Field GetFieldByName(@StdString BytePointer name);

  /** Return all fields having this name */
  public native @ByVal FieldVector GetAllFieldsByName(@StdString String name);
  public native @ByVal FieldVector GetAllFieldsByName(@StdString BytePointer name);

  /** Returns -1 if name not found */
  public native int GetFieldIndex(@StdString String name);
  public native int GetFieldIndex(@StdString BytePointer name);

  /** Return the indices of all fields having this name */
  
  ///
  public native @StdVector IntPointer GetAllFieldIndices(@StdString String name);
  public native @StdVector IntBuffer GetAllFieldIndices(@StdString BytePointer name);

  /** \brief The custom key-value metadata, if any
   * 
   *  @return metadata may be null */
  public native @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByVal KeyValueMetadata metadata();

  /** \brief Render a string representation of the schema suitable for debugging */
  public native @StdString String ToString();

  public native @ByVal Status AddField(int i, @Const @SharedPtr @ByRef Field field,
                    @SharedPtr Schema out);
  public native @ByVal Status RemoveField(int i, @SharedPtr Schema out);
  
  ///
  public native @ByVal Status SetField(int i, @Const @SharedPtr @ByRef Field field,
                    @SharedPtr Schema out);

  /** \brief Replace key-value metadata with new metadata
   * 
   *  @param metadata [in] new KeyValueMetadata
   *  @return new Schema */
  public native @SharedPtr @ByVal Schema WithMetadata(
        @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef KeyValueMetadata metadata);

  public native @Deprecated @SharedPtr @ByVal Schema AddMetadata(
        @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef KeyValueMetadata metadata);

  /** \brief Return copy of Schema without the KeyValueMetadata */
  public native @SharedPtr @ByVal Schema RemoveMetadata();

  /** \brief Indicate that the Schema has non-empty KevValueMetadata */
  public native @Cast("bool") boolean HasMetadata();

  /** \brief Indicate that the Schema has distinct field names. */
  public native @Cast("bool") boolean HasDistinctFieldNames();
}
