// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class TableWriter
 *  \brief Interface for writing Feather files */
@Namespace("arrow::ipc::feather") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class TableWriter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TableWriter(Pointer p) { super(p); }


  /** \brief Create a new TableWriter that writes to an OutputStream
   *  @param stream [in] an output stream
   *  @param out [out] the returned table writer
   *  @return Status */
  public static native @ByVal Status Open(@SharedPtr OutputStream stream,
                       @UniquePtr TableWriter out);

  /** \brief Set the description field in the file metadata */
  public native void SetDescription(@StdString String desc);
  public native void SetDescription(@StdString BytePointer desc);

  /** \brief Set the number of rows in the file */
  
  ///
  public native void SetNumRows(@Cast("int64_t") long num_rows);

  /** \brief Append a column to the file
   * 
   *  @param name [in] the column name
   *  @param values [in] the column values as a contiguous arrow::Array
   *  @return Status */
  
  ///
  public native @ByVal Status Append(@StdString String name, @Const @ByRef Array values);
  public native @ByVal Status Append(@StdString BytePointer name, @Const @ByRef Array values);

  /** \brief Write a table to the file
   * 
   *  @param table [in] the table to be written
   *  @return Status */
  public native @ByVal Status Write(@Const @ByRef Table table);

  /** \brief Finalize the file by writing the file metadata and footer
   *  @return Status */
  public native @ByVal Status Finalize();
}
