// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief BinaryKernel implementing Take operation */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class TakeKernel extends BinaryKernel {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TakeKernel(Pointer p) { super(p); }


  /** \brief BinaryKernel interface
   * 
   *  delegates to subclasses via Take() */
  public native @ByVal Status Call(FunctionContext ctx, @Const @ByRef Datum values, @Const @ByRef Datum indices,
                Datum out);

  /** \brief output type of this kernel (identical to type of values taken) */
  
  ///
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType out_type();

  /** \brief factory for TakeKernels
   * 
   *  @param value_type [in] constructed TakeKernel will support taking
   *             values of this type
   *  @param index_type [in] constructed TakeKernel will support taking
   *             with indices of this type
   *  @param out [out] created kernel */
  public static native @ByVal Status Make(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type,
                       @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType index_type,
                       @UniquePtr TakeKernel out);

  /** \brief single-array implementation */
  public native @ByVal Status Take(FunctionContext ctx, @Const @ByRef Array values, @Const @ByRef Array indices,
                        @SharedPtr Array out);
}
