// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class UnaryKernel
 *  \brief An array-valued function of a single input argument.
 * 
 *  Note to implementors:  Try to avoid making kernels that allocate memory if
 *  the output size is a deterministic function of the Input Datum's metadata.
 *  Instead separate the logic of the kernel and allocations necessary into
 *  two different kernels.  Some reusable kernels that allocate buffers
 *  and delegate computation to another kernel are available in util-internal.h. */
@Namespace("arrow::compute") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class UnaryKernel extends OpKernel {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public UnaryKernel(Pointer p) { super(p); }

  /** \brief Executes the kernel.
   * 
   *  @param ctx [in] The function context for the kernel
   *  @param input [in] The kernel input data
   *  @param out [out] The output of the function. Each implementation of this
   *  function might assume different things about the existing contents of out
   *  (e.g. which buffers are preallocated).  In the future it is expected that
   *  there will be a more generic mechanism for understanding the necessary
   *  contracts. */
  public native @ByVal Status Call(FunctionContext ctx, @Const @ByRef Datum input, Datum out);
}
