// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow.global;

import org.bytedeco.arrow.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class arrow extends org.bytedeco.arrow.presets.arrow {
    static { Loader.load(); }

// Targeting ../Byte16Array.java


// Targeting ../BoolVector.java


// Targeting ../StringVector.java


// Targeting ../StringStringPairVector.java


// Targeting ../ScalarVector.java


// Targeting ../FieldVector.java


// Targeting ../ArrayVector.java


// Targeting ../ArrayDataVector.java


// Targeting ../ArrowBufferVector.java


// Targeting ../ArrowBuilderVector.java


// Targeting ../RecordBatchVector.java


// Targeting ../ChunkedArrayVector.java


// Targeting ../SchemaVector.java


// Targeting ../TableVector.java


// Targeting ../ArrayVectorVector.java


// Targeting ../DatumVector.java


// Targeting ../FileStatsVector.java


// Targeting ../Decimal128Pair.java


// Targeting ../StringStringMap.java


// Targeting ../StringDataTypeMap.java


// Parsed from arrow/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Coarse public API while the library is in development

// #ifndef ARROW_API_H
// #define ARROW_API_H

// #include "arrow/array.h"                    // IYWU pragma: export
// #include "arrow/array/concatenate.h"        // IYWU pragma: export
// #include "arrow/buffer.h"                   // IYWU pragma: export
// #include "arrow/builder.h"                  // IYWU pragma: export
// #include "arrow/compare.h"                  // IYWU pragma: export
// #include "arrow/extension_type.h"           // IYWU pragma: export
// #include "arrow/memory_pool.h"              // IYWU pragma: export
// #include "arrow/pretty_print.h"             // IYWU pragma: export
// #include "arrow/record_batch.h"             // IYWU pragma: export
// #include "arrow/result.h"                   // IYWU pragma: export
// #include "arrow/status.h"                   // IYWU pragma: export
// #include "arrow/table.h"                    // IYWU pragma: export
// #include "arrow/table_builder.h"            // IYWU pragma: export
// #include "arrow/tensor.h"                   // IYWU pragma: export
// #include "arrow/type.h"                     // IYWU pragma: export
// #include "arrow/util/config.h"              // IYWU pragma: export
// #include "arrow/util/key_value_metadata.h"  // IWYU pragma: export
// #include "arrow/visitor.h"                  // IYWU pragma: export

/** \brief Top-level namespace for Apache Arrow C++ API */


// #endif  // ARROW_API_H


// Parsed from arrow/util/config.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

public static final int ARROW_VERSION_MAJOR = 0;
public static final int ARROW_VERSION_MINOR = 16;
public static final int ARROW_VERSION_PATCH = 0;
public static final int ARROW_VERSION = ((ARROW_VERSION_MAJOR * 1000) + ARROW_VERSION_MINOR) * 1000 + ARROW_VERSION_PATCH;

public static final String ARROW_SO_VERSION = "16";
public static final String ARROW_FULL_SO_VERSION = "16.0.0";

// #define GRPCPP_PP_INCLUDE


// Parsed from arrow/util/checked_cast.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_CAST_H
// #define ARROW_CAST_H

// #include <memory>
// #include <type_traits>

  // namespace internal
  // namespace arrow

// #endif  // ARROW_CAST_H


// Parsed from arrow/util/macros.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_UTIL_MACROS_H
// #define ARROW_UTIL_MACROS_H

// #include <cstdint>

// #define ARROW_STRINGIFY(x) #x
// #define ARROW_CONCAT(x, y) x##y

// From Google gutil
// #ifndef ARROW_DISALLOW_COPY_AND_ASSIGN
// #define ARROW_DISALLOW_COPY_AND_ASSIGN(TypeName)
//   TypeName(const TypeName&) = delete;
//   void operator=(const TypeName&) = delete
// #endif

// #ifndef ARROW_DEFAULT_MOVE_AND_ASSIGN
// #define ARROW_DEFAULT_MOVE_AND_ASSIGN(TypeName)
//   TypeName(TypeName&&) = default;
//   TypeName& operator=(TypeName&&) = default
// #endif

// #define ARROW_UNUSED(x) (void)(x)
// #define ARROW_ARG_UNUSED(x)
//
// GCC can be told that a certain branch is not likely to be taken (for
// instance, a CHECK failure), and use that information in static analysis.
// Giving it this information can help it optimize for the common case in
// the absence of better information (ie. -fprofile-arcs).
//
// #if defined(__GNUC__)
// #define ARROW_PREDICT_FALSE(x) (__builtin_expect(x, 0))
// #define ARROW_PREDICT_TRUE(x) (__builtin_expect(!!(x), 1))
// #define ARROW_NORETURN __attribute__((noreturn))
// #define ARROW_PREFETCH(addr) __builtin_prefetch(addr)
// #elif defined(_MSC_VER)
// #define ARROW_NORETURN __declspec(noreturn)
// #define ARROW_PREDICT_FALSE(x) x
// #define ARROW_PREDICT_TRUE(x) x
// #define ARROW_PREFETCH(addr)
// #else
// #define ARROW_NORETURN
// #define ARROW_PREDICT_FALSE(x) x
// #define ARROW_PREDICT_TRUE(x) x
// #define ARROW_PREFETCH(addr)
// #endif

// #if (defined(__GNUC__) || defined(__APPLE__))
// #define ARROW_MUST_USE_RESULT __attribute__((warn_unused_result))
// #elif defined(_MSC_VER)
// #define ARROW_MUST_USE_RESULT
// #else
// #define ARROW_MUST_USE_RESULT
// #endif

// ----------------------------------------------------------------------
// C++/CLI support macros (see ARROW-1134)

// #ifndef NULLPTR

// #ifdef __cplusplus_cli
// #else
// #define NULLPTR nullptr
// #endif

// #endif  // ifndef NULLPTR

// ----------------------------------------------------------------------

// clang-format off
// [[deprecated]] is only available in C++14, use this for the time being
// This macro takes an optional deprecation message
// #ifdef __COVERITY__
// #  define ARROW_DEPRECATED(...)
// #elif __cplusplus > 201103L
// #  define ARROW_DEPRECATED(...) [[deprecated(__VA_ARGS__)]]
// #else
// # ifdef __GNUC__
// #  define ARROW_DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
// # elif defined(_MSC_VER)
// #  define ARROW_DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
// # else
// #  define ARROW_DEPRECATED(...)
// # endif
// #endif

// ----------------------------------------------------------------------

// macros to disable padding
// these macros are portable across different compilers and platforms
//[https://github.com/google/flatbuffers/blob/master/include/flatbuffers/flatbuffers.h#L1355]
// #if !defined(MANUALLY_ALIGNED_STRUCT)
// #if defined(_MSC_VER)
// #define MANUALLY_ALIGNED_STRUCT(alignment)
//   __pragma(pack(1));
//   struct __declspec(align(alignment))
// #define STRUCT_END(name, size)
//   __pragma(pack());
//   static_assert(sizeof(name) == size, "compiler breaks packing rules")
// #elif defined(__GNUC__) || defined(__clang__)
// #define MANUALLY_ALIGNED_STRUCT(alignment)
//   _Pragma("pack(1)") struct __attribute__((aligned(alignment)))
// #define STRUCT_END(name, size)
//   _Pragma("pack()") static_assert(sizeof(name) == size, "compiler breaks packing rules")
// #else
// #error Unknown compiler, please define structure alignment macros
// #endif
// #endif  // !defined(MANUALLY_ALIGNED_STRUCT)

// ----------------------------------------------------------------------
// Convenience macro disabling a particular UBSan check in a function

// #if defined(__clang__)
// #define ARROW_DISABLE_UBSAN(feature) __attribute__((no_sanitize(feature)))
// #else
// #define ARROW_DISABLE_UBSAN(feature)
// #endif

// ----------------------------------------------------------------------
// Machine information

// #if INTPTR_MAX == INT64_MAX
public static native @MemberGetter int ARROW_BITNESS();
public static final int ARROW_BITNESS = ARROW_BITNESS();
// #elif INTPTR_MAX == INT32_MAX
// #else
// #error Unexpected INTPTR_MAX
// #endif

// ----------------------------------------------------------------------
// From googletest
// (also in parquet-cpp)

// When you need to test the private or protected members of a class,
// use the FRIEND_TEST macro to declare your tests as friends of the
// class.  For example:
//
// class MyClass {
//  private:
//   void MyMethod();
//   FRIEND_TEST(MyClassTest, MyMethod);
// };
//
// class MyClassTest : public testing::Test {
//   // ...
// };
//
// TEST_F(MyClassTest, MyMethod) {
//   // Can call MyClass::MyMethod() here.
// }

// #define FRIEND_TEST(test_case_name, test_name)
//   friend class test_case_name##_##test_name##_Test

// #endif  // ARROW_UTIL_MACROS_H


// Parsed from arrow/util/type_traits.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_UTIL_TYPE_TRAITS_H
// #define ARROW_UTIL_TYPE_TRAITS_H

// #include <type_traits>

/** \brief Metafunction to allow checking if a type matches any of another set of types */  /** Base case: nothing has matched */

/** \brief Shorthand for using IsOneOf + std::enable_if */

/** \brief is_null_pointer from C++17 */

  // namespace internal
  // namespace arrow

// #endif  // ARROW_UTIL_TYPE_TRAITS_H


// Parsed from arrow/util/visibility.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_UTIL_VISIBILITY_H
// #define ARROW_UTIL_VISIBILITY_H

// #if defined(_WIN32) || defined(__CYGWIN__)
// #if defined(_MSC_VER)
// #pragma warning(disable : 4251)
// #else
// #pragma GCC diagnostic ignored "-Wattributes"
// #endif

// #ifdef ARROW_STATIC
// #define ARROW_EXPORT
// #elif defined(ARROW_EXPORTING)
// #define ARROW_EXPORT __declspec(dllexport)
// #else
// #define ARROW_EXPORT __declspec(dllimport)
// #endif

// #define ARROW_NO_EXPORT
// #define ARROW_FORCE_INLINE __forceinline
// #else  // Not Windows
// #ifndef ARROW_EXPORT
// #define ARROW_EXPORT __attribute__((visibility("default")))
// #endif
// #ifndef ARROW_NO_EXPORT
// #define ARROW_NO_EXPORT __attribute__((visibility("hidden")))
// #define ARROW_FORCE_INLINE
// #endif
// #endif  // Non-Windows

// #endif  // ARROW_UTIL_VISIBILITY_H


// Parsed from arrow/util/compression.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <limits>
// #include <memory>
// #include <string>

// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ../Compression.java




///
@Namespace("arrow::util") @MemberGetter public static native int kUseDefaultCompressionLevel();
// Targeting ../Compressor.java


// Targeting ../Decompressor.java


// Targeting ../Codec.java



  // namespace util
  // namespace arrow


// Parsed from arrow/util/functional.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <tuple>
// #include <type_traits>

// #include "arrow/util/macros.h"
// Targeting ../call_traits.java



  // namespace internal
  // namespace arrow


// Parsed from arrow/util/iterator.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cassert>
// #include <functional>
// #include <memory>
// #include <tuple>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/functional.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/optional.h"
// #include "arrow/util/visibility.h"
// Targeting ../BufferIterator.java


// Targeting ../RecordBatchIterator.java



/** \brief Construct an Iterator which invokes a callable on Next() */

/** \brief Simple iterator which yields the elements of a std::vector */

/** \brief Simple iterator which yields the elements of a std::vector<T> as optional<T>.
 *  This is provided to support T where IterationTraits<T>::End is not specialized */

/** \brief MapIterator takes ownership of an iterator and a function to apply
 *  on every element. The mapped function is not allowed to fail. */

/** \brief MapIterator takes ownership of an iterator and a function to apply
 *  on every element. The mapped function is not allowed to fail. */
// Targeting ../FilterIterator.java



/** \brief Like MapIterator, but where the function can fail or reject elements. */

/** \brief FlattenIterator takes an iterator generating iterators and yields a
 *  unified iterator that flattens/concatenates in a single stream. */
// Targeting ../ReadaheadPromise.java


// Targeting ../ReadaheadQueue.java



  // namespace detail

/** \brief Readahead iterator that iterates on the underlying iterator in a
 *  separate thread, getting up to N values in advance. */

  // namespace arrow


// Parsed from arrow/util/memory.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_UTIL_MEMORY_H
// #define ARROW_UTIL_MEMORY_H

// #include <cstdint>
// #include <memory>

// #include "arrow/util/macros.h"

// A helper function for doing memcpy with multiple threads. This is required
// to saturate the memory bandwidth of modern cpus.


// A helper function for checking if two wrapped objects implementing `Equals`
// are equal.

  // namespace internal
  // namespace arrow

// #endif  // ARROW_UTIL_MEMORY_H


// Parsed from arrow/util/variant.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_UTIL_VARIANT_H
// #define ARROW_UTIL_VARIANT_H

// #include "arrow/vendored/variant.hpp"  // IWYU pragma: export

  // namespace util
  // namespace arrow

// #endif  // ARROW_UTIL_VARIANT_H


// Parsed from arrow/util/bit_util.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #ifdef _WIN32
public static native @MemberGetter int ARROW_LITTLE_ENDIAN();
public static final int ARROW_LITTLE_ENDIAN = ARROW_LITTLE_ENDIAN();
// #else
// #if defined(__APPLE__) || defined(__FreeBSD__)
// #include <machine/endian.h>
// #else
// #include <endian.h>
// #endif
// #
// #ifndef __BYTE_ORDER__
// #error "__BYTE_ORDER__ not defined"
// #endif
// #
// #ifndef __ORDER_LITTLE_ENDIAN__
// #error "__ORDER_LITTLE_ENDIAN__ not defined"
// #endif
// #
// #if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
// #else
// #endif
// #endif

// #if defined(_MSC_VER)
// #include <intrin.h>
// #pragma intrinsic(_BitScanReverse)
// #pragma intrinsic(_BitScanForward)
// #define ARROW_BYTE_SWAP64 _byteswap_uint64
// #define ARROW_BYTE_SWAP32 _byteswap_ulong
// #else
// #define ARROW_BYTE_SWAP64 __builtin_bswap64
// #define ARROW_BYTE_SWAP32 __builtin_bswap32
// #endif

// #include <algorithm>
// #include <array>
// #include <bitset>
// #include <cassert>
// #include <cmath>
// #include <cstdint>
// #include <cstring>
// #include <limits>
// #include <memory>
// #include <string>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/buffer.h"
// #include "arrow/result.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/functional.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_builder.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/type_traits.h"
// #include "arrow/util/visibility.h"

  // namespace detail

// The number of set bits in a given unsigned byte value, pre-computed
//
// Generated with the following Python code
// output = 'static constexpr uint8_t kBytePopcount[] = {{{0}}};'
// popcounts = [str(bin(i).count('1')) for i in range(0, 256)]
// print(output.format(', '.join(popcounts)))
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kBytePopcount(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kBytePopcount();

//
// Bit-related computations on integer values
//

// Returns the ceil of value/divisor
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long CeilDiv(@Cast("int64_t") long value, @Cast("int64_t") long divisor);

@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long BytesForBits(@Cast("int64_t") long bits);

@Namespace("arrow::BitUtil") public static native @Cast("const bool") boolean IsPowerOf2(@Cast("int64_t") long value);

// Returns the smallest power of two that contains v.  If v is already a
// power of two, it is returned as is.
@Namespace("arrow::BitUtil") public static native @Cast("int64_t") long NextPower2(@Cast("int64_t") long n);

@Namespace("arrow::BitUtil") public static native @Cast("const bool") boolean IsMultipleOf64(@Cast("int64_t") long n);

@Namespace("arrow::BitUtil") public static native @Cast("const bool") boolean IsMultipleOf8(@Cast("int64_t") long n);

// Returns 'value' rounded up to the nearest multiple of 'factor'
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUp(@Cast("int64_t") long value, @Cast("int64_t") long factor);

// Returns 'value' rounded down to the nearest multiple of 'factor'
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundDown(@Cast("int64_t") long value, @Cast("int64_t") long factor);

// Returns 'value' rounded up to the nearest multiple of 'factor' when factor
// is a power of two.
// The result is undefined on overflow, i.e. if `value > 2**64 - factor`,
// since we cannot return the correct result which would be 2**64.
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUpToPowerOf2(@Cast("int64_t") long value, @Cast("int64_t") long factor);

@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUpToMultipleOf8(@Cast("int64_t") long num);

@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUpToMultipleOf64(@Cast("int64_t") long num);

// Returns the number of bytes covering a sliced bitmap. Find the length
// rounded to cover full bytes on both extremities.
//
// The following example represents a slice (offset=10, length=9)
//
// 0       8       16     24
// |-------|-------|------|
//           [       ]          (slice)
//         [             ]      (same slice aligned to bytes bounds, length=16)
//
// The covering bytes is the length (in bytes) of this new aligned slice.
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long CoveringBytes(@Cast("int64_t") long offset, @Cast("int64_t") long length);

// Returns the 'num_bits' least-significant bits of 'v'.
@Namespace("arrow::BitUtil") public static native @Cast("uint64_t") long TrailingBits(@Cast("uint64_t") long v, int num_bits);

/** \brief Count the number of leading zeros in an unsigned integer. */
@Namespace("arrow::BitUtil") public static native int CountLeadingZeros(@Cast("uint32_t") int value);

@Namespace("arrow::BitUtil") public static native int CountLeadingZeros(@Cast("uint64_t") long value);

@Namespace("arrow::BitUtil") public static native int CountTrailingZeros(@Cast("uint32_t") int value);

@Namespace("arrow::BitUtil") public static native int CountTrailingZeros(@Cast("uint64_t") long value);

// Returns the minimum number of bits needed to represent an unsigned value
@Namespace("arrow::BitUtil") public static native int NumRequiredBits(@Cast("uint64_t") long x);

// Returns ceil(log2(x)).
@Namespace("arrow::BitUtil") public static native int Log2(@Cast("uint64_t") long x);

//
// Byte-swap 16-bit, 32-bit and 64-bit values
//

// Swap the byte order (i.e. endianness)
@Namespace("arrow::BitUtil") public static native @Cast("int64_t") long ByteSwap(@Cast("int64_t") long value);
@Namespace("arrow::BitUtil") public static native int ByteSwap(int value);
@Namespace("arrow::BitUtil") public static native short ByteSwap(short value);

// Write the swapped bytes into dst. Src and dst cannot overlap.
@Namespace("arrow::BitUtil") public static native void ByteSwap(Pointer dst, @Const Pointer src, int len);

// Convert to little/big endian format from the machine's native endian format.
// #if ARROW_LITTLE_ENDIAN
// #else
// #endif

// Convert from big/little endian format to the machine's native endian format.
// #if ARROW_LITTLE_ENDIAN
// #else
// #endif

//
// Utilities for reading and writing individual bits by their index
// in a memory area.
//

// Bitmask selecting the k-th bit in a byte
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kBitmask();

// the bitwise complement version of kBitmask
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kFlippedBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kFlippedBitmask();

// Bitmask selecting the (k - 1) preceding bits in a byte
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kPrecedingBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kPrecedingBitmask();
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kPrecedingWrappingBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kPrecedingWrappingBitmask();

// the bitwise complement version of kPrecedingBitmask
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kTrailingBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kTrailingBitmask();

@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBit(@Cast("const uint8_t*") BytePointer bits, @Cast("uint64_t") long i);
@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBit(@Cast("const uint8_t*") ByteBuffer bits, @Cast("uint64_t") long i);
@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBit(@Cast("const uint8_t*") byte[] bits, @Cast("uint64_t") long i);

// Gets the i-th bit from a byte. Should only be used with i <= 7.
@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBitFromByte(@Cast("uint8_t") byte _byte, @Cast("uint8_t") byte i);

@Namespace("arrow::BitUtil") public static native void ClearBit(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void ClearBit(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void ClearBit(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long i);

@Namespace("arrow::BitUtil") public static native void SetBit(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void SetBit(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void SetBit(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long i);

@Namespace("arrow::BitUtil") public static native void SetBitTo(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long i, @Cast("bool") boolean bit_is_set);
@Namespace("arrow::BitUtil") public static native void SetBitTo(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long i, @Cast("bool") boolean bit_is_set);
@Namespace("arrow::BitUtil") public static native void SetBitTo(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long i, @Cast("bool") boolean bit_is_set);

/** \brief set or clear a range of bits quickly */
@Namespace("arrow::BitUtil") public static native void SetBitsTo(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long start_offset, @Cast("int64_t") long length,
                             @Cast("bool") boolean bits_are_set);
@Namespace("arrow::BitUtil") public static native void SetBitsTo(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long start_offset, @Cast("int64_t") long length,
                             @Cast("bool") boolean bits_are_set);
@Namespace("arrow::BitUtil") public static native void SetBitsTo(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long start_offset, @Cast("int64_t") long length,
                             @Cast("bool") boolean bits_are_set);

/** \brief Convert vector of bytes to bitmap buffer */
@Namespace("arrow::BitUtil") public static native @ByVal BufferResult BytesToBits(@Cast("uint8_t*") @StdVector BytePointer arg0,
                                            MemoryPool pool/*=default_memory_pool()*/);
@Namespace("arrow::BitUtil") public static native @ByVal BufferResult BytesToBits(@Cast("uint8_t*") @StdVector BytePointer arg0);
@Namespace("arrow::BitUtil") public static native @ByVal BufferResult BytesToBits(@Cast("uint8_t*") @StdVector ByteBuffer arg0,
                                            MemoryPool pool/*=default_memory_pool()*/);
@Namespace("arrow::BitUtil") public static native @ByVal BufferResult BytesToBits(@Cast("uint8_t*") @StdVector ByteBuffer arg0);
@Namespace("arrow::BitUtil") public static native @ByVal BufferResult BytesToBits(@Cast("uint8_t*") @StdVector byte[] arg0,
                                            MemoryPool pool/*=default_memory_pool()*/);
@Namespace("arrow::BitUtil") public static native @ByVal BufferResult BytesToBits(@Cast("uint8_t*") @StdVector byte[] arg0);


// Targeting ../BitmapReader.java


// Targeting ../BitmapWriter.java


// Targeting ../FirstTimeBitmapWriter.java



// A std::generate() like function to write sequential bits into a bitmap area.
// Bits preceding the bitmap area are preserved, bits following the bitmap
// area may be clobbered.

// Like GenerateBits(), but unrolls its main loop for higher performance.

// A function that visits each bit in a bitmap and calls a visitor function with a
// boolean representation of that bit. This is intended to be analogous to
// GenerateBits.

// Like VisitBits(), but unrolls its main loop for better performance.

// ----------------------------------------------------------------------
// Bitmap utilities

/** Copy a bit range of an existing bitmap
 * 
 *  @param pool [in] memory pool to allocate memory from
 *  @param bitmap [in] source data
 *  @param offset [in] bit offset into the source data
 *  @param length [in] number of bits to copy
 * 
 *  @return Status message */

///
@Namespace("arrow::internal") public static native @ByVal BufferResult CopyBitmap(MemoryPool pool, @Cast("const uint8_t*") BytePointer bitmap,
                                           @Cast("int64_t") long offset, @Cast("int64_t") long length);
@Namespace("arrow::internal") public static native @ByVal BufferResult CopyBitmap(MemoryPool pool, @Cast("const uint8_t*") ByteBuffer bitmap,
                                           @Cast("int64_t") long offset, @Cast("int64_t") long length);
@Namespace("arrow::internal") public static native @ByVal BufferResult CopyBitmap(MemoryPool pool, @Cast("const uint8_t*") byte[] bitmap,
                                           @Cast("int64_t") long offset, @Cast("int64_t") long length);

/** Copy a bit range of an existing bitmap into an existing bitmap
 * 
 *  @param bitmap [in] source data
 *  @param offset [in] bit offset into the source data
 *  @param length [in] number of bits to copy
 *  @param dest_offset [in] bit offset into the destination
 *  @param restore_trailing_bits [in] don't clobber bits outside the destination range
 *  @param dest [out] the destination buffer, must have at least space for
 *  (offset + length) bits */

///
@Namespace("arrow::internal") public static native void CopyBitmap(@Cast("const uint8_t*") BytePointer bitmap, @Cast("int64_t") long offset, @Cast("int64_t") long length, @Cast("uint8_t*") BytePointer dest,
                @Cast("int64_t") long dest_offset, @Cast("bool") boolean restore_trailing_bits/*=true*/);
@Namespace("arrow::internal") public static native void CopyBitmap(@Cast("const uint8_t*") BytePointer bitmap, @Cast("int64_t") long offset, @Cast("int64_t") long length, @Cast("uint8_t*") BytePointer dest,
                @Cast("int64_t") long dest_offset);
@Namespace("arrow::internal") public static native void CopyBitmap(@Cast("const uint8_t*") ByteBuffer bitmap, @Cast("int64_t") long offset, @Cast("int64_t") long length, @Cast("uint8_t*") ByteBuffer dest,
                @Cast("int64_t") long dest_offset, @Cast("bool") boolean restore_trailing_bits/*=true*/);
@Namespace("arrow::internal") public static native void CopyBitmap(@Cast("const uint8_t*") ByteBuffer bitmap, @Cast("int64_t") long offset, @Cast("int64_t") long length, @Cast("uint8_t*") ByteBuffer dest,
                @Cast("int64_t") long dest_offset);
@Namespace("arrow::internal") public static native void CopyBitmap(@Cast("const uint8_t*") byte[] bitmap, @Cast("int64_t") long offset, @Cast("int64_t") long length, @Cast("uint8_t*") byte[] dest,
                @Cast("int64_t") long dest_offset, @Cast("bool") boolean restore_trailing_bits/*=true*/);
@Namespace("arrow::internal") public static native void CopyBitmap(@Cast("const uint8_t*") byte[] bitmap, @Cast("int64_t") long offset, @Cast("int64_t") long length, @Cast("uint8_t*") byte[] dest,
                @Cast("int64_t") long dest_offset);

/** Invert a bit range of an existing bitmap into an existing bitmap
 * 
 *  @param bitmap [in] source data
 *  @param offset [in] bit offset into the source data
 *  @param length [in] number of bits to copy
 *  @param dest_offset [in] bit offset into the destination
 *  @param dest [out] the destination buffer, must have at least space for
 *  (offset + length) bits */


/** Invert a bit range of an existing bitmap
 * 
 *  @param pool [in] memory pool to allocate memory from
 *  @param bitmap [in] source data
 *  @param offset [in] bit offset into the source data
 *  @param length [in] number of bits to copy
 * 
 *  @return Status message */


/** Compute the number of 1's in the given data array
 * 
 *  @param data [in] a packed LSB-ordered bitmap as a byte array
 *  @param bit_offset [in] a bitwise offset into the bitmap
 *  @param length [in] the number of bits to inspect in the bitmap relative to
 *  the offset
 * 
 *  @return The number of set (1) bits in the range */
@Namespace("arrow::internal") public static native @Cast("int64_t") long CountSetBits(@Cast("const uint8_t*") BytePointer data, @Cast("int64_t") long bit_offset, @Cast("int64_t") long length);
@Namespace("arrow::internal") public static native @Cast("int64_t") long CountSetBits(@Cast("const uint8_t*") ByteBuffer data, @Cast("int64_t") long bit_offset, @Cast("int64_t") long length);
@Namespace("arrow::internal") public static native @Cast("int64_t") long CountSetBits(@Cast("const uint8_t*") byte[] data, @Cast("int64_t") long bit_offset, @Cast("int64_t") long length);


///
@Namespace("arrow::internal") public static native @Cast("bool") boolean BitmapEquals(@Cast("const uint8_t*") BytePointer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
                  @Cast("int64_t") long right_offset, @Cast("int64_t") long bit_length);
@Namespace("arrow::internal") public static native @Cast("bool") boolean BitmapEquals(@Cast("const uint8_t*") ByteBuffer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
                  @Cast("int64_t") long right_offset, @Cast("int64_t") long bit_length);
@Namespace("arrow::internal") public static native @Cast("bool") boolean BitmapEquals(@Cast("const uint8_t*") byte[] left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
                  @Cast("int64_t") long right_offset, @Cast("int64_t") long bit_length);

/** \brief Do a "bitmap and" on right and left buffers starting at
 *  their respective bit-offsets for the given bit-length and put
 *  the results in out_buffer starting at the given bit-offset.
 * 
 *  out_buffer will be allocated and initialized to zeros using pool before
 *  the operation. */
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapAnd(MemoryPool pool, @Cast("const uint8_t*") BytePointer left,
                                          @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
                                          @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                          @Cast("int64_t") long out_offset);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapAnd(MemoryPool pool, @Cast("const uint8_t*") ByteBuffer left,
                                          @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
                                          @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                          @Cast("int64_t") long out_offset);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapAnd(MemoryPool pool, @Cast("const uint8_t*") byte[] left,
                                          @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
                                          @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                          @Cast("int64_t") long out_offset);

/** \brief Do a "bitmap and" on right and left buffers starting at
 *  their respective bit-offsets for the given bit-length and put
 *  the results in out starting at the given bit-offset. */

///
@Namespace("arrow::internal") public static native void BitmapAnd(@Cast("const uint8_t*") BytePointer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
               @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") BytePointer out);
@Namespace("arrow::internal") public static native void BitmapAnd(@Cast("const uint8_t*") ByteBuffer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
               @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") ByteBuffer out);
@Namespace("arrow::internal") public static native void BitmapAnd(@Cast("const uint8_t*") byte[] left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
               @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") byte[] out);

/** \brief Do a "bitmap or" for the given bit length on right and left buffers
 *  starting at their respective bit-offsets and put the results in out_buffer
 *  starting at the given bit-offset.
 * 
 *  out_buffer will be allocated and initialized to zeros using pool before
 *  the operation. */
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapOr(MemoryPool pool, @Cast("const uint8_t*") BytePointer left,
                                         @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
                                         @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                         @Cast("int64_t") long out_offset);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapOr(MemoryPool pool, @Cast("const uint8_t*") ByteBuffer left,
                                         @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
                                         @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                         @Cast("int64_t") long out_offset);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapOr(MemoryPool pool, @Cast("const uint8_t*") byte[] left,
                                         @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
                                         @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                         @Cast("int64_t") long out_offset);

/** \brief Do a "bitmap or" for the given bit length on right and left buffers
 *  starting at their respective bit-offsets and put the results in out
 *  starting at the given bit-offset. */

///
@Namespace("arrow::internal") public static native void BitmapOr(@Cast("const uint8_t*") BytePointer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
              @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") BytePointer out);
@Namespace("arrow::internal") public static native void BitmapOr(@Cast("const uint8_t*") ByteBuffer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
              @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") ByteBuffer out);
@Namespace("arrow::internal") public static native void BitmapOr(@Cast("const uint8_t*") byte[] left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
              @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") byte[] out);

/** \brief Do a "bitmap xor" for the given bit-length on right and left
 *  buffers starting at their respective bit-offsets and put the results in
 *  out_buffer starting at the given bit offset.
 * 
 *  out_buffer will be allocated and initialized to zeros using pool before
 *  the operation. */
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapXor(MemoryPool pool, @Cast("const uint8_t*") BytePointer left,
                                          @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
                                          @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                          @Cast("int64_t") long out_offset);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapXor(MemoryPool pool, @Cast("const uint8_t*") ByteBuffer left,
                                          @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
                                          @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                          @Cast("int64_t") long out_offset);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapXor(MemoryPool pool, @Cast("const uint8_t*") byte[] left,
                                          @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
                                          @Cast("int64_t") long right_offset, @Cast("int64_t") long length,
                                          @Cast("int64_t") long out_offset);

/** \brief Do a "bitmap xor" for the given bit-length on right and left
 *  buffers starting at their respective bit-offsets and put the results in
 *  out starting at the given bit offset. */
@Namespace("arrow::internal") public static native void BitmapXor(@Cast("const uint8_t*") BytePointer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") BytePointer right,
               @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") BytePointer out);
@Namespace("arrow::internal") public static native void BitmapXor(@Cast("const uint8_t*") ByteBuffer left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") ByteBuffer right,
               @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") ByteBuffer out);
@Namespace("arrow::internal") public static native void BitmapXor(@Cast("const uint8_t*") byte[] left, @Cast("int64_t") long left_offset, @Cast("const uint8_t*") byte[] right,
               @Cast("int64_t") long right_offset, @Cast("int64_t") long length, @Cast("int64_t") long out_offset, @Cast("uint8_t*") byte[] out);

/** \brief Generate Bitmap with all position to {@code value} except for one found
 *  at {@code straggler_pos}. */
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapAllButOne(MemoryPool pool, @Cast("int64_t") long length,
                                                @Cast("int64_t") long straggler_pos, @Cast("bool") boolean value/*=true*/);
@Namespace("arrow::internal") public static native @ByVal BufferResult BitmapAllButOne(MemoryPool pool, @Cast("int64_t") long length,
                                                @Cast("int64_t") long straggler_pos);
// Targeting ../BitsetStack.java



  // namespace internal
  // namespace arrow


// Parsed from arrow/util/ubsan.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Contains utilities for making UBSan happy.

// #pragma once

// #include <cstring>
// #include <memory>
// #include <type_traits>

// #include "arrow/util/macros.h"



  // namespace internal

/** \brief Returns maybe_null if not null or a non-null pointer to an arbitrary memory
 *  that shouldn't be dereferenced.
 * 
 *  Memset/Memcpy are undefined when a nullptr is passed as an argument use this utility
 *  method to wrap locations where this could happen.
 * 
 *  Note: Flatbuffers has UBSan warnings if a zero length vector is passed.
 *  https://github.com/google/flatbuffers/pull/5355 is trying to resolve
 *  them. */

  // namespace util
  // namespace arrow


// Parsed from arrow/util/key_value_metadata.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_UTIL_KEY_VALUE_METADATA_H
// #define ARROW_UTIL_KEY_VALUE_METADATA_H

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../KeyValueMetadata.java



/** \brief Create a KeyValueMetadata instance
 * 
 *  @param pairs key-value mapping */

///
@Namespace("arrow") public static native @SharedPtr KeyValueMetadata key_value_metadata(@Const @ByRef StringStringMap pairs);

/** \brief Create a KeyValueMetadata instance
 * 
 *  @param keys sequence of metadata keys
 *  @param values sequence of corresponding metadata values */
@Namespace("arrow") public static native @SharedPtr KeyValueMetadata key_value_metadata(
    @Const @ByRef StringVector keys, @Const @ByRef StringVector values);

  // namespace arrow

// #endif  //  ARROW_UTIL_KEY_VALUE_METADATA_H


// Parsed from arrow/util/string_builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License. template <typename T>

// #ifndef ARROW_UTIL_STRING_BUILDER_H
// #define ARROW_UTIL_STRING_BUILDER_H

// #include <memory>
// #include <ostream>
// #include <string>
// #include <utility>

// #include "arrow/util/visibility.h"
// Targeting ../StringStreamWrapper.java



  // namespace detail

/** CRTP helper for declaring string representation. Defines operator<< */

  // namespace util
  // namespace arrow

// #endif  // ARROW_UTIL_STRING_BUILDER_H


// Parsed from arrow/status.h

// Copyright (c) 2011 The LevelDB Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file. See the AUTHORS file for names of contributors.
//
// A Status encapsulates the result of an operation.  It may indicate success,
// or it may indicate an error with an associated error message.
//
// Multiple threads can invoke const methods on a Status without
// external synchronization, but if any of the threads may call a
// non-const method, all threads accessing the same Status must use
// external synchronization.

// Adapted from Apache Kudu, TensorFlow

// #pragma once

// #include <cstring>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <utility>

// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_builder.h"
// #include "arrow/util/visibility.h"

// #ifdef ARROW_EXTRA_ERROR_CONTEXT

// #else

// #define ARROW_RETURN_IF_(condition, status, _)
//   do {
//     if (ARROW_PREDICT_FALSE(condition)) {
//       return (status);
//     }
//   } while (0)

// #endif  // ARROW_EXTRA_ERROR_CONTEXT

// #define ARROW_RETURN_IF(condition, status)
//   ARROW_RETURN_IF_(condition, status, ARROW_STRINGIFY(status))

/** \brief Propagate any non-successful Status to the caller */
// #define ARROW_RETURN_NOT_OK(status)
//   do {
//     ::arrow::Status __s = ::arrow::internal::GenericToStatus(status);
//     ARROW_RETURN_IF_(!__s.ok(), __s, ARROW_STRINGIFY(status));
//   } while (false)

// #define RETURN_NOT_OK_ELSE(s, else_)
//   do {
//     ::arrow::Status _s = ::arrow::internal::GenericToStatus(s);
//     if (!_s.ok()) {
//       else_;
//       return _s;
//     }
//   } while (false)

// This is an internal-use macro and should not be used in public headers.
// #ifndef RETURN_NOT_OK
// #define RETURN_NOT_OK(s) ARROW_RETURN_NOT_OK(s)
// #endif

@Namespace("arrow") public enum StatusCode {
  OK((byte)0),
  OutOfMemory((byte)1),
  KeyError((byte)2),
  TypeError((byte)3),
  Invalid((byte)4),
  IOError((byte)5),
  CapacityError((byte)6),
  IndexError((byte)7),
  UnknownError((byte)9),
  NotImplemented((byte)10),
  SerializationError((byte)11),
  RError((byte)13),
  // Gandiva range of errors
  CodeGenError((byte)40),
  ExpressionValidationError((byte)41),
  ExecutionError((byte)42),
  // Continue generic codes.
  AlreadyExists((byte)45);

    public final byte value;
    private StatusCode(byte v) { this.value = v; }
    private StatusCode(StatusCode e) { this.value = e.value; }
    public StatusCode intern() { for (StatusCode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

// #if defined(__clang__)
// Only clang supports warn_unused_result as a type annotation.
// Targeting ../StatusDetail.java


// Targeting ../Status.java















/** \cond FALSE */
// (note: emits warnings on Doxygen < 1.8.15,
//  see https://github.com/doxygen/doxygen/issues/6295)







/** \endcond */

// Extract Status from Status or Result<T>
// Useful for the status check macros such as RETURN_NOT_OK.
@Namespace("arrow::internal") public static native @ByVal Status GenericToStatus(@Const @ByRef Status st);

  // namespace internal

  // namespace arrow


// Parsed from arrow/memory_pool.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_MEMORY_POOL_H
// #define ARROW_MEMORY_POOL_H

// #include <atomic>
// #include <cstdint>
// #include <memory>
// #include <string>

// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ../MemoryPoolStats.java




// Targeting ../MemoryPool.java


// Targeting ../LoggingMemoryPool.java


// Targeting ../ProxyMemoryPool.java



/** Return a process-wide memory pool based on the system allocator. */

///
@Namespace("arrow") public static native MemoryPool system_memory_pool();

/** Return a process-wide memory pool based on jemalloc.
 * 
 *  May return NotImplemented if jemalloc is not available. */
@Namespace("arrow") public static native @ByVal Status jemalloc_memory_pool(@Cast("arrow::MemoryPool**") PointerPointer out);
@Namespace("arrow") public static native @ByVal Status jemalloc_memory_pool(@ByPtrPtr MemoryPool out);

/** \brief Set jemalloc memory page purging behavior for future-created arenas
 *  to the indicated number of milliseconds. See dirty_decay_ms and
 *  muzzy_decay_ms options in jemalloc for a description of what these do. The
 *  default is configured to 1000 (1 second) which releases memory more
 *  aggressively to the operating system than the jemalloc default of 10
 *  seconds. If you set the value to 0, dirty / muzzy pages will be released
 *  immediately rather than with a time decay, but this may reduce application
 *  performance. */

///
@Namespace("arrow") public static native @ByVal Status jemalloc_set_decay_ms(int ms);

/** Return a process-wide memory pool based on mimalloc.
 * 
 *  May return NotImplemented if mimalloc is not available. */
@Namespace("arrow") public static native @ByVal Status mimalloc_memory_pool(@Cast("arrow::MemoryPool**") PointerPointer out);
@Namespace("arrow") public static native @ByVal Status mimalloc_memory_pool(@ByPtrPtr MemoryPool out);

  // namespace arrow

// #endif  // ARROW_MEMORY_POOL_H


// Parsed from arrow/buffer.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_BUFFER_H
// #define ARROW_BUFFER_H

// #include <cstdint>
// #include <cstring>
// #include <memory>
// #include <string>
// #include <type_traits>
// #include <vector>

// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ../ArrowBuffer.java




///
///

/** \defgroup buffer-slicing-functions Functions for slicing buffers
 * 
 *  \{
 <p>
 *  \brief Construct a view on a buffer at the given offset and length.
 * 
 *  This function cannot fail and does not check for errors (except in debug builds) */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceBuffer(@SharedPtr ArrowBuffer buffer,
                                                  @Cast("const int64_t") long offset,
                                                  @Cast("const int64_t") long length);

/** \brief Construct a view on a buffer at the given offset, up to the buffer's end.
 * 
 *  This function cannot fail and does not check for errors (except in debug builds) */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceBuffer(@SharedPtr ArrowBuffer buffer,
                                                  @Cast("const int64_t") long offset);

/** \brief Like SliceBuffer, but construct a mutable buffer slice.
 * 
 *  If the parent buffer is not mutable, behavior is undefined (it may abort
 *  in debug builds). */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceMutableBuffer(@SharedPtr ArrowBuffer buffer,
                                           @Cast("const int64_t") long offset, @Cast("const int64_t") long length);

/** \brief Like SliceBuffer, but construct a mutable buffer slice.
 * 
 *  If the parent buffer is not mutable, behavior is undefined (it may abort
 *  in debug builds). */
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceMutableBuffer(
    @SharedPtr ArrowBuffer buffer, @Cast("const int64_t") long offset);
// Targeting ../MutableBuffer.java


// Targeting ../ResizableBuffer.java



/** \defgroup buffer-allocation-functions Functions for allocating buffers
 * 
 *  \{
 <p>
 *  \brief Allocate a fixed size mutable buffer from a memory pool, zero its padding.
 * 
 *  @param pool [in] a memory pool
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer (contains padding)
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateBuffer(MemoryPool pool, @Cast("const int64_t") long size, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Allocate a fixed size mutable buffer from a memory pool, zero its padding.
 * 
 *  @param pool [in] a memory pool
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer (contains padding)
 * 
 *  @return Status message */

/** \brief Allocate a fixed-size mutable buffer from the default memory pool
 * 
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer (contains padding)
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateBuffer(@Cast("const int64_t") long size, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Allocate a fixed-size mutable buffer from the default memory pool
 * 
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer (contains padding)
 * 
 *  @return Status message */

/** \brief Allocate a resizeable buffer from a memory pool, zero its padding.
 * 
 *  @param pool [in] a memory pool
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateResizableBuffer(MemoryPool pool, @Cast("const int64_t") long size,
                               @SharedPtr ResizableBuffer out);

/** \brief Allocate a resizeable buffer from a memory pool, zero its padding.
 * 
 *  @param pool [in] a memory pool
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer
 * 
 *  @return Status message */

/** \brief Allocate a resizeable buffer from the default memory pool
 * 
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateResizableBuffer(@Cast("const int64_t") long size, @SharedPtr ResizableBuffer out);

/** \brief Allocate a resizeable buffer from the default memory pool
 * 
 *  @param size [in] size of buffer to allocate
 *  @param out [out] the allocated buffer
 * 
 *  @return Status message */

/** \brief Allocate a bitmap buffer from a memory pool
 *  no guarantee on values is provided.
 * 
 *  @param pool [in] memory pool to allocate memory from
 *  @param length [in] size in bits of bitmap to allocate
 *  @param out [out] the resulting buffer
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateBitmap(MemoryPool pool, @Cast("int64_t") long length, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Allocate a zero-initialized bitmap buffer from a memory pool
 * 
 *  @param pool [in] memory pool to allocate memory from
 *  @param length [in] size in bits of bitmap to allocate
 *  @param out [out] the resulting buffer (zero-initialized).
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateEmptyBitmap(MemoryPool pool, @Cast("int64_t") long length,
                           @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Allocate a zero-initialized bitmap buffer from the default memory pool
 * 
 *  @param length [in] size in bits of bitmap to allocate
 *  @param out [out] the resulting buffer
 * 
 *  @return Status message */

///
///
@Namespace("arrow") public static native @ByVal Status AllocateEmptyBitmap(@Cast("int64_t") long length, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Concatenate multiple buffers into a single buffer
 * 
 *  @param buffers [in] to be concatenated
 *  @param pool [in] memory pool to allocate the new buffer from
 *  @param out [out] the concatenated buffer
 * 
 *  @return Status */
@Namespace("arrow") public static native @ByVal Status ConcatenateBuffers(@Cast("const arrow::BufferVector*") @ByRef ArrowBufferVector buffers, MemoryPool pool,
                          @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \} */

  // namespace arrow

// #endif  // ARROW_BUFFER_H


// Parsed from arrow/buffer_builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_BUFFER_BUILDER_H
// #define ARROW_BUFFER_BUILDER_H

// #include <algorithm>
// #include <cstdint>
// #include <cstring>
// #include <memory>
// #include <string>
// #include <utility>

// #include "arrow/buffer.h"
// #include "arrow/status.h"
// #include "arrow/util/bit_util.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/ubsan.h"
// #include "arrow/util/visibility.h"
// Targeting ../BufferBuilder.java



/** \brief A BufferBuilder for building a buffer of arithmetic elements */
// Targeting ../TypedBufferBuilder.java



  // namespace arrow

// #endif  // ARROW_BUFFER_BUILDER_H


// Parsed from arrow/compare.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Functions for comparing Arrow data structures

// #ifndef ARROW_COMPARE_H
// #define ARROW_COMPARE_H

// #include <cstdint>
// #include <iosfwd>

// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../SparseTensor.java



@Namespace("arrow") @MemberGetter public static native double kDefaultAbsoluteTolerance();
public static final double kDefaultAbsoluteTolerance = kDefaultAbsoluteTolerance();
// Targeting ../EqualOptions.java



/** Returns true if the arrays are exactly equal */
@Namespace("arrow") public static native @Cast("bool") boolean ArrayEquals(@Const @ByRef Array left, @Const @ByRef Array right,
                              @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean ArrayEquals(@Const @ByRef Array left, @Const @ByRef Array right);

@Namespace("arrow") public static native @Cast("bool") boolean TensorEquals(@Const @ByRef Tensor left, @Const @ByRef Tensor right,
                               @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean TensorEquals(@Const @ByRef Tensor left, @Const @ByRef Tensor right);

/** EXPERIMENTAL: Returns true if the given sparse tensors are exactly equal */
@Namespace("arrow") public static native @Cast("bool") boolean SparseTensorEquals(@Const @ByRef SparseTensor left, @Const @ByRef SparseTensor right);

/** Returns true if the arrays are approximately equal. For non-floating point
 *  types, this is equivalent to ArrayEquals(left, right) */
@Namespace("arrow") public static native @Cast("bool") boolean ArrayApproxEquals(@Const @ByRef Array left, @Const @ByRef Array right,
                                    @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean ArrayApproxEquals(@Const @ByRef Array left, @Const @ByRef Array right);

/** Returns true if indicated equal-length segment of arrays is exactly equal */
@Namespace("arrow") public static native @Cast("bool") boolean ArrayRangeEquals(@Const @ByRef Array left, @Const @ByRef Array right,
                                   @Cast("int64_t") long start_idx, @Cast("int64_t") long end_idx,
                                   @Cast("int64_t") long other_start_idx);

/** Returns true if the type metadata are exactly equal
 *  @param left [in] a DataType
 *  @param right [in] a DataType
 *  @param check_metadata [in] whether to compare KeyValueMetadata for child
 *  fields */
@Namespace("arrow") public static native @Cast("bool") boolean TypeEquals(@Const @ByRef DataType left, @Const @ByRef DataType right,
                             @Cast("bool") boolean check_metadata/*=true*/);
@Namespace("arrow") public static native @Cast("bool") boolean TypeEquals(@Const @ByRef DataType left, @Const @ByRef DataType right);

/** Returns true if scalars are equal
 *  @param left [in] a Scalar
 *  @param right [in] a Scalar */
@Namespace("arrow") public static native @Cast("bool") boolean ScalarEquals(@Const @ByRef Scalar left, @Const @ByRef Scalar right);

  // namespace arrow

// #endif  // ARROW_COMPARE_H


// Parsed from arrow/result.h

//
// Copyright 2017 Asylo authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Adapted from Asylo

// #pragma once

// #include <string>
// #include <utility>

// #include "arrow/status.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/variant.h"

@Namespace("arrow::internal") public static native void DieWithMessage(@StdString String msg);
@Namespace("arrow::internal") public static native void DieWithMessage(@StdString BytePointer msg);


// Targeting ../BoolResult.java


// Targeting ../LongResult.java


// Targeting ../SizeTResult.java


// Targeting ../Decimal128Result.java


// Targeting ../Decimal128PairResult.java


// Targeting ../StringViewResult.java


// Targeting ../ArrayResult.java


// Targeting ../BufferResult.java


// Targeting ../DataTypeResult.java


// Targeting ../FieldResult.java


// Targeting ../ListArrayResult.java


// Targeting ../BinaryArrayResult.java


// Targeting ../StructArrayResult.java


// Targeting ../RecordBatchResult.java


// Targeting ../ScalarResult.java


// Targeting ../SchemaResult.java


// Targeting ../SparseTensorResult.java


// Targeting ../TableResult.java


// Targeting ../TensorResult.java


// Targeting ../InputStreamResult.java


// Targeting ../OutputStreamResult.java


// Targeting ../MemoryMappedFileResult.java


// Targeting ../ReadableFileResult.java


// Targeting ../RandomAccessFileResult.java


// Targeting ../FileOutputStreamResult.java


// Targeting ../BufferOutputStreamResult.java


// Targeting ../BufferedInputStreamResult.java


// Targeting ../BufferedOutputStreamResult.java


// Targeting ../CompressedInputStreamResult.java


// Targeting ../CompressedOutputStreamResult.java


// Targeting ../TableReaderResult.java


// Targeting ../DatumResult.java


// Targeting ../FileStatsResult.java


// Targeting ../PathForestResult.java


// Targeting ../FileStatsVectorResult.java


// Targeting ../SchemaVectorResult.java


// Targeting ../FileSystemResult.java


// Targeting ../CompressorResult.java


// Targeting ../DecompressorResult.java


// Targeting ../CompressResultResult.java


// Targeting ../EndResultResult.java


// Targeting ../FlushResultResult.java


// Targeting ../DecompressResultResult.java


// Targeting ../RecordBatchWriterSharedResult.java


// Targeting ../RecordBatchWriterUniqueResult.java


// Targeting ../CodecResult.java


// Targeting ../BufferIteratorResult.java


// Targeting ../RecordBatchIteratorResult.java



// #define ARROW_ASSIGN_OR_RAISE_IMPL(result_name, lhs, rexpr)
//   auto result_name = (rexpr);
//   ARROW_RETURN_NOT_OK((result_name).status());
//   lhs = std::move(result_name).ValueOrDie();


///
///
///
// #define ARROW_ASSIGN_OR_RAISE_NAME(x, y) ARROW_CONCAT(x, y)

/** \brief Execute an expression that returns a Result, extracting its value
 *  into the variable defined by {@code lhs} (or returning a Status on error).
 * 
 *  Example: Assigning to a new value:
 *    ARROW_ASSIGN_OR_RAISE(auto value, MaybeGetValue(arg));
 * 
 *  Example: Assigning to an existing value:
 *    ValueType value;
 *    ARROW_ASSIGN_OR_RAISE(value, MaybeGetValue(arg));
 * 
 *  WARNING: ARROW_ASSIGN_OR_RAISE expands into multiple statements;
 *  it cannot be used in a single statement (e.g. as the body of an if
 *  statement without {})! */
// #define ARROW_ASSIGN_OR_RAISE(lhs, rexpr)
//   ARROW_ASSIGN_OR_RAISE_IMPL(ARROW_ASSIGN_OR_RAISE_NAME(_error_or_value, __COUNTER__),
//                              lhs, rexpr);

  // namespace internal

  // namespace arrow


// Parsed from arrow/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_TYPE_FWD_H
// #define ARROW_TYPE_FWD_H

// #include <memory>

// #include "arrow/util/visibility.h"
// Targeting ../BooleanType.java



// #define _NUMERIC_TYPE_DECL(KLASS)
//   class KLASS##Type;
//   using KLASS##Array = NumericArray<KLASS##Type>;
//   using KLASS##Builder = NumericBuilder<KLASS##Type>;
//   struct KLASS##Scalar;
//   using KLASS##Tensor = NumericTensor<KLASS##Type>;
// Targeting ../Int8Type.java


// Targeting ../Int16Type.java


// Targeting ../Int32Type.java


// Targeting ../Int64Type.java


// Targeting ../UInt8Type.java


// Targeting ../UInt16Type.java


// Targeting ../UInt32Type.java


// Targeting ../UInt64Type.java


// Targeting ../HalfFloatType.java


// Targeting ../FloatType.java


// Targeting ../DoubleType.java



// #undef _NUMERIC_TYPE_DECL

// ----------------------------------------------------------------------
// (parameter-free) Factory functions
// Other factory functions are in type.h

/** \defgroup type-factories Factory functions for creating data types
 * 
 *  Factory functions for creating data types
 *  \{
 <p>
 *  \brief Return a NullType instance */
@Namespace("arrow") public static native @SharedPtr @Name("null") @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType _null();
/** \brief Return a BooleanType instance */
@Namespace("arrow") public static native @SharedPtr @Name("boolean") @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType _boolean();
/** \brief Return a Int8Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int8();
/** \brief Return a Int16Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int16();
/** \brief Return a Int32Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int32();
/** \brief Return a Int64Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int64();
/** \brief Return a UInt8Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint8();
/** \brief Return a UInt16Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint16();
/** \brief Return a UInt32Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint32();
/** \brief Return a UInt64Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint64();
/** \brief Return a HalfFloatType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType float16();
/** \brief Return a FloatType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType float32();
/** \brief Return a DoubleType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType float64();
/** \brief Return a StringType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType utf8();
/** \brief Return a LargeStringType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_utf8();
/** \brief Return a BinaryType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType binary();
/** \brief Return a LargeBinaryType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_binary();
/** \brief Return a Date32Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType date32();
/** \brief Return a Date64Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType date64();

/** \}
 <p>
 *  Return the process-wide default memory pool. */
@Namespace("arrow") public static native MemoryPool default_memory_pool();

// #ifndef ARROW_MEMORY_POOL_DEFAULT
// #define ARROW_MEMORY_POOL_DEFAULT = default_memory_pool()
// #endif

  // namespace arrow

// #endif  // ARROW_TYPE_FWD_H


// Parsed from arrow/type_traits.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <type_traits>
// #include <vector>

// #include "arrow/type_fwd.h"
// #include "arrow/util/bit_util.h"

//
// Per-type type traits
//

// #define PRIMITIVE_TYPE_TRAITS_DEF_(CType_, ArrowType_, ArrowArrayType, ArrowBuilderType,
//                                    ArrowScalarType, ArrowTensorType, SingletonFn)
//   template <>
//   struct TypeTraits<ArrowType_> {
//     using ArrayType = ArrowArrayType;
//     using BuilderType = ArrowBuilderType;
//     using ScalarType = ArrowScalarType;
//     using TensorType = ArrowTensorType;
//     using CType = ArrowType_::c_type;
//     static constexpr int64_t bytes_required(int64_t elements) {
//       return elements * static_cast<int64_t>(sizeof(CType));
//     }
//     constexpr static bool is_parameter_free = true;
//     static inline std::shared_ptr<DataType> type_singleton() { return SingletonFn(); }
//   };
// 
//   template <>
//   struct CTypeTraits<CType_> : public TypeTraits<ArrowType_> {
//     using ArrowType = ArrowType_;
//   };

// #define PRIMITIVE_TYPE_TRAITS_DEF(CType, ArrowShort, SingletonFn)
//   PRIMITIVE_TYPE_TRAITS_DEF_(
//       CType, ARROW_CONCAT(ArrowShort, Type), ARROW_CONCAT(ArrowShort, Array),
//       ARROW_CONCAT(ArrowShort, Builder), ARROW_CONCAT(ArrowShort, Scalar),
//       ARROW_CONCAT(ArrowShort, Tensor), SingletonFn)

// #undef PRIMITIVE_TYPE_TRAITS_DEF
// #undef PRIMITIVE_TYPE_TRAITS_DEF_

  // namespace internal

//
// Useful type predicates
//

// only in C++14

// Note this will also include HalfFloatType which is represented by a
// non-floating point primitive (uint16_t).

// Half floats are special in that they behave physically like an unsigned
// integer.

// Binary Types

// Base binary refers to Binary/LargeBinary/String/LargeString

// Any binary excludes string from Base binary

// Note that this also includes DecimalType

// Nested Types

// TemporalTypes

// Attribute differentiation

// Physical representation quirks

// Like is_floating_type but excluding half-floats which don't have a
// float-like c type.

@Namespace("arrow") public static native @Cast("bool") boolean is_integer(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_floating(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_primitive(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_base_binary_like(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_binary_like(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_large_binary_like(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_dictionary(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_fixed_size_binary(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_fixed_width(@Cast("arrow::Type::type") int type_id);

  // namespace arrow


// Parsed from arrow/util/basic_decimal.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <array>
// #include <cstdint>
// #include <limits>
// #include <string>
// #include <type_traits>

// #include "arrow/util/macros.h"
// #include "arrow/util/type_traits.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow") public enum DecimalStatus {
  kSuccess(0),
  kDivideByZero(1),
  kOverflow(2),
  kRescaleDataLoss(3);

    public final int value;
    private DecimalStatus(int v) { this.value = v; }
    private DecimalStatus(DecimalStatus e) { this.value = e.value; }
    public DecimalStatus intern() { for (DecimalStatus e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../BasicDecimal128.java



@Namespace("arrow") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);

@Namespace("arrow") public static native @ByVal @Name("operator -") BasicDecimal128 subtract(@Const @ByRef BasicDecimal128 operand);
@Namespace("arrow") public static native @ByVal @Name("operator ~") BasicDecimal128 not(@Const @ByRef BasicDecimal128 operand);
@Namespace("arrow") public static native @ByVal @Name("operator +") BasicDecimal128 add(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator -") BasicDecimal128 subtract(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator *") BasicDecimal128 multiply(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator /") BasicDecimal128 divide(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator %") BasicDecimal128 mod(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);

  // namespace arrow


// Parsed from arrow/util/decimal.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <iosfwd>
// #include <limits>
// #include <string>
// #include <type_traits>
// #include <utility>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/basic_decimal.h"
// #include "arrow/util/string_view.h"
// Targeting ../Decimal128.java



  // namespace arrow


// Parsed from arrow/util/sort.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <cstdint>
// #include <functional>
// #include <numeric>
// #include <utility>
// #include <vector>

  // namespace internal
  // namespace arrow


// Parsed from arrow/type.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_TYPE_H
// #define ARROW_TYPE_H

// #include <atomic>
// #include <climits>
// #include <cstdint>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/type_fwd.h"  // IWYU pragma: export
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// #include "arrow/visitor.h"
// Targeting ../Type.java


// Targeting ../Fingerprintable.java




// Targeting ../DataTypeLayout.java


// Targeting ../DataType.java



@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef DataType type);
// Targeting ../FixedWidthType.java


// Targeting ../PrimitiveCType.java


// Targeting ../NumberType.java


// Targeting ../IntegerType.java


// Targeting ../FloatingPointType.java


// Targeting ../ParametricType.java


// Targeting ../NestedType.java


// Targeting ../Field.java




// Targeting ../NullType.java



/** Concrete type class for boolean data */

/** Concrete type class for unsigned 8-bit integer data */

/** Concrete type class for signed 8-bit integer data */

/** Concrete type class for unsigned 16-bit integer data */

/** Concrete type class for signed 16-bit integer data */

/** Concrete type class for unsigned 32-bit integer data */

/** Concrete type class for signed 32-bit integer data */

/** Concrete type class for unsigned 64-bit integer data */

/** Concrete type class for signed 64-bit integer data */

/** Concrete type class for 16-bit floating-point data */

/** Concrete type class for 32-bit floating-point data (C "float") */

/** Concrete type class for 64-bit floating-point data (C "double") */
// Targeting ../BaseListType.java


// Targeting ../ListType.java


// Targeting ../LargeListType.java


// Targeting ../MapType.java


// Targeting ../FixedSizeListType.java


// Targeting ../BaseBinaryType.java


// Targeting ../BinaryType.java


// Targeting ../LargeBinaryType.java


// Targeting ../StringType.java


// Targeting ../LargeStringType.java


// Targeting ../FixedSizeBinaryType.java


// Targeting ../StructType.java


// Targeting ../DecimalType.java


// Targeting ../Decimal128Type.java


// Targeting ../UnionMode.java


// Targeting ../UnionType.java



// ----------------------------------------------------------------------
// Date and time types

@Namespace("arrow") public enum DateUnit { DAY((byte)0), MILLI((byte)1);

    public final byte value;
    private DateUnit(byte v) { this.value = v; }
    private DateUnit(DateUnit e) { this.value = e.value; }
    public DateUnit intern() { for (DateUnit e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../TemporalType.java


// Targeting ../DateType.java


// Targeting ../Date32Type.java


// Targeting ../Date64Type.java


// Targeting ../TimeUnit.java



@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, TimeUnit.type unit);
@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Cast("arrow::TimeUnit::type") int unit);
// Targeting ../TimeType.java


// Targeting ../Time32Type.java


// Targeting ../Time64Type.java


// Targeting ../TimestampType.java


// Targeting ../IntervalType.java


// Targeting ../MonthIntervalType.java


// Targeting ../DayTimeIntervalType.java


// Targeting ../DurationType.java


// Targeting ../DictionaryType.java


// Targeting ../DictionaryUnifier.java


// Targeting ../Schema.java



// ----------------------------------------------------------------------
// Parametric factory functions
// Other factory functions are in type_fwd.h

/** \addtogroup type-factories
 *  \{
 <p>
 *  \brief Create a FixedSizeBinaryType instance. */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType fixed_size_binary(int byte_width);

/** \brief Create a Decimal128Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType decimal(int precision, int scale);

/** \brief Create a ListType instance from its child Field type */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType list(@Const @SharedPtr @ByRef Field value_type);

/** \brief Create a ListType instance from its child DataType */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type);

/** \brief Create a LargeListType instance from its child Field type */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_list(@Const @SharedPtr @ByRef Field value_type);

/** \brief Create a LargeListType instance from its child DataType */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type);

/** \brief Create a MapType instance from its key and value DataTypes */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType map(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType key_type,
                              @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type,
                              @Cast("bool") boolean keys_sorted/*=false*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType map(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType key_type,
                              @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type);

/** \brief Create a FixedSizeListType instance from its child Field type */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType fixed_size_list(@Const @SharedPtr @ByRef Field value_type,
                                          int list_size);

/** \brief Create a FixedSizeListType instance from its child DataType */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType fixed_size_list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type,
                                          int list_size);
/** \brief Return a Duration instance (naming use _type to avoid namespace conflict with
 *  built in time clases). */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType duration(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType duration(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Return a DayTimeIntervalType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType day_time_interval();

/** \brief Return a MonthIntervalType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType month_interval();

/** \brief Create a TimestampType instance from its unit */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Create a TimestampType instance from its unit and timezone */

///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(TimeUnit.type unit, @StdString String timezone);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(@Cast("arrow::TimeUnit::type") int unit, @StdString BytePointer timezone);

/** \brief Create a 32-bit time type instance
 * 
 *  Unit can be either SECOND or MILLI */

///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time32(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time32(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Create a 64-bit time type instance
 * 
 *  Unit can be either MICRO or NANO */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time64(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time64(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Create a StructType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType struct_(@Const @ByRef FieldVector fields);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector BytePointer type_codes, UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector BytePointer type_codes);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector ByteBuffer type_codes, @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector ByteBuffer type_codes);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector byte[] type_codes, UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector byte[] type_codes);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector BytePointer type_codes, @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector ByteBuffer type_codes, UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector byte[] type_codes, @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_();
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector BytePointer type_codes,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector BytePointer type_codes);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector ByteBuffer type_codes,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector ByteBuffer type_codes);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector byte[] type_codes,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector byte[] type_codes);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector BytePointer type_codes,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector ByteBuffer type_codes,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector byte[] type_codes,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a DictionaryType instance
 *  @param index_type [in] the type of the dictionary indices (must be
 *  a signed integer)
 *  @param dict_type [in] the type of the values in the variable dictionary
 *  @param ordered [in] true if the order of the dictionary values has
 *  semantic meaning and should be preserved where possible */

///
///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dictionary(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType index_type,
                                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dict_type,
                                     @Cast("bool") boolean ordered/*=false*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dictionary(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType index_type,
                                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dict_type);

/** \}
 <p>
 *  \defgroup schema-factories Factory functions for fields and schemas
 * 
 *  Factory functions for fields and schemas
 *  \{
 <p>
 *  \brief Create a Field instance
 * 
 *  @param name the field name
 *  @param type the field value type
 *  @param nullable whether the values are nullable, default true
 *  @param metadata any custom key-value metadata, default null */

///
@Namespace("arrow") public static native @SharedPtr @ByVal Field field(
    @StdString String name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("bool") boolean nullable/*=true*/,
    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow") public static native @SharedPtr @ByVal Field field(
    @StdString String name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);
@Namespace("arrow") public static native @SharedPtr @ByVal Field field(
    @StdString BytePointer name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("bool") boolean nullable/*=true*/,
    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow") public static native @SharedPtr @ByVal Field field(
    @StdString BytePointer name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

/** \brief Create a Schema instance
 * 
 *  @param fields the schema's fields
 *  @param metadata any custom key-value metadata, default null
 *  @return schema shared_ptr to Schema */

///
@Namespace("arrow") public static native @SharedPtr @ByVal Schema schema(
    @Const @ByRef FieldVector fields,
    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow") public static native @SharedPtr @ByVal Schema schema(
    @Const @ByRef FieldVector fields);

/** \brief Create a Schema instance
 * 
 *  @param fields the schema's fields (rvalue reference)
 *  @param metadata any custom key-value metadata, default null
 *  @return schema shared_ptr to Schema */
// Targeting ../SchemaBuilder.java



/** \brief Unifies schemas by merging fields by name.
 * 
 *  The behavior of field merging can be controlled via {@code Field::MergeOptions}.
 * 
 *  The resulting schema will contain the union of fields from all schemas.
 *  Fields with the same name will be merged. See {@code Field::MergeOptions}.
 *  - They are expected to be mergeable under provided {@code field_merge_options}.
 *  - The unified field will inherit the metadata from the schema where
 *    that field is first defined.
 *  - The first N fields in the schema will be ordered the same as the
 *    N fields in the first schema.
 *  The resulting schema will inherit its metadata from the first input schema.
 *  Returns an error if:
 *  - Any input schema contains fields with duplicate names.
 *  - Fields of the same name are not mergeable. */
@Namespace("arrow") public static native @ByVal SchemaResult UnifySchemas(
    @Const @ByRef SchemaVector schemas,
    @ByVal(nullValue = "arrow::Field::MergeOptions::Defaults()") Field.MergeOptions field_merge_options);
@Namespace("arrow") public static native @ByVal SchemaResult UnifySchemas(
    @Const @ByRef SchemaVector schemas);

  // namespace arrow

// #endif  // ARROW_TYPE_H


// Parsed from arrow/scalar.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Object model for scalar (non-Array) values. Not intended for use with large
// amounts of data
//
// NOTE: This API is experimental as of the 0.13 version and subject to change
// without deprecation warnings

// #pragma once

// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/decimal.h"
// #include "arrow/util/logging.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ../Scalar.java


// Targeting ../NullScalar.java




// Targeting ../BooleanScalar.java


// Targeting ../BaseInt8Type.java


// Targeting ../BaseInt16Type.java


// Targeting ../BaseInt32Type.java


// Targeting ../BaseInt64Type.java


// Targeting ../BaseUInt8Type.java


// Targeting ../BaseUInt16Type.java


// Targeting ../BaseUInt32Type.java


// Targeting ../BaseUInt64Type.java


// Targeting ../BaseHalfFloatScalar.java


// Targeting ../BaseFloatScalar.java


// Targeting ../BaseDoubleScalar.java


// Targeting ../Int8Scalar.java


// Targeting ../Int16Scalar.java


// Targeting ../Int32Scalar.java


// Targeting ../Int64Scalar.java


// Targeting ../UInt8Scalar.java


// Targeting ../UInt16Scalar.java


// Targeting ../UInt32Scalar.java


// Targeting ../UInt64Scalar.java


// Targeting ../HalfFloatScalar.java


// Targeting ../FloatScalar.java


// Targeting ../DoubleScalar.java


// Targeting ../BaseBinaryScalar.java


// Targeting ../BinaryScalar.java


// Targeting ../StringScalar.java


// Targeting ../LargeBinaryScalar.java


// Targeting ../LargeStringScalar.java


// Targeting ../FixedSizeBinaryScalar.java


// Targeting ../BaseBaseDate32Scalar.java


// Targeting ../BaseBaseDate64Scalar.java


// Targeting ../BaseDurationScalar.java


// Targeting ../BaseBaseDayTimeIntervalScalar.java


// Targeting ../BaseBaseMonthIntervalType.java


// Targeting ../BaseTimestampScalar.java


// Targeting ../BaseBaseTime32Scalar.java


// Targeting ../BaseBaseTime64Scalar.java


// Targeting ../BaseDate32Scalar.java


// Targeting ../BaseDate64Scalar.java


// Targeting ../Date32Scalar.java


// Targeting ../Date64Scalar.java


// Targeting ../BaseTime32Scalar.java


// Targeting ../BaseTime64Scalar.java


// Targeting ../Time32Scalar.java


// Targeting ../Time64Scalar.java


// Targeting ../TimestampScalar.java


// Targeting ../BaseDayTimeIntervalScalar.java


// Targeting ../BaseMonthIntervalScalar.java


// Targeting ../MonthIntervalScalar.java


// Targeting ../DayTimeIntervalScalar.java


// Targeting ../DurationScalar.java


// Targeting ../Decimal128Scalar.java


// Targeting ../BaseListScalar.java


// Targeting ../ListScalar.java


// Targeting ../LargeListScalar.java


// Targeting ../MapScalar.java


// Targeting ../FixedSizeListScalar.java


// Targeting ../StructScalar.java


// Targeting ../UnionScalar.java


// Targeting ../DictionaryScalar.java


// Targeting ../ExtensionScalar.java



@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar MakeNullScalar(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

@Namespace("arrow::internal") public static native @ByVal Status CheckBufferLength();

@Namespace("arrow::internal") public static native @ByVal Status CheckBufferLength(@Const FixedSizeBinaryType t,
                                      @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer b);

  // namespace internal

/** \brief type inferring scalar factory */

@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar MakeScalar(@StdString String value);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar MakeScalar(@StdString BytePointer value);

  // namespace arrow


// Parsed from arrow/visitor.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_VISITOR_H
// #define ARROW_VISITOR_H

// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ../ArrayVisitor.java


// Targeting ../TypeVisitor.java


// Targeting ../ScalarVisitor.java



  // namespace arrow

// #endif  // ARROW_VISITOR_H


// Parsed from arrow/array.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <atomic>
// #include <cstdint>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/compare.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/bit_util.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"  // IWYU pragma: export
// #include "arrow/util/visibility.h"

// When slicing, we do not know the null count of the sliced range without
// doing some computation. To avoid doing this eagerly, we set the null count
// to -1 (any negative number will do). When Array::null_count is called the
// first time, the null count will be computed. See ARROW-33
@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kUnknownNullCount();
// Targeting ../ArrayData.java



/** \brief Create a strongly-typed Array instance from generic ArrayData
 *  @param data [in] the array contents
 *  @return the resulting Array instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array MakeArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data);

/** \brief Create a strongly-typed Array instance with all elements null
 *  @param type [in] the array type
 *  @param length [in] the array length
 *  @param out [out] resulting Array instance */
@Namespace("arrow") public static native @ByVal Status MakeArrayOfNull(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("int64_t") long length,
                       @SharedPtr Array out);

/** \brief Create a strongly-typed Array instance with all elements null
 *  @param pool [in] the pool from which memory for this array will be allocated
 *  @param type [in] the array type
 *  @param length [in] the array length
 *  @param out [out] resulting Array instance */
@Namespace("arrow") public static native @ByVal Status MakeArrayOfNull(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                       @Cast("int64_t") long length, @SharedPtr Array out);

/** \brief Create an Array instance whose slots are the given scalar
 *  @param scalar [in] the value with which to fill the array
 *  @param length [in] the array length
 *  @param out [out] resulting Array instance */
@Namespace("arrow") public static native @ByVal Status MakeArrayFromScalar(@Const @ByRef Scalar scalar, @Cast("int64_t") long length,
                           @SharedPtr Array out);

/** \brief Create a strongly-typed Array instance with all elements null
 *  @param pool [in] the pool from which memory for this array will be allocated
 *  @param scalar [in] the value with which to fill the array
 *  @param length [in] the array length
 *  @param out [out] resulting Array instance */

///
///
///
@Namespace("arrow") public static native @ByVal Status MakeArrayFromScalar(MemoryPool pool, @Const @ByRef Scalar scalar, @Cast("int64_t") long length,
                           @SharedPtr Array out);
// Targeting ../Array.java



/** Given a number of ArrayVectors, treat each ArrayVector as the
 *  chunks of a chunked array.  Then rechunk each ArrayVector such that
 *  all ArrayVectors are chunked identically.  It is mandatory that
 *  all ArrayVectors contain the same total number of elements. */
@Namespace("arrow::internal") public static native @ByVal ArrayVectorVector RechunkArraysConsistently(@Const @ByRef ArrayVectorVector arg0);

  // namespace internal

@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef Array x);
// Targeting ../FlatArray.java


// Targeting ../NullArray.java


// Targeting ../PrimitiveArray.java


// Targeting ../Int8Array.java


// Targeting ../Int16Array.java


// Targeting ../Int32Array.java


// Targeting ../Int64Array.java


// Targeting ../UInt8Array.java


// Targeting ../UInt16Array.java


// Targeting ../UInt32Array.java


// Targeting ../UInt64Array.java


// Targeting ../HalfFloatArray.java


// Targeting ../FloatArray.java


// Targeting ../DoubleArray.java


// Targeting ../Date64Array.java


// Targeting ../Date32Array.java


// Targeting ../Time32Array.java


// Targeting ../Time64Array.java


// Targeting ../TimestampArray.java


// Targeting ../MonthIntervalArray.java


// Targeting ../DurationArray.java


// Targeting ../BooleanArray.java


// Targeting ../BaseListArray.java


// Targeting ../BaseLargeListArray.java


// Targeting ../ListArray.java


// Targeting ../LargeListArray.java


// Targeting ../MapArray.java


// Targeting ../FixedSizeListArray.java


// Targeting ../BaseBinaryArray.java


// Targeting ../BaseLargeBinaryArray.java


// Targeting ../BinaryArray.java


// Targeting ../StringArray.java


// Targeting ../LargeBinaryArray.java


// Targeting ../LargeStringArray.java


// Targeting ../FixedSizeBinaryArray.java


// Targeting ../DayTimeIntervalArray.java


// Targeting ../Decimal128Array.java



// Backward compatibility
// Targeting ../StructArray.java


// Targeting ../UnionArray.java


// Targeting ../DictionaryArray.java



  // namespace arrow


// Parsed from arrow/array/concatenate.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <vector>

// #include "arrow/array.h"
// #include "arrow/memory_pool.h"
// #include "arrow/util/visibility.h"

/** \brief Concatenate arrays
 * 
 *  @param arrays [in] a vector of arrays to be concatenated
 *  @param pool [in] memory to store the result will be allocated from this memory pool
 *  @param out [out] the resulting concatenated array
 *  @return Status */
@Namespace("arrow") public static native @ByVal Status Concatenate(@Const @ByRef ArrayVector arrays, MemoryPool pool,
                   @SharedPtr Array out);

  // namespace arrow


// Parsed from arrow/array/builder_base.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>  // IWYU pragma: keep
// #include <cstdint>
// #include <cstring>
// #include <limits>
// #include <memory>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/buffer_builder.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/type_traits.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kMinBuilderCapacity();

///
///
@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kListMaximumElements();
// Targeting ../ArrayBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_binary.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <cstdint>
// #include <limits>
// #include <memory>
// #include <numeric>
// #include <string>
// #include <vector>

// #include "arrow/array.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/buffer_builder.h"
// #include "arrow/status.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"  // IWYU pragma: export

@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kBinaryMemoryLimit();
// Targeting ../BaseBinaryBuilder.java


// Targeting ../BaseLargeBinaryBuilder.java


// Targeting ../BinaryBuilder.java


// Targeting ../StringBuilder.java


// Targeting ../LargeBinaryBuilder.java


// Targeting ../LargeStringBuilder.java


// Targeting ../FixedSizeBinaryBuilder.java


// Targeting ../ChunkedBinaryBuilder.java


// Targeting ../ChunkedStringBuilder.java



  // namespace internal

  // namespace arrow


// Parsed from arrow/array/builder_decimal.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/array/builder_base.h"
// #include "arrow/array/builder_binary.h"
// Targeting ../Decimal128Builder.java



  // namespace arrow


// Parsed from arrow/array/builder_dict.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <memory>

// #include "arrow/array/builder_adaptive.h"   // IWYU pragma: export
// #include "arrow/array/builder_base.h"       // IWYU pragma: export
// #include "arrow/array/builder_primitive.h"  // IWYU pragma: export

// #include "arrow/array.h"

// ----------------------------------------------------------------------
// Dictionary builder
// Targeting ../DictionaryMemoTable.java



/** \brief Array builder for created encoded DictionaryArray from
 *  dense array
 * 
 *  Unlike other builders, dictionary builder does not completely
 *  reset the state on Finish calls. */

  // namespace internal

/** \brief A DictionaryArray builder that uses AdaptiveIntBuilder to return the
 *  smallest index size that can accommodate the dictionary indices */

/** \brief A DictionaryArray builder that always returns int32 dictionary
 *  indices so that data cast to dictionary form will have a consistent index
 *  type, e.g. for creating a ChunkedArray */

// ----------------------------------------------------------------------
// Binary / Unicode builders with slightly expanded APIs


// Targeting ../BinaryDictionaryBuilder.java


// Targeting ../StringDictionaryBuilder.java


// Targeting ../BinaryDictionary32Builder.java


// Targeting ../StringDictionary32Builder.java



  // namespace arrow


// Parsed from arrow/array/builder_nested.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <limits>
// #include <memory>
// #include <utility>
// #include <vector>

// #include "arrow/array.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/buffer_builder.h"
// Targeting ../BaseListBuilder.java


// Targeting ../BaseLargeListBuilder.java


// Targeting ../ListBuilder.java


// Targeting ../LargeListBuilder.java


// Targeting ../MapBuilder.java


// Targeting ../FixedSizeListBuilder.java


// Targeting ../StructBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_primitive.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <memory>
// #include <vector>

// #include "arrow/array.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/type.h"
// Targeting ../NullBuilder.java


// Targeting ../Int8Builder.java


// Targeting ../Int16Builder.java


// Targeting ../Int32Builder.java


// Targeting ../Int64Builder.java


// Targeting ../UInt8Builder.java


// Targeting ../UInt16Builder.java


// Targeting ../UInt32Builder.java


// Targeting ../UInt64Builder.java


// Targeting ../HalfFloatBuilder.java


// Targeting ../FloatBuilder.java


// Targeting ../DoubleBuilder.java



// Builders
// Targeting ../BooleanBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_time.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Contains declarations of time related Arrow builder types.

// #pragma once

// #include <memory>

// #include "arrow/array.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/array/builder_binary.h"
// #include "arrow/array/builder_primitive.h"
// #include "arrow/buffer_builder.h"
// #include "arrow/status.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/macros.h"
// Targeting ../DayTimeIntervalBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_union.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/array.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/buffer_builder.h"
// Targeting ../BasicUnionBuilder.java


// Targeting ../DenseUnionBuilder.java


// Targeting ../SparseUnionBuilder.java



  // namespace arrow


// Parsed from arrow/builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/array/builder_adaptive.h"   // IWYU pragma: export
// #include "arrow/array/builder_base.h"       // IWYU pragma: export
// #include "arrow/array/builder_binary.h"     // IWYU pragma: export
// #include "arrow/array/builder_decimal.h"    // IWYU pragma: export
// #include "arrow/array/builder_dict.h"       // IWYU pragma: export
// #include "arrow/array/builder_nested.h"     // IWYU pragma: export
// #include "arrow/array/builder_primitive.h"  // IWYU pragma: export
// #include "arrow/array/builder_time.h"       // IWYU pragma: export
// #include "arrow/array/builder_union.h"      // IWYU pragma: export
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"

/** \brief Construct an empty ArrayBuilder corresponding to the data
 *  type
 *  @param pool [in] the MemoryPool to use for allocations
 *  @param type [in] an instance of DictionaryType
 *  @param out [out] the created ArrayBuilder */
@Namespace("arrow") public static native @ByVal Status MakeBuilder(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                   @UniquePtr ArrayBuilder out);

/** \brief Construct an empty DictionaryBuilder initialized optionally
 *  with a pre-existing dictionary
 *  @param pool [in] the MemoryPool to use for allocations
 *  @param type [in] an instance of DictionaryType
 *  @param dictionary [in] the initial dictionary, if any. May be nullptr
 *  @param out [out] the created ArrayBuilder */
@Namespace("arrow") public static native @ByVal Status MakeDictionaryBuilder(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                             @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                             @UniquePtr ArrayBuilder out);

  // namespace arrow


// Parsed from arrow/extension_type.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

/** User-defined extension types. EXPERIMENTAL in 0.13.0
 *  @since 0.13.0 */

// #pragma once

// #include <memory>
// #include <string>

// #include "arrow/array.h"
// #include "arrow/type.h"
// #include "arrow/util/visibility.h"
// Targeting ../ExtensionType.java


// Targeting ../ExtensionArray.java


// Targeting ../ExtensionTypeRegistry.java



/** \brief Register an extension type globally. The name returned by the type's
 *  extension_name() method should be unique. This method is thread-safe
 *  @param type [in] an instance of the extension type
 *  @return Status */
@Namespace("arrow") public static native @ByVal Status RegisterExtensionType(@SharedPtr ExtensionType type);

/** \brief Delete an extension type from the global registry. This method is
 *  thread-safe
 *  @param type_name [in] the unique name of a registered extension type
 *  @return Status error if the type name is unknown */
@Namespace("arrow") public static native @ByVal Status UnregisterExtensionType(@StdString String type_name);
@Namespace("arrow") public static native @ByVal Status UnregisterExtensionType(@StdString BytePointer type_name);

/** \brief Retrieve an extension type from the global registry. Returns nullptr
 *  if not found. This method is thread-safe
 *  @return the globally-registered extension type */
@Namespace("arrow") public static native @SharedPtr ExtensionType GetExtensionType(@StdString String type_name);
@Namespace("arrow") public static native @SharedPtr ExtensionType GetExtensionType(@StdString BytePointer type_name);

@Namespace("arrow") @MemberGetter public static native byte kExtensionTypeKeyName(int i);
@Namespace("arrow") @MemberGetter public static native String kExtensionTypeKeyName();
@Namespace("arrow") @MemberGetter public static native byte kExtensionMetadataKeyName(int i);
@Namespace("arrow") @MemberGetter public static native String kExtensionMetadataKeyName();

  // namespace arrow


// Parsed from arrow/pretty_print.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_PRETTY_PRINT_H
// #define ARROW_PRETTY_PRINT_H

// #include <iosfwd>
// #include <string>

// #include "arrow/util/visibility.h"
// Targeting ../PrettyPrintOptions.java



/** \brief Print human-readable representation of RecordBatch */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef RecordBatch batch, int indent, @Cast("std::ostream*") Pointer sink);

@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef RecordBatch batch, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Table */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Table table, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Array */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Array arr, int indent, @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Array */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Array arr, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Array */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Array arr, @Const @ByRef PrettyPrintOptions options,
                   @StdString @Cast({"char*", "std::string*"}) BytePointer result);

/** \brief Print human-readable representation of ChunkedArray */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef ChunkedArray chunked_arr, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of ChunkedArray */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef ChunkedArray chunked_arr, @Const @ByRef PrettyPrintOptions options,
                   @StdString @Cast({"char*", "std::string*"}) BytePointer result);

@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Schema schema, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Schema schema, @Const @ByRef PrettyPrintOptions options,
                   @StdString @Cast({"char*", "std::string*"}) BytePointer result);

@Namespace("arrow") public static native @ByVal Status DebugPrint(@Const @ByRef Array arr, int indent);

  // namespace arrow

// #endif  // ARROW_PRETTY_PRINT_H


// Parsed from arrow/record_batch.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../RecordBatch.java


// Targeting ../RecordBatchReader.java



/** \brief Create a RecordBatchReader from a vector of RecordBatch.
 * 
 *  @param batches [in] the vector of RecordBatch to read from
 *  @param schema [in] schema to conform to. Will be inferred from the first
 *             element if not provided.
 *  @param out [out] output pointer to store the RecordBatchReader to.
 *  @return Status */
@Namespace("arrow") public static native @ByVal Status MakeRecordBatchReader(
    @Const @ByRef RecordBatchVector batches,
    @SharedPtr @ByVal Schema schema, @SharedPtr RecordBatchReader out);

  // namespace arrow


// Parsed from arrow/table.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/record_batch.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../ChunkedArray.java


// Targeting ../Table.java


// Targeting ../TableBatchReader.java


// Targeting ../ConcatenateTablesOptions.java



/** \brief Construct table from multiple input tables. */

///
///
@Namespace("arrow") public static native @ByVal TableResult ConcatenateTables(
    @Const @ByRef TableVector tables,
    @ByVal(nullValue = "arrow::ConcatenateTablesOptions::Defaults()") ConcatenateTablesOptions options,
    MemoryPool memory_pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal TableResult ConcatenateTables(
    @Const @ByRef TableVector tables);

/** \brief Promotes a table to conform to the given schema.
 * 
 *  If a field in the schema does not have a corresponding column in the
 *  table, a column of nulls will be added to the resulting table.
 *  If the corresponding column is of type Null, it will be promoted to
 *  the type specified by schema, with null values filled.
 *  Returns an error:
 *  - if the corresponding column's type is not compatible with the
 *    schema.
 *  - if there is a column in the table that does not exist in the schema.
 * 
 *  @param table [in] the input Table
 *  @param schema [in] the target schema to promote to
 *  @param pool [in] The memory pool to be used if null-filled arrays need to
 *  be created. */
@Namespace("arrow") public static native @ByVal TableResult PromoteTableToSchema(
    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table table, @Const @SharedPtr @ByRef Schema schema,
    MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal TableResult PromoteTableToSchema(
    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table table, @Const @SharedPtr @ByRef Schema schema);

  // namespace arrow


// Parsed from arrow/table_builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_TABLE_BUILDER_H
// #define ARROW_TABLE_BUILDER_H

// #include <cstdint>
// #include <memory>
// #include <vector>

// #include "arrow/builder.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../RecordBatchBuilder.java



  // namespace arrow

// #endif  // ARROW_TABLE_BUILDER_H


// Parsed from arrow/tensor.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_TENSOR_H
// #define ARROW_TENSOR_H

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/compare.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow") public static native @Cast("bool") boolean is_tensor_supported(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow::internal") public static native @Cast("bool") boolean IsTensorStridesContiguous(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                               @Cast("int64_t*") @StdVector LongPointer shape,
                               @Cast("int64_t*") @StdVector LongPointer strides);
@Namespace("arrow::internal") public static native @Cast("bool") boolean IsTensorStridesContiguous(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                               @Cast("int64_t*") @StdVector LongBuffer shape,
                               @Cast("int64_t*") @StdVector LongBuffer strides);
@Namespace("arrow::internal") public static native @Cast("bool") boolean IsTensorStridesContiguous(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                               @Cast("int64_t*") @StdVector long[] shape,
                               @Cast("int64_t*") @StdVector long[] strides);

@Namespace("arrow::internal") public static native @ByVal Status ValidateTensorParameters(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                @SharedPtr ArrowBuffer data,
                                @Cast("int64_t*") @StdVector LongPointer shape,
                                @Cast("int64_t*") @StdVector LongPointer strides,
                                @Const @ByRef StringVector dim_names);
@Namespace("arrow::internal") public static native @ByVal Status ValidateTensorParameters(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                @SharedPtr ArrowBuffer data,
                                @Cast("int64_t*") @StdVector LongBuffer shape,
                                @Cast("int64_t*") @StdVector LongBuffer strides,
                                @Const @ByRef StringVector dim_names);
@Namespace("arrow::internal") public static native @ByVal Status ValidateTensorParameters(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                @SharedPtr ArrowBuffer data,
                                @Cast("int64_t*") @StdVector long[] shape,
                                @Cast("int64_t*") @StdVector long[] strides,
                                @Const @ByRef StringVector dim_names);


// Targeting ../Tensor.java



  // namespace arrow

// #endif  // ARROW_TENSOR_H


// Parsed from arrow/io/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_IO_API_H
// #define ARROW_IO_API_H

// #include "arrow/io/buffered.h"
// #include "arrow/io/compressed.h"
// #include "arrow/io/file.h"
// #include "arrow/io/hdfs.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/io/memory.h"

// #endif  // ARROW_IO_API_H


// Parsed from arrow/io/interfaces.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ../FileMode.java


// Targeting ../ObjectType.java


// Targeting ../FileStatistics.java


// Targeting ../IOFileSystem.java


// Targeting ../FileInterface.java


// Targeting ../Seekable.java


// Targeting ../Writable.java


// Targeting ../Readable.java


// Targeting ../OutputStream.java


// Targeting ../InputStream.java


// Targeting ../RandomAccessFile.java


// Targeting ../WritableFile.java


// Targeting ../ReadWriteFileInterface.java



/** \brief Return an iterator on an input stream
 * 
 *  The iterator yields a fixed-size block on each Next() call, except the
 *  last block in the stream which may be smaller.
 *  Once the end of stream is reached, Next() returns nullptr
 *  (unlike InputStream::Read() which returns an empty buffer). */
@Namespace("arrow::io") public static native @ByVal BufferIteratorResult MakeInputStreamIterator(
    @SharedPtr InputStream stream, @Cast("int64_t") long block_size);

  // namespace io
  // namespace arrow


// Parsed from arrow/io/concurrency.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/io/interfaces.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../SharedExclusiveCheckerSharedLockGuard.java


// Targeting ../SharedExclusiveCheckerExclusiveLockGuard.java


// Targeting ../SharedExclusiveChecker.java


// Targeting ../BufferedInputStreamConcurrencyWrapper.java


// Targeting ../CompressedInputStreamConcurrencyWrapper.java


// Targeting ../ReadableFileRandomAccessFileConcurrencyWrapper.java


// Targeting ../BufferReaderRandomAccessFileConcurrencyWrapper.java



  // namespace internal
  // namespace io
  // namespace arrow


// Parsed from arrow/io/buffered.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Buffered stream implementations

// #ifndef ARROW_IO_BUFFERED_H
// #define ARROW_IO_BUFFERED_H

// #include <cstdint>
// #include <memory>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ../BufferedOutputStream.java


// Targeting ../BufferedInputStream.java



  // namespace io
  // namespace arrow

// #endif  // ARROW_IO_BUFFERED_H


// Parsed from arrow/io/compressed.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Compressed stream implementations

// #ifndef ARROW_IO_COMPRESSED_H
// #define ARROW_IO_COMPRESSED_H

// #include <memory>
// #include <string>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"


// Targeting ../CompressedOutputStream.java


// Targeting ../CompressedInputStream.java



  // namespace io
  // namespace arrow

// #endif  // ARROW_IO_COMPRESSED_H


// Parsed from arrow/io/file.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// IO interface implementations for OS files

// #ifndef ARROW_IO_FILE_H
// #define ARROW_IO_FILE_H

// #include <cstdint>
// #include <memory>
// #include <string>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"
// Targeting ../FileOutputStream.java


// Targeting ../ReadableFile.java


// Targeting ../MemoryMappedFile.java



  // namespace io
  // namespace arrow

// #endif  // ARROW_IO_FILE_H


// Parsed from arrow/io/hdfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_IO_HDFS
// #define ARROW_IO_HDFS

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <vector>

// #include "arrow/io/interfaces.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../HdfsPathInfo.java



@Namespace("arrow::io") public enum HdfsDriver { LIBHDFS((byte)0), LIBHDFS3((byte)1);

    public final byte value;
    private HdfsDriver(byte v) { this.value = v; }
    private HdfsDriver(HdfsDriver e) { this.value = e.value; }
    public HdfsDriver intern() { for (HdfsDriver e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../HdfsConnectionConfig.java


// Targeting ../HadoopFileSystem.java


// Targeting ../HdfsReadableFile.java


// Targeting ../HdfsOutputStream.java



@Namespace("arrow::io") public static native @ByVal Status HaveLibHdfs();
@Namespace("arrow::io") public static native @ByVal Status HaveLibHdfs3();

  // namespace io
  // namespace arrow

// #endif  // ARROW_IO_HDFS


// Parsed from arrow/io/memory.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Public API for different memory sharing / IO mechanisms

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ../BufferOutputStream.java


// Targeting ../MockOutputStream.java


// Targeting ../FixedSizeBufferWriter.java


// Targeting ../BufferReader.java



  // namespace io
  // namespace arrow


// Parsed from arrow/io/slow.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Slow stream implementations, mainly for testing and benchmarking

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <utility>

// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"
// Targeting ../LatencyGenerator.java


// Targeting ../InputStreamSlowInputStreamBase.java


// Targeting ../RandomAccessFileSlowInputStreamBase.java


// Targeting ../SlowInputStream.java


// Targeting ../SlowRandomAccessFile.java



  // namespace io
  // namespace arrow


// Parsed from arrow/filesystem/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_FILESYSTEM_API_H
// #define ARROW_FILESYSTEM_API_H

// #include "arrow/filesystem/filesystem.h"  // IWYU pragma: export
// #include "arrow/filesystem/hdfs.h"        // IWYU pragma: export
// #include "arrow/filesystem/localfs.h"     // IWYU pragma: export
// #include "arrow/filesystem/mockfs.h"      // IWYU pragma: export
// #include "arrow/filesystem/s3fs.h"        // IWYU pragma: export

// #endif  // ARROW_FILESYSTEM_API_H


// Parsed from arrow/filesystem/filesystem.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <chrono>
// #include <cstdint>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/type_fwd.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

// The Windows API defines macros from *File resolving to either
// *FileA or *FileW.  Need to undo them.
// #ifdef _WIN32
// #ifdef DeleteFile
// #undef DeleteFile
// #endif
// #ifdef CopyFile
// #undef CopyFile
// #endif
// #endif

  // namespace io

// A system clock time point expressed as a 64-bit (or more) number of
// nanoseconds since the epoch.

/** \brief FileSystem entry type */
@Namespace("arrow::fs") public enum FileType {
  /** Entry does not exist */
  
///
  NonExistent((byte)0),
  /** Entry exists but its type is unknown
   * 
   *  This can designate a special file such as a Unix socket or character
   *  device, or Windows NUL / CON / ... */
  Unknown((byte)1),
  /** Entry is a regular file */
  File((byte)2),
  /** Entry is a directory */
  Directory((byte)3);

    public final byte value;
    private FileType(byte v) { this.value = v; }
    private FileType(FileType e) { this.value = e.value; }
    public FileType intern() { for (FileType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

@Namespace("arrow::fs") public static native @StdString String ToString(FileType arg0);
@Namespace("arrow::fs") public static native @StdString BytePointer ToString(@Cast("arrow::fs::FileType") byte arg0);

@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, FileType arg1);
@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Cast("arrow::fs::FileType") byte arg1);

@Namespace("arrow::fs") @MemberGetter public static native @Cast("const int64_t") long kNoSize();
public static final long kNoSize = kNoSize();
@Namespace("arrow::fs") @MemberGetter public static native @ByRef @Cast("const arrow::fs::TimePoint*") Pointer kNoTime();
// Targeting ../FileStats.java



@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef FileStats arg1);
// Targeting ../FileSelector.java


// Targeting ../FileSystem.java


// Targeting ../SubTreeFileSystem.java


// Targeting ../SlowFileSystem.java



/** \defgroup filesystem-factories Functions for creating FileSystem instances
 * 
 *  \{
 <p>
 *  \brief Create a new FileSystem by URI
 * 
 *  A scheme-less URI is considered a local filesystem path.
 *  Recognized schemes are "file", "mock" and "hdfs".
 * 
 *  @param uri [in] a URI-based path, ex: file:///some/local/path
 *  @param out_path [out] (optional) Path inside the filesystem.
 *  @return out_fs FileSystem instance. */


/** \}
 <p>
 *  \brief Create a new FileSystem by URI
 * 
 *  A scheme-less URI is considered a local filesystem path.
 *  Recognized schemes are "file", "mock" and "hdfs".
 * 
 *  @param uri [in] a URI-based path, ex: file:///some/local/path
 *  @param out_fs [out] FileSystem instance.
 *  @param out_path [out] (optional) Path inside the filesystem.
 *  @return Status */


  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/localfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/filesystem/filesystem.h"
// Targeting ../LocalFileSystemOptions.java


// Targeting ../LocalFileSystem.java



  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/mockfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/filesystem/filesystem.h"
// Targeting ../DirInfo.java


// Targeting ../FileInfo.java


// Targeting ../MockFileSystem.java



  // namespace internal
  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/path_forest.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/filesystem/filesystem.h"

// #include <algorithm>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/sort.h"
// Targeting ../PathForest.java



@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef PathForest tree);

  // namespace fs
  // namespace arrow


// Parsed from arrow/csv/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_CSV_API_H
// #define ARROW_CSV_API_H

// #include "arrow/csv/options.h"
// #include "arrow/csv/reader.h"

// #endif  // ARROW_CSV_API_H


// Parsed from arrow/csv/options.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_CSV_OPTIONS_H
// #define ARROW_CSV_OPTIONS_H

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <vector>

// #include "arrow/util/visibility.h"

// Silly workaround for https://github.com/michaeljones/breathe/issues/453
@Namespace("arrow::csv") @MemberGetter public static native byte kDefaultEscapeChar();
// Targeting ../CsvParseOptions.java


// Targeting ../ConvertOptions.java


// Targeting ../ReadOptions.java



  // namespace csv
  // namespace arrow

// #endif  // ARROW_CSV_OPTIONS_H


// Parsed from arrow/csv/reader.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/csv/options.h"  // IWYU pragma: keep
// #include "arrow/result.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
  // namespace io
// Targeting ../TableReader.java



  // namespace csv
  // namespace arrow


// Parsed from arrow/json/options.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/util/visibility.h"

@Namespace("arrow::json") public enum UnexpectedFieldBehavior {
  /** Unexpected JSON fields are ignored */
  Ignore((byte)0),
  /** Unexpected JSON fields error out */
  Error((byte)1),
  /** Unexpected JSON fields are type-inferred and included in the output */
  InferType((byte)2);

    public final byte value;
    private UnexpectedFieldBehavior(byte v) { this.value = v; }
    private UnexpectedFieldBehavior(UnexpectedFieldBehavior e) { this.value = e.value; }
    public UnexpectedFieldBehavior intern() { for (UnexpectedFieldBehavior e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../JsonParseOptions.java



  // namespace json
  // namespace arrow


// Parsed from arrow/json/reader.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/json/options.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
  // namespace io

/** A class that reads an entire JSON file into a Arrow Table
 * 
 *  The file is expected to consist of individual line-separated JSON objects */

@Namespace("arrow::json") public static native @ByVal Status ParseOne(@ByVal JsonParseOptions options, @SharedPtr ArrowBuffer json,
                             @SharedPtr RecordBatch out);

/** \brief convert an Array produced by BlockParser into an Array of out_type */


  // namespace json
  // namespace arrow


// Parsed from arrow/compute/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_COMPUTE_API_H
// #define ARROW_COMPUTE_API_H

// #include "arrow/compute/context.h"  // IWYU pragma: export
// #include "arrow/compute/kernel.h"   // IWYU pragma: export

// #include "arrow/compute/kernels/boolean.h"          // IWYU pragma: export
// #include "arrow/compute/kernels/cast.h"             // IWYU pragma: export
// #include "arrow/compute/kernels/compare.h"          // IWYU pragma: export
// #include "arrow/compute/kernels/count.h"            // IWYU pragma: export
// #include "arrow/compute/kernels/filter.h"           // IWYU pragma: export
// #include "arrow/compute/kernels/hash.h"             // IWYU pragma: export
// #include "arrow/compute/kernels/isin.h"             // IWYU pragma: export
// #include "arrow/compute/kernels/mean.h"             // IWYU pragma: export
// #include "arrow/compute/kernels/sort_to_indices.h"  // IWYU pragma: export
// #include "arrow/compute/kernels/sum.h"              // IWYU pragma: export
// #include "arrow/compute/kernels/take.h"             // IWYU pragma: export

// #endif  // ARROW_COMPUTE_API_H


// Parsed from arrow/compute/context.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_COMPUTE_CONTEXT_H
// #define ARROW_COMPUTE_CONTEXT_H

// #include <cstdint>
// #include <memory>

// #include "arrow/memory_pool.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../CpuInfo.java


  // namespace internal

// #define ARROW_RETURN_IF_ERROR(ctx)
//   if (ARROW_PREDICT_FALSE(ctx->HasError())) {
//     Status s = ctx->status();
//     ctx->ResetStatus();
//     return s;
//   }
// Targeting ../FunctionContext.java



  // namespace compute
  // namespace arrow

// #endif  // ARROW_COMPUTE_CONTEXT_H


// Parsed from arrow/compute/kernel.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_COMPUTE_KERNEL_H
// #define ARROW_COMPUTE_KERNEL_H

// #include <memory>
// #include <utility>
// #include <vector>

// #include "arrow/array.h"
// #include "arrow/record_batch.h"
// #include "arrow/scalar.h"
// #include "arrow/table.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/memory.h"
// #include "arrow/util/variant.h"  // IWYU pragma: export
// #include "arrow/util/visibility.h"
// Targeting ../OpKernel.java


@Namespace("arrow::compute") public static native @Cast("bool") boolean CollectionEquals(@Const @ByRef DatumVector left,
                                    @Const @ByRef DatumVector right);

// Datums variants may have a length. This special value indicate that the
// current variant does not have a length.
@Namespace("arrow::compute") @MemberGetter public static native @Cast("const int64_t") long kUnknownLength();
// Targeting ../Datum.java


// Targeting ../UnaryKernel.java


// Targeting ../BinaryKernel.java



  // namespace compute
  // namespace arrow

// #endif  // ARROW_COMPUTE_KERNEL_H


// Parsed from arrow/compute/kernels/boolean.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_COMPUTE_KERNELS_BOOLEAN_H
// #define ARROW_COMPUTE_KERNELS_BOOLEAN_H

// #include "arrow/status.h"
// #include "arrow/util/visibility.h"

/** \brief Invert the values of a boolean datum
 *  @param context [in] the FunctionContext
 *  @param value [in] datum to invert
 *  @param out [out] resulting datum
 * 
 *  @since 0.11.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Invert(FunctionContext context, @Const @ByRef Datum value, Datum out);

/** \brief Element-wise AND of two boolean datums which always propagates nulls
 *  (null and false is null).
 * 
 *  @param context [in] the FunctionContext
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param out [out] resulting datum
 * 
 *  @since 0.11.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status And(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right, Datum out);

/** \brief Element-wise AND of two boolean datums with a Kleene truth table
 *  (null and false is false).
 * 
 *  @param context [in] the FunctionContext
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param out [out] resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status KleeneAnd(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right,
                 Datum out);

/** \brief Element-wise OR of two boolean datums which always propagates nulls
 *  (null and true is null).
 * 
 *  @param context [in] the FunctionContext
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param out [out] resulting datum
 * 
 *  @since 0.11.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Or(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right, Datum out);

/** \brief Element-wise OR of two boolean datums with a Kleene truth table
 *  (null or true is true).
 * 
 *  @param context [in] the FunctionContext
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param out [out] resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal Status KleeneOr(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right,
                Datum out);

/** \brief Element-wise XOR of two boolean datums
 *  @param context [in] the FunctionContext
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param out [out] resulting datum
 * 
 *  @since 0.11.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Xor(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right, Datum out);

  // namespace compute
  // namespace arrow

// #endif  // ARROW_COMPUTE_KERNELS_CAST_H


// Parsed from arrow/compute/kernels/cast.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/status.h"
// #include "arrow/util/visibility.h"
// Targeting ../CastOptions.java



/** @since 0.7.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal Status GetCastFunction(@Const @ByRef DataType in_type, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type,
                       @Const @ByRef CastOptions options, @UniquePtr UnaryKernel kernel);

/** \brief Cast from one array type to another
 *  @param context [in] the FunctionContext
 *  @param value [in] array to cast
 *  @param to_type [in] type to cast to
 *  @param options [in] casting options
 *  @param out [out] resulting array
 * 
 *  @since 0.7.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal Status Cast(FunctionContext context, @Const @ByRef Array value,
            @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type, @Const @ByRef CastOptions options,
            @SharedPtr Array out);

/** \brief Cast from one value to another
 *  @param context [in] the FunctionContext
 *  @param value [in] datum to cast
 *  @param to_type [in] type to cast to
 *  @param options [in] casting options
 *  @param out [out] resulting datum
 * 
 *  @since 0.8.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Cast(FunctionContext context, @Const @ByRef Datum value,
            @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type, @Const @ByRef CastOptions options, Datum out);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/compare.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/compute/kernel.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow::compute") public enum CompareOperator {
  EQUAL(0),
  NOT_EQUAL(1),
  GREATER(2),
  GREATER_EQUAL(3),
  LESS(4),
  LESS_EQUAL(5);

    public final int value;
    private CompareOperator(int v) { this.value = v; }
    private CompareOperator(CompareOperator e) { this.value = e.value; }
    public CompareOperator intern() { for (CompareOperator e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../CompareOptions.java



/** \brief BinaryKernel bound implementing comparison */


/** \brief Compare a numeric array with a scalar.
 * 
 *  @param context [in] the FunctionContext
 *  @param left [in] datum to compare, must be an Array
 *  @param right [in] datum to compare, must be a Scalar of the same type than
 *             left Datum.
 *  @param options [in] compare options
 *  @param out [out] resulting datum
 * 
 *  Note on floating point arrays, this uses ieee-754 compare semantics.
 * 
 *  @since 0.14.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Compare(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right,
               @ByVal CompareOptions options, Datum out);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/count.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <type_traits>

// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/visibility.h"
// Targeting ../AggregateFunction.java


// Targeting ../CountOptions.java



/** \brief Return Count function aggregate */


/** \brief Count non-null (or null) values in an array.
 * 
 *  @param context [in] the FunctionContext
 *  @param options [in] counting options, see CountOptions for more information
 *  @param datum [in] to count
 *  @param out [out] resulting datum
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Count(FunctionContext context, @Const @ByRef CountOptions options, @Const @ByRef Datum datum,
             Datum out);

/** \brief Count non-null (or null) values in an array.
 * 
 *  @param context [in] the FunctionContext
 *  @param options [in] counting options, see CountOptions for more information
 *  @param array [in] to count
 *  @param out [out] resulting datum
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Count(FunctionContext context, @Const @ByRef CountOptions options, @Const @ByRef Array array,
             Datum out);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/filter.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/compute/kernel.h"
// #include "arrow/record_batch.h"
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"

/** \brief Filter an array with a boolean selection filter
 * 
 *  The output array will be populated with values from the input at positions
 *  where the selection filter is not 0. Nulls in the filter will result in nulls
 *  in the output.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  filter = [0, 1, 1, 0, null, 1], the output will be
 *  = ["b", "c", null, "f"]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] array to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting array */

///
///
///
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef Array values, @Const @ByRef Array filter,
              @SharedPtr Array out);

/** \brief Filter a chunked array with a boolean selection filter
 * 
 *  The output chunked array will be populated with values from the input at positions
 *  where the selection filter is not 0. Nulls in the filter will result in nulls
 *  in the output.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  filter = [0, 1, 1, 0, null, 1], the output will be
 *  = ["b", "c", null, "f"]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] chunked array to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting chunked array
 *  NOTE: Experimental API */

///
///
///
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef ChunkedArray values, @Const @ByRef Array filter,
              @SharedPtr ChunkedArray out);

/** \brief Filter a chunked array with a boolean selection filter
 * 
 *  The output chunked array will be populated with values from the input at positions
 *  where the selection filter is not 0. Nulls in the filter will result in nulls
 *  in the output.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  filter = [0, 1, 1, 0, null, 1], the output will be
 *  = ["b", "c", null, "f"]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] chunked array to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting chunked array
 *  NOTE: Experimental API */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef ChunkedArray values,
              @Const @ByRef ChunkedArray filter, @SharedPtr ChunkedArray out);

/** \brief Filter a record batch with a boolean selection filter
 * 
 *  The output record batch's columns will be populated with values from corresponding
 *  columns of the input at positions where the selection filter is not 0. Nulls in the
 *  filter will result in nulls in the output.
 * 
 *  @param ctx [in] the FunctionContext
 *  @param batch [in] record batch to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting record batch
 *  NOTE: Experimental API */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef RecordBatch batch, @Const @ByRef Array filter,
              @SharedPtr RecordBatch out);

/** \brief Filter a table with a boolean selection filter
 * 
 *  The output table's columns will be populated with values from corresponding
 *  columns of the input at positions where the selection filter is not 0. Nulls in the
 *  filter will result in nulls in each column of the output.
 * 
 *  @param ctx [in] the FunctionContext
 *  @param table [in] table to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting table
 *  NOTE: Experimental API */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef Table table, @Const @ByRef Array filter,
              @SharedPtr Table out);

/** \brief Filter a table with a boolean selection filter
 * 
 *  The output record batch's columns will be populated with values from corresponding
 *  columns of the input at positions where the selection filter is not 0. Nulls in the
 *  filter will result in nulls in the output.
 * 
 *  @param ctx [in] the FunctionContext
 *  @param table [in] record batch to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting record batch
 *  NOTE: Experimental API */

///
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef Table table, @Const @ByRef ChunkedArray filter,
              @SharedPtr Table out);

/** \brief Filter an array with a boolean selection filter
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] datum to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param out [out] resulting datum */
@Namespace("arrow::compute") public static native @ByVal Status Filter(FunctionContext ctx, @Const @ByRef Datum values, @Const @ByRef Datum filter, Datum out);
// Targeting ../FilterKernel.java



  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/hash.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_COMPUTE_KERNELS_HASH_H
// #define ARROW_COMPUTE_KERNELS_HASH_H

// #include <memory>

// #include "arrow/compute/kernel.h"
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"

/** \brief Compute unique elements from an array-like object
 * 
 *  Note if a null occurs in the input it will NOT be included in the output.
 * 
 *  @param context [in] the FunctionContext
 *  @param datum [in] array-like input
 *  @param out [out] result as Array
 * 
 *  @since 0.8.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Unique(FunctionContext context, @Const @ByRef Datum datum, @SharedPtr Array out);

// Constants for accessing the output of ValueCounts
@Namespace("arrow::compute") @MemberGetter public static native byte kValuesFieldName(int i);
@Namespace("arrow::compute") @MemberGetter public static native String kValuesFieldName();
@Namespace("arrow::compute") @MemberGetter public static native byte kCountsFieldName(int i);
@Namespace("arrow::compute") @MemberGetter public static native String kCountsFieldName();
@Namespace("arrow::compute") @MemberGetter public static native int kValuesFieldIndex();

///
///
///
///
@Namespace("arrow::compute") @MemberGetter public static native int kCountsFieldIndex();
/** \brief Return counts of unique elements from an array-like object.
 * 
 *  Note that the counts do not include counts for nulls in the array.  These can be
 *  obtained separately from metadata.
 * 
 *  For floating point arrays there is no attempt to normalize -0.0, 0.0 and NaN values
 *  which can lead to unexpected results if the input Array has these values.
 * 
 *  @param context [in] the FunctionContext
 *  @param value [in] array-like input
 *  @param counts [out] An array of  <input type "Values", int64_t "Counts"> structs.
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal Status ValueCounts(FunctionContext context, @Const @ByRef Datum value,
                   @SharedPtr Array counts);

/** \brief Dictionary-encode values in an array-like object
 *  @param context [in] the FunctionContext
 *  @param data [in] array-like input
 *  @param out [out] result with same shape and type as input
 * 
 *  @since 0.8.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status DictionaryEncode(FunctionContext context, @Const @ByRef Datum data, Datum out);

// TODO(wesm): Define API for incremental dictionary encoding

// TODO(wesm): Define API for regularizing DictionaryArray objects with
// different dictionaries

//
// ARROW_EXPORT
// Status DictionaryEncode(FunctionContext* context, const Datum& data,
//                         const Array& prior_dictionary, Datum* out);

// TODO(wesm): Implement these next
// ARROW_EXPORT
// Status Match(FunctionContext* context, const Datum& values, const Datum& member_set,
//              Datum* out);

// ARROW_EXPORT
// Status IsIn(FunctionContext* context, const Datum& values, const Datum& member_set,
//             Datum* out);

  // namespace compute
  // namespace arrow

// #endif  // ARROW_COMPUTE_KERNELS_HASH_H


// Parsed from arrow/compute/kernels/isin.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/array.h"
// #include "arrow/compute/context.h"
// #include "arrow/compute/kernel.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/visibility.h"

/** \brief IsIn returns boolean values if the value
 *  is in both left and right arrays.
 * 
 *  If null occurs in left, if null count in right is not 0,
 *  it returns true, else returns null.
 * 
 *  @param context [in] the FunctionContext
 *  @param left [in] array-like input
 *  @param right [in] array-like input
 *  @param out [out] resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status IsIn(FunctionContext context, @Const @ByRef Datum left, @Const @ByRef Datum right, Datum out);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/mean.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <type_traits>

// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/visibility.h"


///
///
@Namespace("arrow::compute") public static native @SharedPtr AggregateFunction MakeMeanAggregateFunction(@Const @ByRef DataType type,
                                                             FunctionContext context);

/** \brief Compute the mean of a numeric array.
 * 
 *  @param context [in] the FunctionContext
 *  @param value [in] datum to compute the mean, expecting Array
 *  @param mean [out] datum of the computed mean as a DoubleScalar
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Mean(FunctionContext context, @Const @ByRef Datum value, Datum mean);

/** \brief Compute the mean of a numeric array.
 * 
 *  @param context [in] the FunctionContext
 *  @param array [in] to compute the mean
 *  @param mean [out] datum of the computed mean as a DoubleScalar
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Mean(FunctionContext context, @Const @ByRef Array array, Datum mean);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/sort_to_indices.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/compute/kernel.h"
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"

/** \brief Returns the indices that would sort an array.
 * 
 *  Perform an indirect sort of array. The output array will contain
 *  indices that would sort an array, which would be the same length
 *  as input. Nulls will be stably partitioned to the end of the output.
 * 
 *  For example given values = [null, 1, 3.3, null, 2, 5.3], the output
 *  will be [1, 4, 2, 5, 0, 3]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] array to sort
 *  @param offsets [out] indices that would sort an array */
@Namespace("arrow::compute") public static native @ByVal Status SortToIndices(FunctionContext ctx, @Const @ByRef Array values,
                     @SharedPtr Array offsets);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/sum.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/util/visibility.h"

/** \brief Return a Sum Kernel
 * 
 *  @param type [in] required to specialize the kernel
 *  @param context [in] the FunctionContext
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @SharedPtr AggregateFunction MakeSumAggregateFunction(@Const @ByRef DataType type,
                                                            FunctionContext context);

/** \brief Sum values of a numeric array.
 * 
 *  @param context [in] the FunctionContext
 *  @param value [in] datum to sum, expecting Array or ChunkedArray
 *  @param out [out] resulting datum
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Sum(FunctionContext context, @Const @ByRef Datum value, Datum out);

/** \brief Sum values of a numeric array.
 * 
 *  @param context [in] the FunctionContext
 *  @param array [in] to sum
 *  @param out [out] resulting datum
 * 
 *  @since 0.13.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal Status Sum(FunctionContext context, @Const @ByRef Array array, Datum out);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernels/take.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/compute/kernel.h"
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"
// Targeting ../TakeOptions.java



/** \brief Take from an array of values at indices in another array
 * 
 *  The output array will be of the same type as the input values
 *  array, with elements taken from the values array at the given
 *  indices. If an index is null then the taken element will be null.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  indices = [2, 1, null, 3], the output will be
 *  = [values[2], values[1], null, values[3]]
 *  = ["c", "b", null, null]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] array from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting array */

///
///
///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef Array values, @Const @ByRef Array indices,
            @Const @ByRef TakeOptions options, @SharedPtr Array out);

/** \brief Take from a chunked array of values at indices in another array
 * 
 *  The output chunked array will be of the same type as the input values
 *  array, with elements taken from the values array at the given
 *  indices. If an index is null then the taken element will be null.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  indices = [2, 1, null, 3], the output will be
 *  = [values[2], values[1], null, values[3]]
 *  = ["c", "b", null, null]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] chunked array from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting chunked array
 *  NOTE: Experimental API */

///
///
///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef ChunkedArray values, @Const @ByRef Array indices,
            @Const @ByRef TakeOptions options, @SharedPtr ChunkedArray out);

/** \brief Take from a chunked array of values at indices in a chunked array
 * 
 *  The output chunked array will be of the same type as the input values
 *  array, with elements taken from the values array at the given
 *  indices. If an index is null then the taken element will be null.
 *  The chunks in the output array will align with the chunks in the indices.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  indices = [2, 1, null, 3], the output will be
 *  = [values[2], values[1], null, values[3]]
 *  = ["c", "b", null, null]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] chunked array from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting chunked array
 *  NOTE: Experimental API */

///
///
///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef ChunkedArray values, @Const @ByRef ChunkedArray indices,
            @Const @ByRef TakeOptions options, @SharedPtr ChunkedArray out);

/** \brief Take from an array of values at indices in a chunked array
 * 
 *  The output chunked array will be of the same type as the input values
 *  array, with elements taken from the values array at the given
 *  indices. If an index is null then the taken element will be null.
 *  The chunks in the output array will align with the chunks in the indices.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  indices = [2, 1, null, 3], the output will be
 *  = [values[2], values[1], null, values[3]]
 *  = ["c", "b", null, null]
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] array from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting chunked array
 *  NOTE: Experimental API */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef Array values, @Const @ByRef ChunkedArray indices,
            @Const @ByRef TakeOptions options, @SharedPtr ChunkedArray out);

/** \brief Take from a record batch at indices in another array
 * 
 *  The output batch will have the same schema as the input batch,
 *  with rows taken from the columns in the batch at the given
 *  indices. If an index is null then the taken element will be null.
 * 
 *  @param ctx [in] the FunctionContext
 *  @param batch [in] record batch from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting record batch
 *  NOTE: Experimental API */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef RecordBatch batch, @Const @ByRef Array indices,
            @Const @ByRef TakeOptions options, @SharedPtr RecordBatch out);

/** \brief Take from a table at indices in an array
 * 
 *  The output table will have the same schema as the input table,
 *  with rows taken from the columns in the table at the given
 *  indices. If an index is null then the taken element will be null.
 * 
 *  @param ctx [in] the FunctionContext
 *  @param table [in] table from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting table
 *  NOTE: Experimental API */

///
///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef Table table, @Const @ByRef Array indices,
            @Const @ByRef TakeOptions options, @SharedPtr Table out);

/** \brief Take from a table at indices in a chunked array
 * 
 *  The output table will have the same schema as the input table,
 *  with rows taken from the values array at the given
 *  indices. If an index is null then the taken element will be null.
 * 
 *  @param ctx [in] the FunctionContext
 *  @param table [in] table from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting table
 *  NOTE: Experimental API */

///
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef Table table, @Const @ByRef ChunkedArray indices,
            @Const @ByRef TakeOptions options, @SharedPtr Table out);

/** \brief Take from an array of values at indices in another array
 * 
 *  @param ctx [in] the FunctionContext
 *  @param values [in] datum from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param out [out] resulting datum */
@Namespace("arrow::compute") public static native @ByVal Status Take(FunctionContext ctx, @Const @ByRef Datum values, @Const @ByRef Datum indices,
            @Const @ByRef TakeOptions options, Datum out);
// Targeting ../TakeKernel.java


  // namespace compute
  // namespace arrow


// Parsed from arrow/ipc/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #ifndef ARROW_IPC_API_H
// #define ARROW_IPC_API_H

// #include "arrow/ipc/dictionary.h"
// #include "arrow/ipc/feather.h"
// #include "arrow/ipc/json_simple.h"
// #include "arrow/ipc/message.h"
// #include "arrow/ipc/reader.h"
// #include "arrow/ipc/writer.h"

// #endif  // ARROW_IPC_API_H


// Parsed from arrow/ipc/dictionary.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Tools for dictionaries in IPC context

// #ifndef ARROW_IPC_DICTIONARY_H
// #define ARROW_IPC_DICTIONARY_H

// #include <cstdint>
// #include <memory>
// #include <unordered_map>

// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ../DictionaryMemo.java



@Namespace("arrow::ipc") public static native @ByVal Status CollectDictionaries(@Const @ByRef RecordBatch batch, DictionaryMemo memo);

  // namespace ipc
  // namespace arrow

// #endif  // ARROW_IPC_DICTIONARY_H


// Parsed from arrow/ipc/feather.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Public API for the "Feather" file format, originally created at
// http://github.com/wesm/feather

// #ifndef ARROW_IPC_FEATHER_H
// #define ARROW_IPC_FEATHER_H

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/util/visibility.h"

  // namespace io

@Namespace("arrow::ipc::feather") @MemberGetter public static native int kFeatherVersion();
public static final int kFeatherVersion = kFeatherVersion();

// ----------------------------------------------------------------------
// Metadata accessor classes

/** \class TableReader
 *  \brief An interface for reading columns from Feather files */
// Targeting ../TableWriter.java



  // namespace feather
  // namespace ipc
  // namespace arrow

// #endif  // ARROW_IPC_FEATHER_H


// Parsed from arrow/ipc/json_simple.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Implement a simple JSON representation format for arrays

// #ifndef ARROW_IPC_JSON_SIMPLE_H
// #define ARROW_IPC_JSON_SIMPLE_H

// #include <memory>
// #include <string>

// #include "arrow/status.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow::ipc::internal::json") public static native @ByVal Status ArrayFromJSON(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType arg0, @StdString String json,
                     @SharedPtr Array out);
@Namespace("arrow::ipc::internal::json") public static native @ByVal Status ArrayFromJSON(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType arg0, @StdString BytePointer json,
                     @SharedPtr Array out);

  // namespace json
  // namespace internal
  // namespace ipc
  // namespace arrow

// #endif  // ARROW_IPC_JSON_SIMPLE_H


// Parsed from arrow/ipc/options.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>

// #include "arrow/util/visibility.h"

// ARROW-109: We set this number arbitrarily to help catch user mistakes. For
// deeply nested schemas, it is expected the user will indicate explicitly the
// maximum allowed recursion depth
@Namespace("arrow::ipc") @MemberGetter public static native int kMaxNestingDepth();
// Targeting ../IpcOptions.java



  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/message.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// C++ object model and user API for interprocess schema messaging

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>

// #include "arrow/ipc/options.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

  // namespace io

@Namespace("arrow::ipc") public enum MetadataVersion {
  /** 0.1.0 */
  V1((byte)0),

  /** 0.2.0 */
  V2((byte)1),

  /** 0.3.0 to 0.7.1 */
  V3((byte)2),

  /** >= 0.8.0 */
  V4((byte)3);

    public final byte value;
    private MetadataVersion(byte v) { this.value = v; }
    private MetadataVersion(MetadataVersion e) { this.value = e.value; }
    public MetadataVersion intern() { for (MetadataVersion e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ../Message.java



@Namespace("arrow::ipc") public static native @StdString String FormatMessageType(Message.Type type);
@Namespace("arrow::ipc") public static native @StdString BytePointer FormatMessageType(@Cast("arrow::ipc::Message::Type") int type);
// Targeting ../MessageReader.java



/** \brief Read encapsulated RPC message from position in file
 * 
 *  Read a length-prefixed message flatbuffer starting at the indicated file
 *  offset. If the message has a body with non-zero length, it will also be
 *  read
 * 
 *  The metadata_length includes at least the length prefix and the flatbuffer
 * 
 *  @param offset [in] the position in the file where the message starts. The
 *  first 4 bytes after the offset are the message length
 *  @param metadata_length [in] the total number of bytes to read from file
 *  @param file [in] the seekable file interface to read from
 *  @param message [out] the message read
 *  @return Status success or failure */
@Namespace("arrow::ipc") public static native @ByVal Status ReadMessage(@Cast("const int64_t") long offset, int metadata_length,
                   RandomAccessFile file, @UniquePtr Message message);

/** \brief Advance stream to an 8-byte offset if its position is not a multiple
 *  of 8 already
 *  @param stream [in] an input stream
 *  @param alignment [in] the byte multiple for the metadata prefix, usually 8
 *  or 64, to ensure the body starts on a multiple of that alignment
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(InputStream stream, int alignment/*=8*/);
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(InputStream stream);

/** \brief Advance stream to an 8-byte offset if its position is not a multiple
 *  of 8 already
 *  @param stream [in] an output stream
 *  @param alignment [in] the byte multiple for the metadata prefix, usually 8
 *  or 64, to ensure the body starts on a multiple of that alignment
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(OutputStream stream, int alignment/*=8*/);
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(OutputStream stream);

/** \brief Return error Status if file position is not a multiple of the
 *  indicated alignment */

///
@Namespace("arrow::ipc") public static native @ByVal Status CheckAligned(FileInterface stream, int alignment/*=8*/);
@Namespace("arrow::ipc") public static native @ByVal Status CheckAligned(FileInterface stream);

/** \brief Read encapsulated IPC message (metadata and body) from InputStream
 * 
 *  Returns null if there are not enough bytes available or the
 *  message length is 0 (e.g. EOS in a stream) */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadMessage(InputStream stream, @UniquePtr Message message);

/** \brief Read encapsulated IPC message (metadata and body) from InputStream
 * 
 *  Like ReadMessage, except that the metadata is copied in a new buffer.
 *  This is necessary if the stream returns non-CPU buffers. */

///
///
@Namespace("arrow::ipc") public static native @ByVal Status ReadMessageCopy(InputStream stream, MemoryPool pool,
                       @UniquePtr Message message);

/** Write encapsulated IPC message Does not make assumptions about
 *  whether the stream is aligned already. Can write legacy (pre
 *  version 0.15.0) IPC message if option set
 * 
 *  continuation: 0xFFFFFFFF
 *  message_size: int32
 *  message: const void*
 *  padding
 * 
 *  @param message [in] a buffer containing the metadata to write
 *  @param options [in] IPC writing options, including alignment and
 *  legacy message support
 *  @param file [in,out] the OutputStream to write to
 *  @param message_length [out] the total size of the payload written including
 *  padding
 *  @return Status */


  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/reader.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Read Arrow files and streams

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/ipc/dictionary.h"
// #include "arrow/ipc/message.h"
// #include "arrow/ipc/options.h"
// #include "arrow/ipc/writer.h"
// #include "arrow/record_batch.h"
// #include "arrow/sparse_tensor.h"
// #include "arrow/util/visibility.h"

  // namespace io


///
// Targeting ../RecordBatchStreamReader.java


// Targeting ../RecordBatchFileReader.java



// Generic read functions; does not copy data if the input supports zero copy reads

/** \brief Read Schema from stream serialized as a single IPC message
 *  and populate any dictionary-encoded fields into a DictionaryMemo
 * 
 *  @param stream [in] an InputStream
 *  @param dictionary_memo [in] for recording dictionary-encoded fields
 *  @param out [out] the output Schema
 *  @return Status
 * 
 *  If record batches follow the schema, it is better to use
 *  RecordBatchStreamReader */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadSchema(InputStream stream, DictionaryMemo dictionary_memo,
                  @SharedPtr Schema out);

/** \brief Read Schema from encapsulated Message
 * 
 *  @param message [in] a message instance containing metadata
 *  @param dictionary_memo [in] DictionaryMemo for recording dictionary-encoded
 *  fields. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param out [out] the resulting Schema
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadSchema(@Const @ByRef Message message, DictionaryMemo dictionary_memo,
                  @SharedPtr Schema out);

/** Read record batch as encapsulated IPC message with metadata size prefix and
 *  header
 * 
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param stream [in] the file where the batch is located
 *  @param out [out] the read record batch
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadRecordBatch(@Const @SharedPtr @ByRef Schema schema,
                       @Const DictionaryMemo dictionary_memo, InputStream stream,
                       @SharedPtr RecordBatch out);

/** \brief Read record batch from file given metadata and schema
 * 
 *  @param metadata [in] a Message containing the record batch metadata
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param file [in] a random access file
 *  @param out [out] the read record batch
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadRecordBatch(@Const @ByRef ArrowBuffer metadata, @Const @SharedPtr @ByRef Schema schema,
                       @Const DictionaryMemo dictionary_memo, RandomAccessFile file,
                       @SharedPtr RecordBatch out);

/** \brief Read record batch from encapsulated Message
 * 
 *  @param message [in] a message instance containing metadata and body
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param out [out] the resulting RecordBatch
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadRecordBatch(@Const @ByRef Message message, @Const @SharedPtr @ByRef Schema schema,
                       @Const DictionaryMemo dictionary_memo,
                       @SharedPtr RecordBatch out);

/** Read record batch from file given metadata and schema
 * 
 *  @param metadata [in] a Message containing the record batch metadata
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param file [in] a random access file
 *  @param options [in] options for deserialization
 *  @param out [out] the read record batch
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status ReadRecordBatch(@Const @ByRef ArrowBuffer metadata, @Const @SharedPtr @ByRef Schema schema,
                       @Const DictionaryMemo dictionary_memo, @Const @ByRef IpcOptions options,
                       RandomAccessFile file, @SharedPtr RecordBatch out);

/** \brief Read arrow::Tensor as encapsulated IPC message in file
 * 
 *  @param file [in] an InputStream pointed at the start of the message
 *  @return the read tensor */

///
@Namespace("arrow::ipc") public static native @ByVal TensorResult ReadTensor(InputStream file);

/** \brief EXPERIMENTAL: Read arrow::Tensor from IPC message
 * 
 *  @param message [in] a Message containing the tensor metadata and body
 *  @return the read tensor */

///
@Namespace("arrow::ipc") public static native @ByVal TensorResult ReadTensor(@Const @ByRef Message message);

/** \brief EXPERIMENTAL: Read arrow::SparseTensor as encapsulated IPC message in file
 * 
 *  @param file [in] an InputStream pointed at the start of the message
 *  @return the read sparse tensor */


/** \brief EXPERIMENTAL: Read arrow::SparseTensor from IPC message
 * 
 *  @param message [in] a Message containing the tensor metadata and body
 *  @return the read sparse tensor */


// These internal APIs may change without warning or deprecation

/** \brief EXPERIMENTAL: Read arrow::SparseTensorFormat::type from a metadata
 *  @param metadata [in] a Buffer containing the sparse tensor metadata
 *  @return the count of the body buffers */
@Namespace("arrow::ipc::internal") public static native @ByVal SizeTResult ReadSparseTensorBodyBufferCount(@Const @ByRef ArrowBuffer metadata);

/** \brief EXPERIMENTAL: Read arrow::SparseTensor from an IpcPayload
 *  @param payload [in] a IpcPayload contains a serialized SparseTensor
 *  @return the read sparse tensor */
@Namespace("arrow::ipc::internal") public static native @ByVal SparseTensorResult ReadSparseTensorPayload(@Const @ByRef IpcPayload payload);

// For fuzzing targets
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcStream(@Cast("const uint8_t*") BytePointer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcStream(@Cast("const uint8_t*") ByteBuffer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcStream(@Cast("const uint8_t*") byte[] data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcFile(@Cast("const uint8_t*") BytePointer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcFile(@Cast("const uint8_t*") ByteBuffer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcFile(@Cast("const uint8_t*") byte[] data, @Cast("int64_t") long size);

  // namespace internal

  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/writer.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Implement Arrow streaming binary format

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <vector>

// #include "arrow/ipc/dictionary.h"  // IWYU pragma: export
// #include "arrow/ipc/message.h"
// #include "arrow/ipc/options.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"

  // namespace io
// Targeting ../RecordBatchWriter.java


// Targeting ../RecordBatchStreamWriter.java


// Targeting ../RecordBatchFileWriter.java



/** \brief Low-level API for writing a record batch (without schema)
 *  to an OutputStream as encapsulated IPC message. See Arrow format
 *  documentation for more detail.
 * 
 *  @param batch [in] the record batch to write
 *  @param buffer_start_offset [in] the start offset to use in the buffer metadata,
 *  generally should be 0
 *  @param dst [in] an OutputStream
 *  @param metadata_length [out] the size of the length-prefixed flatbuffer
 *  including padding to a 64-byte boundary
 *  @param body_length [out] the size of the contiguous buffer block plus
 *  @param options [in] options for serialization
 *  @param pool [in] the memory pool to allocate memory from
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch, @Cast("int64_t") long buffer_start_offset,
                        OutputStream dst, IntPointer metadata_length,
                        @Cast("int64_t*") LongPointer body_length, @Const @ByRef IpcOptions options,
                        MemoryPool pool);
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch, @Cast("int64_t") long buffer_start_offset,
                        OutputStream dst, IntBuffer metadata_length,
                        @Cast("int64_t*") LongBuffer body_length, @Const @ByRef IpcOptions options,
                        MemoryPool pool);
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch, @Cast("int64_t") long buffer_start_offset,
                        OutputStream dst, int[] metadata_length,
                        @Cast("int64_t*") long[] body_length, @Const @ByRef IpcOptions options,
                        MemoryPool pool);

/** \brief Serialize record batch as encapsulated IPC message in a new buffer
 * 
 *  @param batch [in] the record batch
 *  @param pool [in] a MemoryPool to allocate memory from
 *  @param out [out] the serialized message
 *  @return Status */

///
///
@Namespace("arrow::ipc") public static native @ByVal Status SerializeRecordBatch(@Const @ByRef RecordBatch batch, MemoryPool pool,
                            @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Write record batch to OutputStream
 * 
 *  @param batch [in] the record batch to write
 *  @param pool [in] a MemoryPool to use for temporary allocations, if needed
 *  @param out [in] the OutputStream to write the output to
 *  @return Status
 * 
 *  If writing to pre-allocated memory, you can use
 *  arrow::ipc::GetRecordBatchSize to compute how much space is required */

///
@Namespace("arrow::ipc") public static native @ByVal Status SerializeRecordBatch(@Const @ByRef RecordBatch batch, MemoryPool pool,
                            OutputStream out);

/** \brief Serialize schema as encapsulated IPC message
 * 
 *  @param schema [in] the schema to write
 *  @param dictionary_memo [in] a DictionaryMemo for recording dictionary ids
 *  @param pool [in] a MemoryPool to allocate memory from
 *  @param out [out] the serialized schema
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status SerializeSchema(@Const @ByRef Schema schema, DictionaryMemo dictionary_memo,
                       MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out);

/** \brief Write multiple record batches to OutputStream, including schema
 *  @param batches [in] a vector of batches. Must all have same schema
 *  @param options [in] options for serialization
 *  @param dst [out] an OutputStream
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatchStream(@Const @ByRef RecordBatchVector batches,
                              @Const @ByRef IpcOptions options, OutputStream dst);

/** \brief Compute the number of bytes needed to write a record batch including metadata
 * 
 *  @param batch [in] the record batch to write
 *  @param size [out] the size of the complete encapsulated message
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Cast("int64_t*") LongPointer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Cast("int64_t*") LongBuffer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Cast("int64_t*") long[] size);

/** \brief Compute the number of bytes needed to write a tensor including metadata
 * 
 *  @param tensor [in] the tensor to write
 *  @param size [out] the size of the complete encapsulated message
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorSize(@Const @ByRef Tensor tensor, @Cast("int64_t*") LongPointer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorSize(@Const @ByRef Tensor tensor, @Cast("int64_t*") LongBuffer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorSize(@Const @ByRef Tensor tensor, @Cast("int64_t*") long[] size);

/** \brief EXPERIMENTAL: Convert arrow::Tensor to a Message with minimal memory
 *  allocation
 * 
 *  @param tensor [in] the Tensor to write
 *  @param pool [in] MemoryPool to allocate space for metadata
 *  @param out [out] the resulting Message
 *  @return Status */

///
///
///
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorMessage(@Const @ByRef Tensor tensor, MemoryPool pool,
                        @UniquePtr Message out);

/** \brief Write arrow::Tensor as a contiguous message.
 * 
 *  The metadata and body are written assuming 64-byte alignment. It is the
 *  user's responsibility to ensure that the OutputStream has been aligned
 *  to a 64-byte multiple before writing the message.
 * 
 *  The message is written out as followed:
 *  <pre>{@code
 *  <metadata size> <metadata> <tensor data>
 *  }</pre>
 * 
 *  @param tensor [in] the Tensor to write
 *  @param dst [in] the OutputStream to write to
 *  @param metadata_length [out] the actual metadata length, including padding
 *  @param body_length [out] the actual message body length
 *  @return Status */

///
///
@Namespace("arrow::ipc") public static native @ByVal Status WriteTensor(@Const @ByRef Tensor tensor, OutputStream dst, IntPointer metadata_length,
                   @Cast("int64_t*") LongPointer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteTensor(@Const @ByRef Tensor tensor, OutputStream dst, IntBuffer metadata_length,
                   @Cast("int64_t*") LongBuffer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteTensor(@Const @ByRef Tensor tensor, OutputStream dst, int[] metadata_length,
                   @Cast("int64_t*") long[] body_length);

/** \brief EXPERIMENTAL: Convert arrow::SparseTensor to a Message with minimal memory
 *  allocation
 * 
 *  The message is written out as followed:
 *  <pre>{@code
 *  <metadata size> <metadata> <sparse index> <sparse tensor body>
 *  }</pre>
 * 
 *  @param sparse_tensor [in] the SparseTensor to write
 *  @param pool [in] MemoryPool to allocate space for metadata
 *  @param out [out] the resulting Message
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status GetSparseTensorMessage(@Const @ByRef SparseTensor sparse_tensor, MemoryPool pool,
                              @UniquePtr Message out);

/** \brief EXPERIMENTAL: Write arrow::SparseTensor as a contiguous message. The metadata,
 *  sparse index, and body are written assuming 64-byte alignment. It is the
 *  user's responsibility to ensure that the OutputStream has been aligned
 *  to a 64-byte multiple before writing the message.
 * 
 *  @param sparse_tensor [in] the SparseTensor to write
 *  @param dst [in] the OutputStream to write to
 *  @param metadata_length [out] the actual metadata length, including padding
 *  @param body_length [out] the actual message body length
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status WriteSparseTensor(@Const @ByRef SparseTensor sparse_tensor, OutputStream dst,
                         IntPointer metadata_length, @Cast("int64_t*") LongPointer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteSparseTensor(@Const @ByRef SparseTensor sparse_tensor, OutputStream dst,
                         IntBuffer metadata_length, @Cast("int64_t*") LongBuffer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteSparseTensor(@Const @ByRef SparseTensor sparse_tensor, OutputStream dst,
                         int[] metadata_length, @Cast("int64_t*") long[] body_length);
// Targeting ../IpcPayload.java


// Targeting ../IpcPayloadWriter.java



/** Create a new RecordBatchWriter from IpcPayloadWriter and schema.
 * 
 *  @param sink [in] the IpcPayloadWriter to write to
 *  @param schema [in] the schema of the record batches to be written
 *  @param out [out] the created RecordBatchWriter
 *  @return Status */

///
@Namespace("arrow::ipc::internal") public static native @ByVal Status OpenRecordBatchWriter(@UniquePtr IpcPayloadWriter sink,
                             @Const @SharedPtr @ByRef Schema schema,
                             @UniquePtr RecordBatchWriter out);

/** Create a new RecordBatchWriter from IpcPayloadWriter and schema.
 * 
 *  @param sink [in] the IpcPayloadWriter to write to
 *  @param schema [in] the schema of the record batches to be written
 *  @param options [in] options for serialization
 *  @return Result<std::unique_ptr<RecordBatchWriter>> */
@Namespace("arrow::ipc::internal") public static native @ByVal RecordBatchWriterUniqueResult OpenRecordBatchWriter(
    @UniquePtr IpcPayloadWriter sink, @Const @SharedPtr @ByRef Schema schema,
    @Const @ByRef IpcOptions options);

/** \brief Compute IpcPayload for the given schema
 *  @param schema [in] the Schema that is being serialized
 *  @param options [in] options for serialization
 *  @param dictionary_memo [in,out] class to populate with assigned dictionary ids
 *  @param out [out] the returned vector of IpcPayloads
 *  @return Status */
@Namespace("arrow::ipc::internal") public static native @ByVal Status GetSchemaPayload(@Const @ByRef Schema schema, @Const @ByRef IpcOptions options,
                        DictionaryMemo dictionary_memo, IpcPayload out);

/** \brief Compute IpcPayload for a dictionary
 *  @param id [in] the dictionary id
 *  @param dictionary [in] the dictionary values
 *  @param options [in] options for serialization
 *  @param payload [out] the output IpcPayload
 *  @return Status */
@Namespace("arrow::ipc::internal") public static native @ByVal Status GetDictionaryPayload(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                            @Const @ByRef IpcOptions options, MemoryPool pool,
                            IpcPayload payload);

/** \brief Compute IpcPayload for the given record batch
 *  @param batch [in] the RecordBatch that is being serialized
 *  @param options [in] options for serialization
 *  @param pool [in,out] for any required temporary memory allocations
 *  @param out [out] the returned IpcPayload
 *  @return Status */
@Namespace("arrow::ipc::internal") public static native @ByVal Status GetRecordBatchPayload(@Const @ByRef RecordBatch batch, @Const @ByRef IpcOptions options,
                             MemoryPool pool, IpcPayload out);

@Namespace("arrow::ipc::internal") public static native @ByVal Status WriteIpcPayload(@Const @ByRef IpcPayload payload, @Const @ByRef IpcOptions options,
                       OutputStream dst, IntPointer metadata_length);
@Namespace("arrow::ipc::internal") public static native @ByVal Status WriteIpcPayload(@Const @ByRef IpcPayload payload, @Const @ByRef IpcOptions options,
                       OutputStream dst, IntBuffer metadata_length);
@Namespace("arrow::ipc::internal") public static native @ByVal Status WriteIpcPayload(@Const @ByRef IpcPayload payload, @Const @ByRef IpcOptions options,
                       OutputStream dst, int[] metadata_length);

/** \brief Compute IpcPayload for the given sparse tensor
 *  @param sparse_tensor [in] the SparseTensor that is being serialized
 *  @param pool [in,out] for any required temporary memory allocations
 *  @param out [out] the returned IpcPayload
 *  @return Status */
@Namespace("arrow::ipc::internal") public static native @ByVal Status GetSparseTensorPayload(@Const @ByRef SparseTensor sparse_tensor, MemoryPool pool,
                              IpcPayload out);

  // namespace internal

  // namespace ipc
  // namespace arrow


}
