// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Top-level interface for a Dataset with fragments coming
 *  from possibly multiple sources. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class Dataset extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Dataset(Pointer p) { super(p); }

  /** \brief Build a Dataset from uniform sources. */
  //
  /** @param sources [in] one or more input sources
  /** @param schema [in] a known schema to conform to */
  public static native @ByVal DatasetResult Make(@SharedPtr @ByVal Source sources,
                                                 @SharedPtr @ByVal Schema schema);

  /** \brief Begin to build a new Scan operation against this Dataset */
  public native @ByVal ScannerBuilderResult NewScan(@SharedPtr ScanContext context);
  public native @ByVal ScannerBuilderResult NewScan();

  public native @Const @SharedPtr @ByRef Source sources();

  public native @SharedPtr @ByVal Schema schema();
}
