// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief The path and filesystem where an actual file is located or a buffer which can
 *  be read like a file */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class FileSource extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileSource(Pointer p) { super(p); }

  // NOTE(kszucs): it'd be better to separate the BufferSource from FileSource
  public enum SourceType { PATH(0), BUFFER(1);

      public final int value;
      private SourceType(int v) { this.value = v; }
      private SourceType(SourceType e) { this.value = e.value; }
      public SourceType intern() { for (SourceType e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  public FileSource(@StdString String path, FileSystem filesystem,
               Compression.type compression/*=arrow::Compression::UNCOMPRESSED*/) { super((Pointer)null); allocate(path, filesystem, compression); }
  private native void allocate(@StdString String path, FileSystem filesystem,
               Compression.type compression/*=arrow::Compression::UNCOMPRESSED*/);
  public FileSource(@StdString String path, FileSystem filesystem) { super((Pointer)null); allocate(path, filesystem); }
  private native void allocate(@StdString String path, FileSystem filesystem);
  public FileSource(@StdString BytePointer path, FileSystem filesystem,
               @Cast("arrow::Compression::type") int compression/*=arrow::Compression::UNCOMPRESSED*/) { super((Pointer)null); allocate(path, filesystem, compression); }
  private native void allocate(@StdString BytePointer path, FileSystem filesystem,
               @Cast("arrow::Compression::type") int compression/*=arrow::Compression::UNCOMPRESSED*/);
  public FileSource(@StdString BytePointer path, FileSystem filesystem) { super((Pointer)null); allocate(path, filesystem); }
  private native void allocate(@StdString BytePointer path, FileSystem filesystem);

  public FileSource(@SharedPtr ArrowBuffer buffer,
                        Compression.type compression/*=arrow::Compression::UNCOMPRESSED*/) { super((Pointer)null); allocate(buffer, compression); }
  private native void allocate(@SharedPtr ArrowBuffer buffer,
                        Compression.type compression/*=arrow::Compression::UNCOMPRESSED*/);
  public FileSource(@SharedPtr ArrowBuffer buffer) { super((Pointer)null); allocate(buffer); }
  private native void allocate(@SharedPtr ArrowBuffer buffer);
  public FileSource(@SharedPtr ArrowBuffer buffer,
                        @Cast("arrow::Compression::type") int compression/*=arrow::Compression::UNCOMPRESSED*/) { super((Pointer)null); allocate(buffer, compression); }
  private native void allocate(@SharedPtr ArrowBuffer buffer,
                        @Cast("arrow::Compression::type") int compression/*=arrow::Compression::UNCOMPRESSED*/);

  public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef FileSource other);

  /** \brief The kind of file, whether stored in a filesystem, memory
   *  resident, or other */
  public native SourceType type();

  /** \brief Return the type of raw compression on the file, if any */
  public native Compression.type compression();

  /** \brief Return the file path, if any. Only valid when file source
   *  type is PATH */
  public native @StdString String path();

  /** \brief Return the filesystem, if any. Only non null when file
   *  source type is PATH */
  public native FileSystem filesystem();

  /** \brief Return the buffer containing the file, if any. Only value
   *  when file source type is BUFFER */
  public native @SharedPtr ArrowBuffer buffer();

  /** \brief Get a RandomAccessFile which views this file source */
  public native @ByVal RandomAccessFileResult Open();
}
