// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief A granular piece of a Dataset, such as an individual file, which can be
 *  read/scanned separately from other fragments.
 * 
 *  A Fragment yields a collection of RecordBatch, encapsulated in one or more ScanTasks. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class Fragment extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Fragment(Pointer p) { super(p); }

  /** \brief Scan returns an iterator of ScanTasks, each of which yields
   *  RecordBatches from this Fragment. */
  public native @ByVal ScanTaskIteratorResult Scan(@SharedPtr ScanContext context);

  /** \brief Return true if the fragment can benefit from parallel
   *  scanning */
  public native @Cast("bool") boolean splittable();

  /** \brief Filtering, schema reconciliation, and partition options to use when
   *  scanning this fragment. May be nullptr, which indicates that no filtering
   *  or schema reconciliation will be performed and all partitions will be
   *  scanned. */
  public native @SharedPtr ScanOptions scan_options();

  /** \brief An expression which evaluates to true for all data viewed by this
   *  Fragment. May be null, which indicates no information is available. */
  public native @Const @SharedPtr @ByRef Expression partition_expression();
}
