// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_flight;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.arrow_flight.*;


/** \brief An authentication implementation for a Flight service.
 *  Authentication includes both an initial negotiation and a per-call
 *  token validation. Implementations may choose to use either or both
 *  mechanisms.
 *  An implementation may need to track some state, e.g. a mapping of
 *  client tokens to authenticated identities. */
@Namespace("arrow::flight") @Properties(inherit = org.bytedeco.arrow.presets.arrow_flight.class)
public class ServerAuthHandler extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ServerAuthHandler(Pointer p) { super(p); }

  /** \brief Authenticate the client on initial connection. The server
   *  can send and read responses from the client at any time. */
  public native @ByVal Status Authenticate(ServerAuthSender outgoing, ServerAuthReader incoming);
  /** \brief Validate a per-call client token.
   *  @param token [in] The client token. May be the empty string if
   *  the client does not provide a token.
   *  @param peer_identity [out] The identity of the peer, if this
   *  authentication method supports it.
   *  @return Status OK if the token is valid, any other status if
   *  validation failed */
  public native @ByVal Status IsValid(@StdString String token, @StdString @Cast({"char*", "std::string*"}) BytePointer peer_identity);
  public native @ByVal Status IsValid(@StdString BytePointer token, @StdString @Cast({"char*", "std::string*"}) BytePointer peer_identity);
}
