// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;
  // namespace schema

// The ColumnDescriptor encapsulates information necessary to interpret
// primitive column data in the context of a particular schema. We have to
// examine the node structure of a column's path to the root in the schema tree
// to be able to reassemble the nested structure from the repetition and
// definition levels.
@Namespace("parquet") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class ColumnDescriptor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ColumnDescriptor(Pointer p) { super(p); }

  public ColumnDescriptor(@SharedPtr @ByVal Node node, short max_definition_level,
                     short max_repetition_level,
                     @Const SchemaDescriptor schema_descr/*=nullptr*/) { super((Pointer)null); allocate(node, max_definition_level, max_repetition_level, schema_descr); }
  private native void allocate(@SharedPtr @ByVal Node node, short max_definition_level,
                     short max_repetition_level,
                     @Const SchemaDescriptor schema_descr/*=nullptr*/);
  public ColumnDescriptor(@SharedPtr @ByVal Node node, short max_definition_level,
                     short max_repetition_level) { super((Pointer)null); allocate(node, max_definition_level, max_repetition_level); }
  private native void allocate(@SharedPtr @ByVal Node node, short max_definition_level,
                     short max_repetition_level);

  public native @Cast("bool") boolean Equals(@Const @ByRef ColumnDescriptor other);

  public native short max_definition_level();

  public native short max_repetition_level();

  public native org.bytedeco.parquet.Type.type physical_type();

  public native ConvertedType.type converted_type();

  public native @Const @Cast("const parquet::LogicalType*") @SharedPtr @ByRef LogicalType logical_type();

  public native @ByVal ColumnOrder column_order();

  public native SortOrder.type sort_order();

  public native @StdString String name();

  public native @SharedPtr ColumnPath path();

  public native @Const @SharedPtr @ByRef Node schema_node();

  public native @StdString String ToString();

  public native int type_length();

  public native int type_precision();

  public native int type_scale();
}
