// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


@Namespace("parquet") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class FileMetaData extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileMetaData(Pointer p) { super(p); }

  // API convenience to get a MetaData accessor

  public static native @SharedPtr FileMetaData Make(
        @Const Pointer serialized_metadata, @Cast("uint32_t*") IntPointer inout_metadata_len,
        @SharedPtr InternalFileDecryptor file_decryptor/*=nullptr*/);
  public static native @SharedPtr FileMetaData Make(
        @Const Pointer serialized_metadata, @Cast("uint32_t*") IntPointer inout_metadata_len);
  public static native @SharedPtr FileMetaData Make(
        @Const Pointer serialized_metadata, @Cast("uint32_t*") IntBuffer inout_metadata_len,
        @SharedPtr InternalFileDecryptor file_decryptor/*=nullptr*/);
  public static native @SharedPtr FileMetaData Make(
        @Const Pointer serialized_metadata, @Cast("uint32_t*") IntBuffer inout_metadata_len);
  public static native @SharedPtr FileMetaData Make(
        @Const Pointer serialized_metadata, @Cast("uint32_t*") int[] inout_metadata_len,
        @SharedPtr InternalFileDecryptor file_decryptor/*=nullptr*/);
  public static native @SharedPtr FileMetaData Make(
        @Const Pointer serialized_metadata, @Cast("uint32_t*") int[] inout_metadata_len);

  /** Verify signature of FileMetadata when file is encrypted but footer is not encrypted
   *  (plaintext footer).
   *  Signature is 28 bytes (12 byte nonce and 16 byte tags) when encrypting FileMetadata */
  public native @Cast("bool") boolean VerifySignature(@Const Pointer signature);

  // file metadata
  public native @Cast("uint32_t") int size();

  public native int num_columns();

  public native @Cast("int64_t") long num_rows();

  public native int num_row_groups();
  public native ParquetVersion.type version();
  public native @StdString String created_by();
  public native int num_schema_elements();
  public native @UniquePtr RowGroupMetaData RowGroup(int i);
  public native @Const @ByRef ApplicationVersion writer_version();
  // Indicate if all of the FileMetadata's RowGroups can be decompressed.
  public native @Cast("bool") boolean can_decompress();

  public native @Cast("bool") boolean is_encryption_algorithm_set();
  public native @ByVal EncryptionAlgorithm encryption_algorithm();
  public native @StdString String footer_signing_key_metadata();

  public native void WriteTo(OutputStream dst);

  /** \brief Return Thrift-serialized representation of the metadata as a
   *  string */
  public native @StdString String SerializeToString();

  // Return const-pointer to make it clear that this object is not to be copied
  public native @Const SchemaDescriptor schema();

  public native @Const @SharedPtr KeyValueMetadata key_value_metadata();

  // Set file_path ColumnChunk fields to a particular value
  public native void set_file_path(@StdString String path);
  public native void set_file_path(@StdString BytePointer path);

  // Merge row-group metadata from "other" FileMetaData object
  public native void AppendRowGroups(@Const @ByRef FileMetaData other);
}
