// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


@Namespace("parquet") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class ParquetFileReader extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ParquetFileReader(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ParquetFileReader(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ParquetFileReader position(long position) {
        return (ParquetFileReader)super.position(position);
    }

  // Declare a virtual class 'Contents' to aid dependency injection and more
  // easily create test fixtures
  // An implementation of the Contents class is defined in the .cc file
  public static class Contents extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Contents(Pointer p) { super(p); }
  
    public static native @UniquePtr Contents Open(
            @SharedPtr RandomAccessFile source,
            @Const @ByRef(nullValue = "parquet::ReaderProperties(parquet::default_reader_properties())") ReaderProperties props,
            @SharedPtr FileMetaData metadata/*=nullptr*/);
    public static native @UniquePtr Contents Open(
            @SharedPtr RandomAccessFile source);
    // Perform any cleanup associated with the file contents
    public native void Close();
    public native @SharedPtr RowGroupReader GetRowGroup(int i);
    public native @SharedPtr FileMetaData metadata();
  }

  public ParquetFileReader() { super((Pointer)null); allocate(); }
  private native void allocate();

  // Create a reader from some implementation of parquet-cpp's generic file
  // input interface
  //
  // If you cannot provide exclusive access to your file resource, create a
  // subclass of RandomAccessSource that wraps the shared resource
  public static native @UniquePtr ParquetFileReader Open(
        @UniquePtr RandomAccessSource source,
        @Const @ByRef(nullValue = "parquet::ReaderProperties(parquet::default_reader_properties())") ReaderProperties props,
        @SharedPtr FileMetaData metadata/*=nullptr*/);
  public static native @UniquePtr ParquetFileReader Open(
        @UniquePtr RandomAccessSource source);

  // Create a file reader instance from an Arrow file object. Thread-safety is
  // the responsibility of the file implementation
  public static native @UniquePtr ParquetFileReader Open(
        @SharedPtr RandomAccessFile source,
        @Const @ByRef(nullValue = "parquet::ReaderProperties(parquet::default_reader_properties())") ReaderProperties props,
        @SharedPtr FileMetaData metadata/*=nullptr*/);
  public static native @UniquePtr ParquetFileReader Open(
        @SharedPtr RandomAccessFile source);

  // API Convenience to open a serialized Parquet file on disk, using Arrow IO
  // interfaces.
  public static native @UniquePtr ParquetFileReader OpenFile(
        @StdString String path, @Cast("bool") boolean memory_map/*=true*/,
        @Const @ByRef(nullValue = "parquet::ReaderProperties(parquet::default_reader_properties())") ReaderProperties props,
        @SharedPtr FileMetaData metadata/*=nullptr*/);
  public static native @UniquePtr ParquetFileReader OpenFile(
        @StdString String path);
  public static native @UniquePtr ParquetFileReader OpenFile(
        @StdString BytePointer path, @Cast("bool") boolean memory_map/*=true*/,
        @Const @ByRef(nullValue = "parquet::ReaderProperties(parquet::default_reader_properties())") ReaderProperties props,
        @SharedPtr FileMetaData metadata/*=nullptr*/);
  public static native @UniquePtr ParquetFileReader OpenFile(
        @StdString BytePointer path);

  public native void Open(@UniquePtr Contents contents);
  public native void Close();

  // The RowGroupReader is owned by the FileReader
  public native @SharedPtr RowGroupReader RowGroup(int i);

  // Returns the file metadata. Only one instance is ever created
  public native @SharedPtr FileMetaData metadata();
}
