// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


@Namespace("arrow::io") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class CacheOptions extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CacheOptions() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CacheOptions(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CacheOptions(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CacheOptions position(long position) {
        return (CacheOptions)super.position(position);
    }
    @Override public CacheOptions getPointer(long i) {
        return new CacheOptions(this).position(position + i);
    }

  @MemberGetter public static native double kDefaultIdealBandwidthUtilizationFrac();
  public static final double kDefaultIdealBandwidthUtilizationFrac = kDefaultIdealBandwidthUtilizationFrac();
  @MemberGetter public static native @Cast("const int64_t") long kDefaultMaxIdealRequestSizeMib();
  public static final long kDefaultMaxIdealRequestSizeMib = kDefaultMaxIdealRequestSizeMib();

  /** /brief The maximum distance in bytes between two consecutive
   *    ranges; beyond this value, ranges are not combined */
  public native @Cast("int64_t") long hole_size_limit(); public native CacheOptions hole_size_limit(long setter);
  /** /brief The maximum size in bytes of a combined range; if
   *    combining two consecutive ranges would produce a range of a
   *    size greater than this, they are not combined */
  public native @Cast("int64_t") long range_size_limit(); public native CacheOptions range_size_limit(long setter);

  
  ///
  public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef CacheOptions other);

  /** \brief Construct CacheOptions from network storage metrics (e.g. S3).
   * 
   *  @param time_to_first_byte_millis [in] Seek-time or Time-To-First-Byte (TTFB) in
   *    milliseconds, also called call setup latency of a new S3 request.
   *    The value is a positive integer.
   *  @param transfer_bandwidth_mib_per_sec [in] Data transfer Bandwidth (BW) in MiB/sec.
   *    The value is a positive integer.
   *  @param ideal_bandwidth_utilization_frac [in] Transfer bandwidth utilization fraction
   *    (per connection) to maximize the net data load.
   *    The value is a positive double precision number less than 1.
   *  @param max_ideal_request_size_mib [in] The maximum single data request size (in MiB)
   *    to maximize the net data load.
   *    The value is a positive integer.
   *  @return A new instance of CacheOptions. */
  public static native @ByVal CacheOptions MakeFromNetworkMetrics(
        @Cast("int64_t") long time_to_first_byte_millis, @Cast("int64_t") long transfer_bandwidth_mib_per_sec,
        double ideal_bandwidth_utilization_frac/*=arrow::io::CacheOptions::kDefaultIdealBandwidthUtilizationFrac*/,
        @Cast("int64_t") long max_ideal_request_size_mib/*=arrow::io::CacheOptions::kDefaultMaxIdealRequestSizeMib*/);
  public static native @ByVal CacheOptions MakeFromNetworkMetrics(
        @Cast("int64_t") long time_to_first_byte_millis, @Cast("int64_t") long transfer_bandwidth_mib_per_sec);

  public static native @ByVal CacheOptions Defaults();
}
