// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Memoization data structure for assigning id numbers to
 *  dictionaries and tracking their current state through possible
 *  deltas in an IPC stream */
@Namespace("arrow::ipc") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class DictionaryMemo extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DictionaryMemo(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DictionaryMemo(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DictionaryMemo position(long position) {
        return (DictionaryMemo)super.position(position);
    }
    @Override public DictionaryMemo getPointer(long i) {
        return new DictionaryMemo(this).position(position + i);
    }


  public DictionaryMemo() { super((Pointer)null); allocate(); }
  private native void allocate();
  
  

  /** \brief Return current dictionary corresponding to a particular
   *  id. Returns KeyError if id not found */
  public native @ByVal Status GetDictionary(@Cast("int64_t") long id, @SharedPtr Array dictionary);

  /** \brief Return dictionary value type corresponding to a
   *  particular dictionary id. This permits multiple fields to
   *  reference the same dictionary in IPC and JSON */
  public native @ByVal Status GetDictionaryType(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>*"}) DataType type);

  /** \brief Return id for dictionary, computing new id if necessary */
  public native @ByVal Status GetOrAssignId(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field, @Cast("int64_t*") LongPointer out);
  public native @ByVal Status GetOrAssignId(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field, @Cast("int64_t*") LongBuffer out);
  public native @ByVal Status GetOrAssignId(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field, @Cast("int64_t*") long[] out);

  /** \brief Return id for dictionary if it exists, otherwise return
   *  KeyError */
  public native @ByVal Status GetId(@Const Field type, @Cast("int64_t*") LongPointer id);
  public native @ByVal Status GetId(@Const Field type, @Cast("int64_t*") LongBuffer id);
  public native @ByVal Status GetId(@Const Field type, @Cast("int64_t*") long[] id);

  /** \brief Return true if dictionary for type is in this memo */
  public native @Cast("bool") boolean HasDictionary(@Const @ByRef Field type);

  /** \brief Return true if we have a dictionary for the input id */
  public native @Cast("bool") boolean HasDictionary(@Cast("int64_t") long id);

  /** \brief Add field to the memo, return KeyError if already present */
  public native @ByVal Status AddField(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field);

  /** \brief Add a dictionary to the memo with a particular id. Returns
   *  KeyError if that dictionary already exists */
  public native @ByVal Status AddDictionary(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary);

  /** \brief Append a dictionary delta to the memo with a particular id. Returns
   *  KeyError if that dictionary does not exists */
  public native @ByVal Status AddDictionaryDelta(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                              MemoryPool pool);

  /** \brief Add a dictionary to the memo if it does not have one with the id,
   *  otherwise, replace the dictionary with the new one. */
  public native @ByVal Status AddOrReplaceDictionary(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary);

  /** \brief The stored dictionaries, in ascending id order. */
  public native @ByVal DictionaryVector dictionaries();

  /** \brief The number of fields tracked in the memo */
  public native int num_fields();
  public native int num_dictionaries();
}
