// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Base type for kernels. Contains the function signature and
 *  optionally the state initialization function, along with some common
 *  attributes */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Kernel extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Kernel(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Kernel(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public Kernel position(long position) {
        return (Kernel)super.position(position);
    }
    @Override public Kernel getPointer(long i) {
        return new Kernel(this).position(position + i);
    }

  public Kernel() { super((Pointer)null); allocate(); }
  private native void allocate();

  public Kernel(@SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature sig, @ByVal @Cast("arrow::compute::KernelInit*") Pointer init) { super((Pointer)null); allocate(sig, init); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature sig, @ByVal @Cast("arrow::compute::KernelInit*") Pointer init);

  public Kernel(@StdVector InputType in_types, @ByVal OutputType out_type, @ByVal @Cast("arrow::compute::KernelInit*") Pointer init) { super((Pointer)null); allocate(in_types, out_type, init); }
  private native void allocate(@StdVector InputType in_types, @ByVal OutputType out_type, @ByVal @Cast("arrow::compute::KernelInit*") Pointer init);

  /** \brief The "signature" of the kernel containing the InputType input
   *  argument validators and OutputType output type and shape resolver. */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature signature(); public native Kernel signature(KernelSignature setter);

  /** \brief Create a new KernelState for invocations of this kernel, e.g. to
   *  set up any options or state relevant for execution. */
  public native @ByRef @Cast("arrow::compute::KernelInit*") Pointer init(); public native Kernel init(Pointer setter);

  /** \brief Indicates whether execution can benefit from parallelization
   *  (splitting large chunks into smaller chunks and using multiple
   *  threads). Some kernels may not support parallel execution at
   *  all. Synchronization and concurrency-related issues are currently the
   *  responsibility of the Kernel's implementation. */
  public native @Cast("bool") boolean parallelizable(); public native Kernel parallelizable(boolean setter);

  /** \brief Indicates the level of SIMD instruction support in the host CPU is
   *  required to use the function. Currently this is not used, but the
   *  intention is for functions to be able to contain multiple kernels with
   *  the same signature but different levels of SIMD, so that the most
   *  optimized kernel supported on a host's processor can be chosen. */
  public native SimdLevel.type simd_level(); public native Kernel simd_level(SimdLevel.type setter);
}
