// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Context/state for the execution of a particular kernel. */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class KernelContext extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public KernelContext(Pointer p) { super(p); }

  public KernelContext(ExecContext exec_ctx) { super((Pointer)null); allocate(exec_ctx); }
  private native void allocate(ExecContext exec_ctx);

  /** \brief Allocate buffer from the context's memory pool. The contents are
   *  not initialized. */
  public native @ByVal ResizableResult Allocate(@Cast("int64_t") long nbytes);

  /** \brief Allocate buffer for bitmap from the context's memory pool. Like
   *  Allocate, the contents of the buffer are not initialized but the last
   *  byte is preemptively zeroed to help avoid ASAN or valgrind issues. */
  

  /** \brief Indicate that an error has occurred, to be checked by a exec caller
   *  @param status [in] a Status instance.
   * 
   *  \note Will not overwrite a prior set Status, so we will have the first
   *  error that occurred until ExecContext::ResetStatus is called. */
  public native void SetStatus(@Const @ByRef Status status);

  /** \brief Clear any error status. */
  public native void ResetStatus();

  /** \brief Return true if an error has occurred. */
  public native @Cast("bool") boolean HasError();

  /** \brief Return the current status of the context. */
  public native @Const @ByRef Status status();

  /** \brief Assign the active KernelState to be utilized for each stage of
   *  kernel execution. Ownership and memory lifetime of the KernelState must
   *  be minded separately. */
  public native void SetState(KernelState state);

  public native KernelState state();

  /** \brief Configuration related to function execution that is to be shared
   *  across multiple kernels. */
  public native ExecContext exec_context();

  /** \brief The memory pool to use for allocations. For now, it uses the
   *  MemoryPool contained in the ExecContext used to create the KernelContext. */
  public native MemoryPool memory_pool();
}
