// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class RecordBatchBuilder
 *  \brief Helper class for creating record batches iteratively given a known
 *  schema */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class RecordBatchBuilder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RecordBatchBuilder(Pointer p) { super(p); }

  /** \brief Create an initialize a RecordBatchBuilder
   *  @param schema [in] The schema for the record batch
   *  @param pool [in] A MemoryPool to use for allocations
   *  @param builder [in] the created builder instance */
  public static native @ByVal Status Make(@Const @SharedPtr @ByRef Schema schema, MemoryPool pool,
                       @UniquePtr RecordBatchBuilder builder);

  /** \brief Create an initialize a RecordBatchBuilder
   *  @param schema [in] The schema for the record batch
   *  @param pool [in] A MemoryPool to use for allocations
   *  @param initial_capacity [in] The initial capacity for the builders
   *  @param builder [in] the created builder instance */
  public static native @ByVal Status Make(@Const @SharedPtr @ByRef Schema schema, MemoryPool pool,
                       @Cast("int64_t") long initial_capacity,
                       @UniquePtr RecordBatchBuilder builder);

  /** \brief Get base pointer to field builder
   *  @param i the field index
   *  @return pointer to ArrayBuilder */
  public native ArrayBuilder GetField(int i);

  /** \brief Return field builder casted to indicated specific builder type
   *  @param i the field index
   *  @return pointer to template type */

  /** \brief Finish current batch and optionally reset
   *  @param reset_builders [in] the resulting RecordBatch
   *  @param batch [out] the resulting RecordBatch
   *  @return Status */
  public native @ByVal Status Flush(@Cast("bool") boolean reset_builders, @SharedPtr RecordBatch batch);

  /** \brief Finish current batch and reset
   *  @param batch [out] the resulting RecordBatch
   *  @return Status */
  public native @ByVal Status Flush(@SharedPtr RecordBatch batch);

  /** \brief Set the initial capacity for new builders */
  public native void SetInitialCapacity(@Cast("int64_t") long _capacity);

  /** \brief The initial capacity for builders */
  public native @Cast("int64_t") long initial_capacity();

  /** \brief The number of fields in the schema */
  public native int num_fields();

  /** \brief The number of fields in the schema */
  public native @SharedPtr @ByVal Schema schema();
}
