// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


// TODO: Consider standardizing on uint16 selection vectors and only use them
// when we can ensure that each value is 64K length or smaller

/** \brief Container for an array of value selection indices that were
 *  materialized from a filter.
 * 
 *  Columnar query engines (see e.g. [1]) have found that rather than
 *  materializing filtered data, the filter can instead be converted to an
 *  array of the "on" indices and then "fusing" these indices in operator
 *  implementations. This is especially relevant for aggregations but also
 *  applies to scalar operations.
 * 
 *  We are not yet using this so this is mostly a placeholder for now.
 * 
 *  [1]: http://cidrdb.org/cidr2005/papers/P19.pdf */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class SelectionVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SelectionVector(Pointer p) { super(p); }

  public SelectionVector(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data) { super((Pointer)null); allocate(data); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data);

  public SelectionVector(@Const @ByRef Array arr) { super((Pointer)null); allocate(arr); }
  private native void allocate(@Const @ByRef Array arr);

  /** \brief Create SelectionVector from boolean mask */
  public static native @ByVal SelectionVectorResult FromMask(@Const @ByRef BooleanArray arr);

  public native @Const IntPointer indices();
  public native int length();
}
