// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow.global;

import org.bytedeco.arrow.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class arrow extends org.bytedeco.arrow.presets.arrow {
    static { Loader.load(); }

// Targeting ..\Byte16Array.java


// Targeting ..\BoolVector.java


// Targeting ..\StringVector.java


// Targeting ..\StringStringPairVector.java


// Targeting ..\DataTypeVector.java


// Targeting ..\ScalarVector.java


// Targeting ..\FieldVector.java


// Targeting ..\ArrayVector.java


// Targeting ..\ArrayDataVector.java


// Targeting ..\BufferVector.java


// Targeting ..\ArrayBuilderVector.java


// Targeting ..\RecordBatchVector.java


// Targeting ..\ChunkedArrayVector.java


// Targeting ..\SchemaVector.java


// Targeting ..\TableVector.java


// Targeting ..\ArrayVectorVector.java


// Targeting ..\DictionaryVector.java


// Targeting ..\DatumVector.java


// Targeting ..\FutureImplVector.java


// Targeting ..\ValueDescrVector.java


// Targeting ..\Decimal128Pair.java


// Targeting ..\StringStringMap.java


// Targeting ..\StringDataTypeMap.java


// Parsed from arrow/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Coarse public API while the library is in development

// #pragma once

// #include "arrow/array.h"                    // IYWU pragma: export
// #include "arrow/array/concatenate.h"        // IYWU pragma: export
// #include "arrow/buffer.h"                   // IYWU pragma: export
// #include "arrow/builder.h"                  // IYWU pragma: export
// #include "arrow/chunked_array.h"            // IYWU pragma: export
// #include "arrow/compare.h"                  // IYWU pragma: export
// #include "arrow/config.h"                   // IYWU pragma: export
// #include "arrow/datum.h"                    // IYWU pragma: export
// #include "arrow/extension_type.h"           // IYWU pragma: export
// #include "arrow/memory_pool.h"              // IYWU pragma: export
// #include "arrow/pretty_print.h"             // IYWU pragma: export
// #include "arrow/record_batch.h"             // IYWU pragma: export
// #include "arrow/result.h"                   // IYWU pragma: export
// #include "arrow/status.h"                   // IYWU pragma: export
// #include "arrow/table.h"                    // IYWU pragma: export
// #include "arrow/table_builder.h"            // IYWU pragma: export
// #include "arrow/tensor.h"                   // IYWU pragma: export
// #include "arrow/type.h"                     // IYWU pragma: export
// #include "arrow/util/key_value_metadata.h"  // IWYU pragma: export
// #include "arrow/visitor.h"                  // IYWU pragma: export

/** \brief Top-level namespace for Apache Arrow C++ API */



// Parsed from arrow/util/config.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

public static final int ARROW_VERSION_MAJOR = 1;
public static final int ARROW_VERSION_MINOR = 0;
public static final int ARROW_VERSION_PATCH = 1;
public static final int ARROW_VERSION = ((ARROW_VERSION_MAJOR * 1000) + ARROW_VERSION_MINOR) * 1000 + ARROW_VERSION_PATCH;

public static final String ARROW_VERSION_STRING = "1.0.1";

public static final String ARROW_SO_VERSION = "100";
public static final String ARROW_FULL_SO_VERSION = "100.1.0";

public static final String ARROW_CXX_COMPILER_ID = "MSVC";
public static final String ARROW_CXX_COMPILER_VERSION = "19.16.27035.0";
public static final String ARROW_CXX_COMPILER_FLAGS = "/DWIN32 /D_WINDOWS  /GR /EHsc /D_SILENCE_TR1_NAMESPACE_DEPRECATION_WARNING ";

public static final String ARROW_GIT_ID = "3204524f2c4eb8ecb5003aab8ea7ecf7ce6169a2";
public static final String ARROW_GIT_DESCRIPTION = "1.5.3-71-g3204524f2c";

public static final String ARROW_PACKAGE_KIND = "";

// #define GRPCPP_PP_INCLUDE


// Parsed from arrow/util/checked_cast.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <type_traits>
// #include <utility>

  // namespace internal
  // namespace arrow


// Parsed from arrow/util/macros.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>

// #define ARROW_EXPAND(x) x
// #define ARROW_STRINGIFY(x) #x
// #define ARROW_CONCAT(x, y) x##y

// From Google gutil
// #ifndef ARROW_DISALLOW_COPY_AND_ASSIGN
// #define ARROW_DISALLOW_COPY_AND_ASSIGN(TypeName)
//   TypeName(const TypeName&) = delete;
//   void operator=(const TypeName&) = delete
// #endif

// #ifndef ARROW_DEFAULT_MOVE_AND_ASSIGN
// #define ARROW_DEFAULT_MOVE_AND_ASSIGN(TypeName)
//   TypeName(TypeName&&) = default;
//   TypeName& operator=(TypeName&&) = default
// #endif

// #define ARROW_UNUSED(x) (void)(x)
// #define ARROW_ARG_UNUSED(x)
//
// GCC can be told that a certain branch is not likely to be taken (for
// instance, a CHECK failure), and use that information in static analysis.
// Giving it this information can help it optimize for the common case in
// the absence of better information (ie. -fprofile-arcs).
//
// #if defined(__GNUC__)
// #define ARROW_PREDICT_FALSE(x) (__builtin_expect(!!(x), 0))
// #define ARROW_PREDICT_TRUE(x) (__builtin_expect(!!(x), 1))
// #define ARROW_NORETURN __attribute__((noreturn))
// #define ARROW_NOINLINE __attribute__((noinline))
// #define ARROW_PREFETCH(addr) __builtin_prefetch(addr)
// #elif defined(_MSC_VER)
// #define ARROW_NORETURN __declspec(noreturn)
// #define ARROW_NOINLINE __declspec(noinline)
// #define ARROW_PREDICT_FALSE(x) (x)
// #define ARROW_PREDICT_TRUE(x) (x)
// #define ARROW_PREFETCH(addr)
// #else
// #define ARROW_NORETURN
// #define ARROW_PREDICT_FALSE(x) (x)
// #define ARROW_PREDICT_TRUE(x) (x)
// #define ARROW_PREFETCH(addr)
// #endif

// #if (defined(__GNUC__) || defined(__APPLE__))
// #define ARROW_MUST_USE_RESULT __attribute__((warn_unused_result))
// #elif defined(_MSC_VER)
// #define ARROW_MUST_USE_RESULT
// #else
// #define ARROW_MUST_USE_RESULT
// #endif

// #if defined(__clang__)
// Only clang supports warn_unused_result as a type annotation.
// #define ARROW_MUST_USE_TYPE ARROW_MUST_USE_RESULT
// #else
// #define ARROW_MUST_USE_TYPE
// #endif

// ----------------------------------------------------------------------
// C++/CLI support macros (see ARROW-1134)

// #ifndef NULLPTR

// #ifdef __cplusplus_cli
// #else
// #define NULLPTR nullptr
// #endif

// #endif  // ifndef NULLPTR

// ----------------------------------------------------------------------

// clang-format off
// [[deprecated]] is only available in C++14, use this for the time being
// This macro takes an optional deprecation message
// #ifdef __COVERITY__
// #  define ARROW_DEPRECATED(...)
// #  define ARROW_DEPRECATED_USING(...)
// #elif __cplusplus > 201103L
// #  define ARROW_DEPRECATED(...) [[deprecated(__VA_ARGS__)]]
// #  define ARROW_DEPRECATED_USING(...) ARROW_DEPRECATED(__VA_ARGS__)
// #else
// # ifdef __GNUC__
// #  define ARROW_DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
// #  define ARROW_DEPRECATED_USING(...) ARROW_DEPRECATED(__VA_ARGS__)
// # elif defined(_MSC_VER)
// #  define ARROW_DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
// #  define ARROW_DEPRECATED_USING(...)
// # else
// #  define ARROW_DEPRECATED(...)
// #  define ARROW_DEPRECATED_USING(...)
// # endif
// #endif
// clang-format on

// ----------------------------------------------------------------------

// macros to disable padding
// these macros are portable across different compilers and platforms
//[https://github.com/google/flatbuffers/blob/master/include/flatbuffers/flatbuffers.h#L1355]
// #if !defined(MANUALLY_ALIGNED_STRUCT)
// #if defined(_MSC_VER)
// #define MANUALLY_ALIGNED_STRUCT(alignment)
//   __pragma(pack(1));
//   struct __declspec(align(alignment))
// #define STRUCT_END(name, size)
//   __pragma(pack());
//   static_assert(sizeof(name) == size, "compiler breaks packing rules")
// #elif defined(__GNUC__) || defined(__clang__)
// #define MANUALLY_ALIGNED_STRUCT(alignment)
//   _Pragma("pack(1)") struct __attribute__((aligned(alignment)))
// #define STRUCT_END(name, size)
//   _Pragma("pack()") static_assert(sizeof(name) == size, "compiler breaks packing rules")
// #else
// #error Unknown compiler, please define structure alignment macros
// #endif
// #endif  // !defined(MANUALLY_ALIGNED_STRUCT)

// ----------------------------------------------------------------------
// Convenience macro disabling a particular UBSan check in a function

// #if defined(__clang__)
// #define ARROW_DISABLE_UBSAN(feature) __attribute__((no_sanitize(feature)))
// #else
// #define ARROW_DISABLE_UBSAN(feature)
// #endif

// ----------------------------------------------------------------------
// Machine information

// #if INTPTR_MAX == INT64_MAX
public static native @MemberGetter int ARROW_BITNESS();
public static final int ARROW_BITNESS = ARROW_BITNESS();
// #elif INTPTR_MAX == INT32_MAX
// #else
// #error Unexpected INTPTR_MAX
// #endif

// ----------------------------------------------------------------------
// From googletest
// (also in parquet-cpp)

// When you need to test the private or protected members of a class,
// use the FRIEND_TEST macro to declare your tests as friends of the
// class.  For example:
//
// class MyClass {
//  private:
//   void MyMethod();
//   FRIEND_TEST(MyClassTest, MyMethod);
// };
//
// class MyClassTest : public testing::Test {
//   // ...
// };
//
// TEST_F(MyClassTest, MyMethod) {
//   // Can call MyClass::MyMethod() here.
// }

// #define FRIEND_TEST(test_case_name, test_name)
//   friend class test_case_name##_##test_name##_Test


// Parsed from arrow/util/compare.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <type_traits>
// #include <utility>

// #include "arrow/util/macros.h"

/** CRTP helper for declaring equality comparison. Defines operator== and operator!= */

  // namespace util
  // namespace arrow


// Parsed from arrow/util/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

  // namespace internal
  // namespace arrow


// Parsed from arrow/util/type_traits.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <type_traits>

/** \brief Metafunction to allow checking if a type matches any of another set of types */  /** Base case: nothing has matched */

/** \brief Shorthand for using IsOneOf + std::enable_if */

/** \brief is_null_pointer from C++17 */

  // namespace internal
  // namespace arrow


// Parsed from arrow/util/visibility.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #if defined(_WIN32) || defined(__CYGWIN__)
// #if defined(_MSC_VER)
// #pragma warning(disable : 4251)
// #else
// #pragma GCC diagnostic ignored "-Wattributes"
// #endif

// #ifdef ARROW_STATIC
// #define ARROW_EXPORT
// #elif defined(ARROW_EXPORTING)
// #define ARROW_EXPORT __declspec(dllexport)
// #else
// #define ARROW_EXPORT __declspec(dllimport)
// #endif

// #define ARROW_NO_EXPORT
// #define ARROW_FORCE_INLINE __forceinline
// #else  // Not Windows
// #ifndef ARROW_EXPORT
// #define ARROW_EXPORT __attribute__((visibility("default")))
// #endif
// #ifndef ARROW_NO_EXPORT
// #define ARROW_NO_EXPORT __attribute__((visibility("hidden")))
// #define ARROW_FORCE_INLINE
// #endif
// #endif  // Non-Windows


// Parsed from arrow/util/compression.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <limits>
// #include <memory>
// #include <string>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"
// Targeting ..\Compression.java




///
@Namespace("arrow::util") @MemberGetter public static native int kUseDefaultCompressionLevel();
// Targeting ..\Compressor.java


// Targeting ..\Decompressor.java


// Targeting ..\Codec.java



  // namespace util
  // namespace arrow


// Parsed from arrow/util/functional.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <tuple>
// #include <type_traits>

// #include "arrow/util/macros.h"
// Targeting ..\call_traits.java



  // namespace internal
  // namespace arrow


// Parsed from arrow/util/iterator.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cassert>
// #include <functional>
// #include <memory>
// #include <tuple>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/functional.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/optional.h"
// #include "arrow/util/visibility.h"
// Targeting ..\BufferIterator.java


// Targeting ..\RecordBatchIterator.java



/** \brief Construct an Iterator which invokes a callable on Next() */

/** \brief Simple iterator which yields the elements of a std::vector */

/** \brief Simple iterator which yields *pointers* to the elements of a std::vector<T>.
 *  This is provided to support T where IterationTraits<T>::End is not specialized */

/** \brief MapIterator takes ownership of an iterator and a function to apply
 *  on every element. The mapped function is not allowed to fail. */

/** \brief MapIterator takes ownership of an iterator and a function to apply
 *  on every element. The mapped function is not allowed to fail. */
// Targeting ..\FilterIterator.java



/** \brief Like MapIterator, but where the function can fail or reject elements. */

/** \brief FlattenIterator takes an iterator generating iterators and yields a
 *  unified iterator that flattens/concatenates in a single stream. */
// Targeting ..\ReadaheadPromise.java


// Targeting ..\ReadaheadQueue.java



  // namespace detail

/** \brief Readahead iterator that iterates on the underlying iterator in a
 *  separate thread, getting up to N values in advance. */

  // namespace arrow


// Parsed from arrow/util/memory.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/util/macros.h"

// A helper function for doing memcpy with multiple threads. This is required
// to saturate the memory bandwidth of modern cpus.


// A helper function for checking if two wrapped objects implementing `Equals`
// are equal.

  // namespace internal
  // namespace arrow


// Parsed from arrow/util/variant.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/vendored/variant.hpp"  // IWYU pragma: export

  // namespace util
  // namespace arrow


// Parsed from arrow/util/bit_util.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #ifdef _WIN32
public static native @MemberGetter int ARROW_LITTLE_ENDIAN();
public static final int ARROW_LITTLE_ENDIAN = ARROW_LITTLE_ENDIAN();
// #else
// #if defined(__APPLE__) || defined(__FreeBSD__)
// #include <machine/endian.h>  // IWYU pragma: keep
// #else
// #include <endian.h>  // IWYU pragma: keep
// #endif
// #
// #ifndef __BYTE_ORDER__
// #error "__BYTE_ORDER__ not defined"
// #endif
// #
// #ifndef __ORDER_LITTLE_ENDIAN__
// #error "__ORDER_LITTLE_ENDIAN__ not defined"
// #endif
// #
// #if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
// #else
// #endif
// #endif

// #if defined(_MSC_VER)
// #include <intrin.h>  // IWYU pragma: keep
// #include <nmmintrin.h>
// #pragma intrinsic(_BitScanReverse)
// #pragma intrinsic(_BitScanForward)
// #define ARROW_BYTE_SWAP64 _byteswap_uint64
// #define ARROW_BYTE_SWAP32 _byteswap_ulong
// #define ARROW_POPCOUNT64 __popcnt64
// #define ARROW_POPCOUNT32 __popcnt
// #else
// #define ARROW_BYTE_SWAP64 __builtin_bswap64
// #define ARROW_BYTE_SWAP32 __builtin_bswap32
// #define ARROW_POPCOUNT64 __builtin_popcountll
// #define ARROW_POPCOUNT32 __builtin_popcount
// #endif

// #include <cstdint>
// #include <type_traits>

// #include "arrow/util/macros.h"
// #include "arrow/util/type_traits.h"
// #include "arrow/util/visibility.h"

  // namespace detail

// The number of set bits in a given unsigned byte value, pre-computed
//
// Generated with the following Python code
// output = 'static constexpr uint8_t kBytePopcount[] = {{{0}}};'
// popcounts = [str(bin(i).count('1')) for i in range(0, 256)]
// print(output.format(', '.join(popcounts)))
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kBytePopcount(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kBytePopcount();

@Namespace("arrow::BitUtil") public static native @Cast("uint64_t") long PopCount(@Cast("uint64_t") long bitmap);
@Namespace("arrow::BitUtil") public static native @Cast("uint32_t") int PopCount(@Cast("uint32_t") int bitmap);

//
// Bit-related computations on integer values
//

// Returns the ceil of value/divisor
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long CeilDiv(@Cast("int64_t") long value, @Cast("int64_t") long divisor);

// Return the number of bytes needed to fit the given number of bits
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long BytesForBits(@Cast("int64_t") long bits);

@Namespace("arrow::BitUtil") public static native @Cast("const bool") boolean IsPowerOf2(@Cast("int64_t") long value);

// Returns the smallest power of two that contains v.  If v is already a
// power of two, it is returned as is.
@Namespace("arrow::BitUtil") public static native @Cast("int64_t") long NextPower2(@Cast("int64_t") long n);

@Namespace("arrow::BitUtil") public static native @Cast("const bool") boolean IsMultipleOf64(@Cast("int64_t") long n);

@Namespace("arrow::BitUtil") public static native @Cast("const bool") boolean IsMultipleOf8(@Cast("int64_t") long n);

// Returns a mask for the bit_index lower order bits.
// Only valid for bit_index in the range [0, 64).
@Namespace("arrow::BitUtil") public static native @Cast("const uint64_t") long LeastSignficantBitMask(@Cast("int64_t") long bit_index);

// Returns 'value' rounded up to the nearest multiple of 'factor'
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUp(@Cast("int64_t") long value, @Cast("int64_t") long factor);

// Returns 'value' rounded down to the nearest multiple of 'factor'
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundDown(@Cast("int64_t") long value, @Cast("int64_t") long factor);

// Returns 'value' rounded up to the nearest multiple of 'factor' when factor
// is a power of two.
// The result is undefined on overflow, i.e. if `value > 2**64 - factor`,
// since we cannot return the correct result which would be 2**64.
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUpToPowerOf2(@Cast("int64_t") long value, @Cast("int64_t") long factor);

@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUpToMultipleOf8(@Cast("int64_t") long num);

@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long RoundUpToMultipleOf64(@Cast("int64_t") long num);

// Returns the number of bytes covering a sliced bitmap. Find the length
// rounded to cover full bytes on both extremities.
//
// The following example represents a slice (offset=10, length=9)
//
// 0       8       16     24
// |-------|-------|------|
//           [       ]          (slice)
//         [             ]      (same slice aligned to bytes bounds, length=16)
//
// The covering bytes is the length (in bytes) of this new aligned slice.
@Namespace("arrow::BitUtil") public static native @Cast("const int64_t") long CoveringBytes(@Cast("int64_t") long offset, @Cast("int64_t") long length);

// Returns the 'num_bits' least-significant bits of 'v'.
@Namespace("arrow::BitUtil") public static native @Cast("uint64_t") long TrailingBits(@Cast("uint64_t") long v, int num_bits);

/** \brief Count the number of leading zeros in an unsigned integer. */
@Namespace("arrow::BitUtil") public static native int CountLeadingZeros(@Cast("uint32_t") int value);

@Namespace("arrow::BitUtil") public static native int CountLeadingZeros(@Cast("uint64_t") long value);

@Namespace("arrow::BitUtil") public static native int CountTrailingZeros(@Cast("uint32_t") int value);

@Namespace("arrow::BitUtil") public static native int CountTrailingZeros(@Cast("uint64_t") long value);

// Returns the minimum number of bits needed to represent an unsigned value
@Namespace("arrow::BitUtil") public static native int NumRequiredBits(@Cast("uint64_t") long x);

// Returns ceil(log2(x)).
@Namespace("arrow::BitUtil") public static native int Log2(@Cast("uint64_t") long x);

//
// Byte-swap 16-bit, 32-bit and 64-bit values
//

// Swap the byte order (i.e. endianness)
@Namespace("arrow::BitUtil") public static native @Cast("int64_t") long ByteSwap(@Cast("int64_t") long value);
@Namespace("arrow::BitUtil") public static native int ByteSwap(int value);
@Namespace("arrow::BitUtil") public static native short ByteSwap(short value);
@Namespace("arrow::BitUtil") public static native @Cast("uint8_t") byte ByteSwap(@Cast("uint8_t") byte value);

// Write the swapped bytes into dst. Src and dst cannot overlap.
@Namespace("arrow::BitUtil") public static native void ByteSwap(Pointer dst, @Const Pointer src, int len);

// Convert to little/big endian format from the machine's native endian format.
// #if ARROW_LITTLE_ENDIAN
// #else
// #endif

// Convert from big/little endian format to the machine's native endian format.
// #if ARROW_LITTLE_ENDIAN
// #else
// #endif

//
// Utilities for reading and writing individual bits by their index
// in a memory area.
//

// Bitmask selecting the k-th bit in a byte
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kBitmask();

// the bitwise complement version of kBitmask
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kFlippedBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kFlippedBitmask();

// Bitmask selecting the (k - 1) preceding bits in a byte
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kPrecedingBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kPrecedingBitmask();
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kPrecedingWrappingBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kPrecedingWrappingBitmask();

// the bitwise complement version of kPrecedingBitmask
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t") byte kTrailingBitmask(int i);
@Namespace("arrow::BitUtil") @MemberGetter public static native @Cast("const uint8_t*") BytePointer kTrailingBitmask();

@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBit(@Cast("const uint8_t*") BytePointer bits, @Cast("uint64_t") long i);
@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBit(@Cast("const uint8_t*") ByteBuffer bits, @Cast("uint64_t") long i);
@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBit(@Cast("const uint8_t*") byte[] bits, @Cast("uint64_t") long i);

// Gets the i-th bit from a byte. Should only be used with i <= 7.
@Namespace("arrow::BitUtil") public static native @Cast("bool") boolean GetBitFromByte(@Cast("uint8_t") byte _byte, @Cast("uint8_t") byte i);

@Namespace("arrow::BitUtil") public static native void ClearBit(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void ClearBit(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void ClearBit(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long i);

@Namespace("arrow::BitUtil") public static native void SetBit(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void SetBit(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long i);
@Namespace("arrow::BitUtil") public static native void SetBit(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long i);

@Namespace("arrow::BitUtil") public static native void SetBitTo(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long i, @Cast("bool") boolean bit_is_set);
@Namespace("arrow::BitUtil") public static native void SetBitTo(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long i, @Cast("bool") boolean bit_is_set);
@Namespace("arrow::BitUtil") public static native void SetBitTo(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long i, @Cast("bool") boolean bit_is_set);

/** \brief set or clear a range of bits quickly */
@Namespace("arrow::BitUtil") public static native void SetBitsTo(@Cast("uint8_t*") BytePointer bits, @Cast("int64_t") long start_offset, @Cast("int64_t") long length, @Cast("bool") boolean bits_are_set);
@Namespace("arrow::BitUtil") public static native void SetBitsTo(@Cast("uint8_t*") ByteBuffer bits, @Cast("int64_t") long start_offset, @Cast("int64_t") long length, @Cast("bool") boolean bits_are_set);
@Namespace("arrow::BitUtil") public static native void SetBitsTo(@Cast("uint8_t*") byte[] bits, @Cast("int64_t") long start_offset, @Cast("int64_t") long length, @Cast("bool") boolean bits_are_set);

  // namespace BitUtil
  // namespace arrow


// Parsed from arrow/util/ubsan.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Contains utilities for making UBSan happy.

// #pragma once

// #include <cstring>
// #include <memory>
// #include <type_traits>

// #include "arrow/util/macros.h"



  // namespace internal

/** \brief Returns maybe_null if not null or a non-null pointer to an arbitrary memory
 *  that shouldn't be dereferenced.
 * 
 *  Memset/Memcpy are undefined when a nullptr is passed as an argument use this utility
 *  method to wrap locations where this could happen.
 * 
 *  Note: Flatbuffers has UBSan warnings if a zero length vector is passed.
 *  https://github.com/google/flatbuffers/pull/5355 is trying to resolve
 *  them. */

  // namespace util
  // namespace arrow


// Parsed from arrow/util/key_value_metadata.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\KeyValueMetadata.java



/** \brief Create a KeyValueMetadata instance
 * 
 *  @param pairs key-value mapping */

///
@Namespace("arrow") public static native @SharedPtr KeyValueMetadata key_value_metadata(@Const @ByRef StringStringMap pairs);

/** \brief Create a KeyValueMetadata instance
 * 
 *  @param keys sequence of metadata keys
 *  @param values sequence of corresponding metadata values */
@Namespace("arrow") public static native @SharedPtr KeyValueMetadata key_value_metadata(@ByVal StringVector keys, @ByVal StringVector values);

  // namespace arrow


// Parsed from arrow/util/string_builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License. template <typename T>

// #pragma once

// #include <memory>
// #include <ostream>
// #include <string>
// #include <utility>

// #include "arrow/util/visibility.h"
// Targeting ..\StringStreamWrapper.java



  // namespace detail

/** CRTP helper for declaring string representation. Defines operator<< */

  // namespace util
  // namespace arrow


// Parsed from arrow/status.h

// Copyright (c) 2011 The LevelDB Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file. See the AUTHORS file for names of contributors.
//
// A Status encapsulates the result of an operation.  It may indicate success,
// or it may indicate an error with an associated error message.
//
// Multiple threads can invoke const methods on a Status without
// external synchronization, but if any of the threads may call a
// non-const method, all threads accessing the same Status must use
// external synchronization.

// Adapted from Apache Kudu, TensorFlow

// #pragma once

// #include <cstring>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <utility>

// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_builder.h"
// #include "arrow/util/visibility.h"

// #ifdef ARROW_EXTRA_ERROR_CONTEXT

// #else

// #define ARROW_RETURN_IF_(condition, status, _)
//   do {
//     if (ARROW_PREDICT_FALSE(condition)) {
//       return (status);
//     }
//   } while (0)

// #endif  // ARROW_EXTRA_ERROR_CONTEXT

// #define ARROW_RETURN_IF(condition, status)
//   ARROW_RETURN_IF_(condition, status, ARROW_STRINGIFY(status))

/** \brief Propagate any non-successful Status to the caller */
// #define ARROW_RETURN_NOT_OK(status)
//   do {
//     ::arrow::Status __s = ::arrow::internal::GenericToStatus(status);
//     ARROW_RETURN_IF_(!__s.ok(), __s, ARROW_STRINGIFY(status));
//   } while (false)

// #define RETURN_NOT_OK_ELSE(s, else_)
//   do {
//     ::arrow::Status _s = ::arrow::internal::GenericToStatus(s);
//     if (!_s.ok()) {
//       else_;
//       return _s;
//     }
//   } while (false)

// This is an internal-use macro and should not be used in public headers.
// #ifndef RETURN_NOT_OK
// #define RETURN_NOT_OK(s) ARROW_RETURN_NOT_OK(s)
// #endif

@Namespace("arrow") public enum StatusCode {
  OK((byte)0),
  OutOfMemory((byte)1),
  KeyError((byte)2),
  TypeError((byte)3),
  Invalid((byte)4),
  IOError((byte)5),
  CapacityError((byte)6),
  IndexError((byte)7),
  UnknownError((byte)9),
  NotImplemented((byte)10),
  SerializationError((byte)11),
  RError((byte)13),
  // Gandiva range of errors
  CodeGenError((byte)40),
  ExpressionValidationError((byte)41),
  ExecutionError((byte)42),
  // Continue generic codes.
  AlreadyExists((byte)45);

    public final byte value;
    private StatusCode(byte v) { this.value = v; }
    private StatusCode(StatusCode e) { this.value = e.value; }
    public StatusCode intern() { for (StatusCode e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\StatusDetail.java


// Targeting ..\Status.java















/** \cond FALSE */
// (note: emits warnings on Doxygen < 1.8.15,
//  see https://github.com/doxygen/doxygen/issues/6295)







/** \endcond */

// Extract Status from Status or Result<T>
// Useful for the status check macros such as RETURN_NOT_OK.
@Namespace("arrow::internal") public static native @ByVal Status GenericToStatus(@Const @ByRef Status st);

  // namespace internal

  // namespace arrow


// Parsed from arrow/memory_pool.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <atomic>
// #include <cstdint>
// #include <memory>
// #include <string>

// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ..\MemoryPoolStats.java




// Targeting ..\MemoryPool.java


// Targeting ..\LoggingMemoryPool.java


// Targeting ..\ProxyMemoryPool.java



/** Return a process-wide memory pool based on the system allocator. */

///
@Namespace("arrow") public static native MemoryPool system_memory_pool();

/** Return a process-wide memory pool based on jemalloc.
 * 
 *  May return NotImplemented if jemalloc is not available. */
@Namespace("arrow") public static native @ByVal Status jemalloc_memory_pool(@Cast("arrow::MemoryPool**") PointerPointer out);
@Namespace("arrow") public static native @ByVal Status jemalloc_memory_pool(@ByPtrPtr MemoryPool out);

/** \brief Set jemalloc memory page purging behavior for future-created arenas
 *  to the indicated number of milliseconds. See dirty_decay_ms and
 *  muzzy_decay_ms options in jemalloc for a description of what these do. The
 *  default is configured to 1000 (1 second) which releases memory more
 *  aggressively to the operating system than the jemalloc default of 10
 *  seconds. If you set the value to 0, dirty / muzzy pages will be released
 *  immediately rather than with a time decay, but this may reduce application
 *  performance. */

///
@Namespace("arrow") public static native @ByVal Status jemalloc_set_decay_ms(int ms);

/** Return a process-wide memory pool based on mimalloc.
 * 
 *  May return NotImplemented if mimalloc is not available. */
@Namespace("arrow") public static native @ByVal Status mimalloc_memory_pool(@Cast("arrow::MemoryPool**") PointerPointer out);
@Namespace("arrow") public static native @ByVal Status mimalloc_memory_pool(@ByPtrPtr MemoryPool out);

  // namespace arrow


// Parsed from arrow/buffer.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <cstring>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/device.h"
// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ArrowBuffer.java



/** \defgroup buffer-slicing-functions Functions for slicing buffers
 * 
 *  \{
 <p>
 *  \brief Construct a view on a buffer at the given offset and length.
 * 
 *  This function cannot fail and does not check for errors (except in debug builds) */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceBuffer(@SharedPtr ArrowBuffer buffer,
                                                  @Cast("const int64_t") long offset,
                                                  @Cast("const int64_t") long length);

/** \brief Construct a view on a buffer at the given offset, up to the buffer's end.
 * 
 *  This function cannot fail and does not check for errors (except in debug builds) */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceBuffer(@SharedPtr ArrowBuffer buffer,
                                                  @Cast("const int64_t") long offset);

/** \brief Input-checking version of SliceBuffer
 * 
 *  An Invalid Status is returned if the requested slice falls out of bounds. */

///
@Namespace("arrow") public static native @ByVal BufferResult SliceBufferSafe(@SharedPtr ArrowBuffer buffer,
                                                @Cast("int64_t") long offset);
/** \brief Input-checking version of SliceBuffer
 * 
 *  An Invalid Status is returned if the requested slice falls out of bounds.
 *  Note that unlike SliceBuffer, {@code length} isn't clamped to the available buffer size. */

///
@Namespace("arrow") public static native @ByVal BufferResult SliceBufferSafe(@SharedPtr ArrowBuffer buffer,
                                                @Cast("int64_t") long offset, @Cast("int64_t") long length);

/** \brief Like SliceBuffer, but construct a mutable buffer slice.
 * 
 *  If the parent buffer is not mutable, behavior is undefined (it may abort
 *  in debug builds). */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceMutableBuffer(@SharedPtr ArrowBuffer buffer,
                                           @Cast("const int64_t") long offset, @Cast("const int64_t") long length);

/** \brief Like SliceBuffer, but construct a mutable buffer slice.
 * 
 *  If the parent buffer is not mutable, behavior is undefined (it may abort
 *  in debug builds). */

///
@Namespace("arrow") public static native @SharedPtr ArrowBuffer SliceMutableBuffer(
    @SharedPtr ArrowBuffer buffer, @Cast("const int64_t") long offset);

/** \brief Input-checking version of SliceMutableBuffer
 * 
 *  An Invalid Status is returned if the requested slice falls out of bounds. */

///
@Namespace("arrow") public static native @ByVal BufferResult SliceMutableBufferSafe(
    @SharedPtr ArrowBuffer buffer, @Cast("int64_t") long offset);
/** \brief Input-checking version of SliceMutableBuffer
 * 
 *  An Invalid Status is returned if the requested slice falls out of bounds.
 *  Note that unlike SliceBuffer, {@code length} isn't clamped to the available buffer size. */
@Namespace("arrow") public static native @ByVal BufferResult SliceMutableBufferSafe(
    @SharedPtr ArrowBuffer buffer, @Cast("int64_t") long offset, @Cast("int64_t") long length);
// Targeting ..\MutableBuffer.java


// Targeting ..\ResizableBuffer.java



/** \defgroup buffer-allocation-functions Functions for allocating buffers
 * 
 *  \{
 <p>
 *  \brief Allocate a fixed size mutable buffer from a memory pool, zero its padding.
 * 
 *  @param size [in] size of buffer to allocate
 *  @param pool [in] a memory pool */

///
@Namespace("arrow") public static native @ByVal BufferUniqueResult AllocateBuffer(@Cast("const int64_t") long size,
                                               MemoryPool pool/*=nullptr*/);
@Namespace("arrow") public static native @ByVal BufferUniqueResult AllocateBuffer(@Cast("const int64_t") long size);

/** \brief Allocate a resizeable buffer from a memory pool, zero its padding.
 * 
 *  @param size [in] size of buffer to allocate
 *  @param pool [in] a memory pool */

///
@Namespace("arrow") public static native @ByVal ResizableUniqueResult AllocateResizableBuffer(
    @Cast("const int64_t") long size, MemoryPool pool/*=nullptr*/);
@Namespace("arrow") public static native @ByVal ResizableUniqueResult AllocateResizableBuffer(
    @Cast("const int64_t") long size);

/** \brief Allocate a bitmap buffer from a memory pool
 *  no guarantee on values is provided.
 * 
 *  @param length [in] size in bits of bitmap to allocate
 *  @param pool [in] memory pool to allocate memory from */




/** \brief Allocate a zero-initialized bitmap buffer from a memory pool
 * 
 *  @param length [in] size in bits of bitmap to allocate
 *  @param pool [in] memory pool to allocate memory from */

///
@Namespace("arrow") public static native @ByVal BufferResult AllocateEmptyBitmap(@Cast("int64_t") long length,
                                                    MemoryPool pool/*=nullptr*/);
@Namespace("arrow") public static native @ByVal BufferResult AllocateEmptyBitmap(@Cast("int64_t") long length);

/** \brief Concatenate multiple buffers into a single buffer
 * 
 *  @param buffers [in] to be concatenated
 *  @param pool [in] memory pool to allocate the new buffer from */




/** \} */

  // namespace arrow


// Parsed from arrow/buffer_builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <cstdint>
// #include <cstring>
// #include <memory>
// #include <string>
// #include <utility>

// #include "arrow/buffer.h"
// #include "arrow/status.h"
// #include "arrow/util/bit_util.h"
// #include "arrow/util/bitmap_generate.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/ubsan.h"
// #include "arrow/util/visibility.h"
// Targeting ..\BufferBuilder.java



/** \brief A BufferBuilder for building a buffer of arithmetic elements */
// Targeting ..\TypedBufferBuilder.java



  // namespace arrow


// Parsed from arrow/compare.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Functions for comparing Arrow data structures

// #pragma once

// #include <cstdint>
// #include <iosfwd>

// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\SparseTensor.java



@Namespace("arrow") @MemberGetter public static native double kDefaultAbsoluteTolerance();
public static final double kDefaultAbsoluteTolerance = kDefaultAbsoluteTolerance();
// Targeting ..\EqualOptions.java



/** Returns true if the arrays are exactly equal */
@Namespace("arrow") public static native @Cast("bool") boolean ArrayEquals(@Const @ByRef Array left, @Const @ByRef Array right,
                              @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean ArrayEquals(@Const @ByRef Array left, @Const @ByRef Array right);

@Namespace("arrow") public static native @Cast("bool") boolean TensorEquals(@Const @ByRef Tensor left, @Const @ByRef Tensor right,
                               @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean TensorEquals(@Const @ByRef Tensor left, @Const @ByRef Tensor right);

/** EXPERIMENTAL: Returns true if the given sparse tensors are exactly equal */
@Namespace("arrow") public static native @Cast("bool") boolean SparseTensorEquals(@Const @ByRef SparseTensor left, @Const @ByRef SparseTensor right,
                                     @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean SparseTensorEquals(@Const @ByRef SparseTensor left, @Const @ByRef SparseTensor right);

/** Returns true if the arrays are approximately equal. For non-floating point
 *  types, this is equivalent to ArrayEquals(left, right) */
@Namespace("arrow") public static native @Cast("bool") boolean ArrayApproxEquals(@Const @ByRef Array left, @Const @ByRef Array right,
                                    @Const @ByRef(nullValue = "arrow::EqualOptions::Defaults()") EqualOptions arg2);
@Namespace("arrow") public static native @Cast("bool") boolean ArrayApproxEquals(@Const @ByRef Array left, @Const @ByRef Array right);

/** Returns true if indicated equal-length segment of arrays is exactly equal */
@Namespace("arrow") public static native @Cast("bool") boolean ArrayRangeEquals(@Const @ByRef Array left, @Const @ByRef Array right,
                                   @Cast("int64_t") long start_idx, @Cast("int64_t") long end_idx,
                                   @Cast("int64_t") long other_start_idx);

/** Returns true if the type metadata are exactly equal
 *  @param left [in] a DataType
 *  @param right [in] a DataType
 *  @param check_metadata [in] whether to compare KeyValueMetadata for child
 *  fields */
@Namespace("arrow") public static native @Cast("bool") boolean TypeEquals(@Const @ByRef DataType left, @Const @ByRef DataType right,
                             @Cast("bool") boolean check_metadata/*=true*/);
@Namespace("arrow") public static native @Cast("bool") boolean TypeEquals(@Const @ByRef DataType left, @Const @ByRef DataType right);

/** Returns true if scalars are equal
 *  @param left [in] a Scalar
 *  @param right [in] a Scalar */
@Namespace("arrow") public static native @Cast("bool") boolean ScalarEquals(@Const @ByRef Scalar left, @Const @ByRef Scalar right);

  // namespace arrow


// Parsed from arrow/result.h

//
// Copyright 2017 Asylo authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Adapted from Asylo

// #pragma once

// #include <new>
// #include <string>
// #include <type_traits>
// #include <utility>

// #include "arrow/status.h"
// #include "arrow/util/compare.h"

// #if __cplusplus >= 201703L
// #else
// #endif

@Namespace("arrow::internal") public static native void DieWithMessage(@StdString String msg);
@Namespace("arrow::internal") public static native void DieWithMessage(@StdString BytePointer msg);

@Namespace("arrow::internal") public static native void InvalidValueOrDie(@Const @ByRef Status st);


// Targeting ..\BoolResult.java


// Targeting ..\LongResult.java


// Targeting ..\SizeTResult.java


// Targeting ..\StringResult.java


// Targeting ..\ValueDescrResult.java


// Targeting ..\ArrayVectorResult.java


// Targeting ..\CompressionTypeResult.java


// Targeting ..\FieldRefResult.java


// Targeting ..\Decimal128Result.java


// Targeting ..\Decimal128PairResult.java


// Targeting ..\StringViewResult.java


// Targeting ..\LocalFileSystemOptionsResult.java


// Targeting ..\HDFSOptionsResult.java


// Targeting ..\ThreadPoolResult.java


// Targeting ..\ArrayResult.java


// Targeting ..\ArrayDataResult.java


// Targeting ..\BufferResult.java


// Targeting ..\BufferUniqueResult.java


// Targeting ..\ResizableResult.java


// Targeting ..\ResizableUniqueResult.java


// Targeting ..\DataTypeResult.java


// Targeting ..\FieldResult.java


// Targeting ..\ListArrayResult.java


// Targeting ..\BinaryArrayResult.java


// Targeting ..\StructArrayResult.java


// Targeting ..\RecordBatchResult.java


// Targeting ..\ScalarResult.java


// Targeting ..\ChunkedArrayResult.java


// Targeting ..\SchemaResult.java


// Targeting ..\SparseTensorResult.java


// Targeting ..\TableResult.java


// Targeting ..\TensorResult.java


// Targeting ..\InputStreamResult.java


// Targeting ..\OutputStreamResult.java


// Targeting ..\MemoryMappedFileResult.java


// Targeting ..\ReadableFileResult.java


// Targeting ..\RandomAccessFileResult.java


// Targeting ..\FileOutputStreamResult.java


// Targeting ..\BufferOutputStreamResult.java


// Targeting ..\BufferedInputStreamResult.java


// Targeting ..\BufferedOutputStreamResult.java


// Targeting ..\CompressedInputStreamResult.java


// Targeting ..\CompressedOutputStreamResult.java


// Targeting ..\StreamingReaderResult.java


// Targeting ..\TableReaderResult.java


// Targeting ..\FunctionResult.java


// Targeting ..\DatumResult.java


// Targeting ..\ScalarKernelResult.java


// Targeting ..\ScalarAggregateKernelResult.java


// Targeting ..\VectorKernelResult.java


// Targeting ..\SelectionVectorResult.java


// Targeting ..\FileInfoResult.java


// Targeting ..\PathForestResult.java


// Targeting ..\FileInfoVectorResult.java


// Targeting ..\BufferVectorResult.java


// Targeting ..\ChunkedArrayVectorResult.java


// Targeting ..\RecordBatchVectorResult.java


// Targeting ..\SchemaVectorResult.java


// Targeting ..\FileSystemResult.java


// Targeting ..\CompressorResult.java


// Targeting ..\DecompressorResult.java


// Targeting ..\CompressResultResult.java


// Targeting ..\EndResultResult.java


// Targeting ..\FlushResultResult.java


// Targeting ..\DecompressResultResult.java


// Targeting ..\IpcPayloadWriterResult.java


// Targeting ..\MessageSharedResult.java


// Targeting ..\MessageUniqueResult.java


// Targeting ..\FeatherReaderResult.java


// Targeting ..\RecordBatchFileReaderResult.java


// Targeting ..\RecordBatchReaderSharedResult.java


// Targeting ..\RecordBatchWriterSharedResult.java


// Targeting ..\RecordBatchWriterUniqueResult.java


// Targeting ..\CodecResult.java


// Targeting ..\DictionaryUnifierResult.java


// Targeting ..\BufferIteratorResult.java


// Targeting ..\RecordBatchIteratorResult.java



// #define ARROW_ASSIGN_OR_RAISE_IMPL(result_name, lhs, rexpr)
//   auto result_name = (rexpr);
//   ARROW_RETURN_NOT_OK((result_name).status());
//   lhs = std::move(result_name).MoveValueUnsafe();


///
///
///
// #define ARROW_ASSIGN_OR_RAISE_NAME(x, y) ARROW_CONCAT(x, y)

/** \brief Execute an expression that returns a Result, extracting its value
 *  into the variable defined by {@code lhs} (or returning a Status on error).
 * 
 *  Example: Assigning to a new value:
 *    ARROW_ASSIGN_OR_RAISE(auto value, MaybeGetValue(arg));
 * 
 *  Example: Assigning to an existing value:
 *    ValueType value;
 *    ARROW_ASSIGN_OR_RAISE(value, MaybeGetValue(arg));
 * 
 *  WARNING: ARROW_ASSIGN_OR_RAISE expands into multiple statements;
 *  it cannot be used in a single statement (e.g. as the body of an if
 *  statement without {})! */
// #define ARROW_ASSIGN_OR_RAISE(lhs, rexpr)
//   ARROW_ASSIGN_OR_RAISE_IMPL(ARROW_ASSIGN_OR_RAISE_NAME(_error_or_value, __COUNTER__),
//                              lhs, rexpr);

  // namespace internal

  // namespace arrow


// Parsed from arrow/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <limits>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

// Targeting ..\Device.java


// Targeting ..\MemoryManager.java


// Targeting ..\DictionaryArray.java


// Targeting ..\BooleanType.java


// Targeting ..\BinaryArray.java


// Targeting ..\LargeBinaryArray.java


// Targeting ..\FixedSizeBinaryArray.java


// Targeting ..\StringArray.java


// Targeting ..\LargeStringArray.java


// Targeting ..\Decimal128Array.java


// Targeting ..\UnionMode.java



// #define _NUMERIC_TYPE_DECL(KLASS)
//   class KLASS##Type;
//   using KLASS##Array = NumericArray<KLASS##Type>;
//   using KLASS##Builder = NumericBuilder<KLASS##Type>;
//   struct KLASS##Scalar;
//   using KLASS##Tensor = NumericTensor<KLASS##Type>;
// Targeting ..\Int8Type.java


// Targeting ..\Int16Type.java


// Targeting ..\Int32Type.java


// Targeting ..\Int64Type.java


// Targeting ..\UInt8Type.java


// Targeting ..\UInt16Type.java


// Targeting ..\UInt32Type.java


// Targeting ..\UInt64Type.java


// Targeting ..\HalfFloatType.java


// Targeting ..\FloatType.java


// Targeting ..\DoubleType.java



// #undef _NUMERIC_TYPE_DECL

@Namespace("arrow") public enum DateUnit { DAY((byte)0), MILLI((byte)1);

    public final byte value;
    private DateUnit(byte v) { this.value = v; }
    private DateUnit(DateUnit e) { this.value = e.value; }
    public DateUnit intern() { for (DateUnit e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\TimeUnit.java


// Targeting ..\Type.java



/** \defgroup type-factories Factory functions for creating data types
 * 
 *  Factory functions for creating data types
 *  \{
 <p>
 *  \brief Return a NullType instance */
@Namespace("arrow") public static native @SharedPtr @Name("null") @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType _null();
/** \brief Return a BooleanType instance */
@Namespace("arrow") public static native @SharedPtr @Name("boolean") @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType _boolean();
/** \brief Return a Int8Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int8();
/** \brief Return a Int16Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int16();
/** \brief Return a Int32Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int32();
/** \brief Return a Int64Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType int64();
/** \brief Return a UInt8Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint8();
/** \brief Return a UInt16Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint16();
/** \brief Return a UInt32Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint32();
/** \brief Return a UInt64Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType uint64();
/** \brief Return a HalfFloatType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType float16();
/** \brief Return a FloatType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType float32();
/** \brief Return a DoubleType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType float64();
/** \brief Return a StringType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType utf8();
/** \brief Return a LargeStringType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_utf8();
/** \brief Return a BinaryType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType binary();
/** \brief Return a LargeBinaryType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_binary();
/** \brief Return a Date32Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType date32();
/** \brief Return a Date64Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType date64();

/** \brief Create a FixedSizeBinaryType instance. */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType fixed_size_binary(int byte_width);

/** \brief Create a Decimal128Type instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType decimal(int precision, int scale);

/** \brief Create a ListType instance from its child Field type */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field value_type);

/** \brief Create a ListType instance from its child DataType */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type);

/** \brief Create a LargeListType instance from its child Field type */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field value_type);

/** \brief Create a LargeListType instance from its child DataType */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType large_list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type);

/** \brief Create a MapType instance from its key and value DataTypes */

///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType map(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType key_type,
                              @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType item_type,
                              @Cast("bool") boolean keys_sorted/*=false*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType map(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType key_type,
                              @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType item_type);

/** \brief Create a MapType instance from its key DataType and value field.
 * 
 *  The field override is provided to communicate nullability of the value. */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType map(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType key_type,
                              @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field item_field,
                              @Cast("bool") boolean keys_sorted/*=false*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType map(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType key_type,
                              @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field item_field);

/** \brief Create a FixedSizeListType instance from its child Field type */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType fixed_size_list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field value_type,
                                          int list_size);

/** \brief Create a FixedSizeListType instance from its child DataType */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType fixed_size_list(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type,
                                          int list_size);
/** \brief Return a Duration instance (naming use _type to avoid namespace conflict with
 *  built in time clases). */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType duration(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType duration(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Return a DayTimeIntervalType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType day_time_interval();

/** \brief Return a MonthIntervalType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType month_interval();

/** \brief Create a TimestampType instance from its unit */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Create a TimestampType instance from its unit and timezone */

///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(TimeUnit.type unit, @StdString String timezone);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType timestamp(@Cast("arrow::TimeUnit::type") int unit, @StdString BytePointer timezone);

/** \brief Create a 32-bit time type instance
 * 
 *  Unit can be either SECOND or MILLI */

///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time32(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time32(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Create a 64-bit time type instance
 * 
 *  Unit can be either MICRO or NANO */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time64(TimeUnit.type unit);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType time64(@Cast("arrow::TimeUnit::type") int unit);

/** \brief Create a StructType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType struct_(@Const @ByRef FieldVector fields);

/** \brief Create a SparseUnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@ByVal FieldVector child_fields,
                                                    @StdVector BytePointer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@ByVal FieldVector child_fields);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@ByVal FieldVector child_fields,
                                                    @StdVector ByteBuffer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@ByVal FieldVector child_fields,
                                                    @StdVector byte[] type_codes/*={}*/);
/** \brief Create a DenseUnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@ByVal FieldVector child_fields,
                                                   @StdVector BytePointer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@ByVal FieldVector child_fields);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@ByVal FieldVector child_fields,
                                                   @StdVector ByteBuffer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@ByVal FieldVector child_fields,
                                                   @StdVector byte[] type_codes/*={}*/);

/** \brief Create a SparseUnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@Const @ByRef ArrayVector children, @ByVal(nullValue = "std::vector<std::string>({})") StringVector field_names,
             @StdVector BytePointer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@Const @ByRef ArrayVector children);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@Const @ByRef ArrayVector children, @ByVal(nullValue = "std::vector<std::string>({})") StringVector field_names,
             @StdVector ByteBuffer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType sparse_union(@Const @ByRef ArrayVector children, @ByVal(nullValue = "std::vector<std::string>({})") StringVector field_names,
             @StdVector byte[] type_codes/*={}*/);
/** \brief Create a DenseUnionType instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@Const @ByRef ArrayVector children, @ByVal(nullValue = "std::vector<std::string>({})") StringVector field_names,
            @StdVector BytePointer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@Const @ByRef ArrayVector children);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@Const @ByRef ArrayVector children, @ByVal(nullValue = "std::vector<std::string>({})") StringVector field_names,
            @StdVector ByteBuffer type_codes/*={}*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dense_union(@Const @ByRef ArrayVector children, @ByVal(nullValue = "std::vector<std::string>({})") StringVector field_names,
            @StdVector byte[] type_codes/*={}*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector BytePointer type_codes, UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector BytePointer type_codes);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector ByteBuffer type_codes, @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector ByteBuffer type_codes);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector byte[] type_codes, UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector byte[] type_codes);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector BytePointer type_codes, @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector ByteBuffer type_codes, UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @StdVector byte[] type_codes, @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef FieldVector child_fields,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector BytePointer type_codes,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector BytePointer type_codes);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector ByteBuffer type_codes,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector ByteBuffer type_codes);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector byte[] type_codes,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector byte[] type_codes);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector BytePointer type_codes,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector ByteBuffer type_codes,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names, @StdVector byte[] type_codes,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Const @ByRef StringVector field_names,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);

/** \brief Create a UnionType instance */
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       UnionMode.type mode/*=arrow::UnionMode::SPARSE*/);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children);
@Namespace("arrow") public static native @Deprecated @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType union_(@Const @ByRef ArrayVector children,
       @Cast("arrow::UnionMode::type") int mode/*=arrow::UnionMode::SPARSE*/);
/** \brief Create a DictionaryType instance
 *  @param index_type [in] the type of the dictionary indices (must be
 *  a signed integer)
 *  @param dict_type [in] the type of the values in the variable dictionary
 *  @param ordered [in] true if the order of the dictionary values has
 *  semantic meaning and should be preserved where possible */

///
///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dictionary(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType index_type,
                                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dict_type,
                                     @Cast("bool") boolean ordered/*=false*/);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dictionary(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType index_type,
                                     @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType dict_type);

/** \}
 <p>
 *  \defgroup schema-factories Factory functions for fields and schemas
 * 
 *  Factory functions for fields and schemas
 *  \{
 <p>
 *  \brief Create a Field instance
 * 
 *  @param name the field name
 *  @param type the field value type
 *  @param nullable whether the values are nullable, default true
 *  @param metadata any custom key-value metadata, default null */

///
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field(@StdString String name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("bool") boolean nullable/*=true*/,
      @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByVal(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field(@StdString String name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field(@StdString BytePointer name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("bool") boolean nullable/*=true*/,
      @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByVal(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Field>"}) Field field(@StdString BytePointer name, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

/** \brief Create a Schema instance
 * 
 *  @param fields the schema's fields
 *  @param metadata any custom key-value metadata, default null
 *  @return schema shared_ptr to Schema */
@Namespace("arrow") public static native @SharedPtr @ByVal Schema schema(
    @ByVal FieldVector fields,
    @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByVal(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow") public static native @SharedPtr @ByVal Schema schema(
    @ByVal FieldVector fields);

/** \}
 <p>
 *  Return the process-wide default memory pool. */
@Namespace("arrow") public static native MemoryPool default_memory_pool();

  // namespace arrow


// Parsed from arrow/type_traits.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <type_traits>
// #include <vector>

// #include "arrow/type_fwd.h"
// #include "arrow/util/bit_util.h"

//
// Per-type id type lookup
//

// #define TYPE_ID_TRAIT(_id, _typeclass)
//   template <>
//   struct TypeIdTraits<Type::_id> {
//     using Type = _typeclass;
//   };
// Targeting ..\TypeIdTraits.java

  // XXX or DecimalType?

// #undef TYPE_ID_TRAIT

//
// Per-type type traits
//

// #define PRIMITIVE_TYPE_TRAITS_DEF_(CType_, ArrowType_, ArrowArrayType, ArrowBuilderType,
//                                    ArrowScalarType, ArrowTensorType, SingletonFn)
//   template <>
//   struct TypeTraits<ArrowType_> {
//     using ArrayType = ArrowArrayType;
//     using BuilderType = ArrowBuilderType;
//     using ScalarType = ArrowScalarType;
//     using TensorType = ArrowTensorType;
//     using CType = ArrowType_::c_type;
//     static constexpr int64_t bytes_required(int64_t elements) {
//       return elements * static_cast<int64_t>(sizeof(CType));
//     }
//     constexpr static bool is_parameter_free = true;
//     static inline std::shared_ptr<DataType> type_singleton() { return SingletonFn(); }
//   };
// 
//   template <>
//   struct CTypeTraits<CType_> : public TypeTraits<ArrowType_> {
//     using ArrowType = ArrowType_;
//   };

// #define PRIMITIVE_TYPE_TRAITS_DEF(CType, ArrowShort, SingletonFn)
//   PRIMITIVE_TYPE_TRAITS_DEF_(
//       CType, ARROW_CONCAT(ArrowShort, Type), ARROW_CONCAT(ArrowShort, Array),
//       ARROW_CONCAT(ArrowShort, Builder), ARROW_CONCAT(ArrowShort, Scalar),
//       ARROW_CONCAT(ArrowShort, Tensor), SingletonFn)

// #undef PRIMITIVE_TYPE_TRAITS_DEF
// #undef PRIMITIVE_TYPE_TRAITS_DEF_

  // namespace internal

//
// Useful type predicates
//

// only in C++14

// Note this will also include HalfFloatType which is represented by a
// non-floating point primitive (uint16_t).

// Half floats are special in that they behave physically like an unsigned
// integer.

// Binary Types

// Base binary refers to Binary/LargeBinary/String/LargeString

// Any binary excludes string from Base binary

// Note that this also includes DecimalType

// Nested Types

// DEPRECATED use is_var_length_list_type.

// DEPRECATED use enable_if_var_size_list

// TemporalTypes

// Attribute differentiation

// Physical representation quirks

// Like is_floating_type but excluding half-floats which don't have a
// float-like c type.

@Namespace("arrow") public static native @Cast("bool") boolean is_integer(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_floating(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_primitive(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_base_binary_like(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_binary_like(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_large_binary_like(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_dictionary(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_fixed_size_binary(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_fixed_width(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow") public static native @Cast("bool") boolean is_nested(@Cast("arrow::Type::type") int type_id);

  // namespace arrow


// Parsed from arrow/util/basic_decimal.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <array>
// #include <cstdint>
// #include <limits>
// #include <string>
// #include <type_traits>

// #include "arrow/util/macros.h"
// #include "arrow/util/type_traits.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow") public enum DecimalStatus {
  kSuccess(0),
  kDivideByZero(1),
  kOverflow(2),
  kRescaleDataLoss(3);

    public final int value;
    private DecimalStatus(int v) { this.value = v; }
    private DecimalStatus(DecimalStatus e) { this.value = e.value; }
    public DecimalStatus intern() { for (DecimalStatus e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\BasicDecimal128.java



@Namespace("arrow") public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator <=") boolean lessThanEquals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator >") boolean greaterThan(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @Cast("bool") @Name("operator >=") boolean greaterThanEquals(@Const @ByRef BasicDecimal128 left, @Const @ByRef BasicDecimal128 right);

@Namespace("arrow") public static native @ByVal @Name("operator -") BasicDecimal128 subtract(@Const @ByRef BasicDecimal128 operand);
@Namespace("arrow") public static native @ByVal @Name("operator ~") BasicDecimal128 not(@Const @ByRef BasicDecimal128 operand);
@Namespace("arrow") public static native @ByVal @Name("operator +") BasicDecimal128 add(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator -") BasicDecimal128 subtract(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator *") BasicDecimal128 multiply(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator /") BasicDecimal128 divide(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);
@Namespace("arrow") public static native @ByVal @Name("operator %") BasicDecimal128 mod(@Const @ByRef BasicDecimal128 left,
                                       @Const @ByRef BasicDecimal128 right);

  // namespace arrow


// Parsed from arrow/util/decimal.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <iosfwd>
// #include <limits>
// #include <string>
// #include <utility>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/basic_decimal.h"
// #include "arrow/util/string_view.h"
// Targeting ..\Decimal128.java



  // namespace arrow


// Parsed from arrow/util/sort.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <cstdint>
// #include <functional>
// #include <numeric>
// #include <utility>
// #include <vector>

  // namespace internal
  // namespace arrow


// Parsed from arrow/util/future.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <atomic>
// #include <cmath>
// #include <memory>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

/** A Future's execution or completion status */
@Namespace("arrow") public enum FutureState { PENDING((byte)0), SUCCESS((byte)1), FAILURE((byte)2);

    public final byte value;
    private FutureState(byte v) { this.value = v; }
    private FutureState(FutureState e) { this.value = e.value; }
    public FutureState intern() { for (FutureState e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}

@Namespace("arrow") public static native @Cast("bool") boolean IsFutureFinished(FutureState state);
@Namespace("arrow") public static native @Cast("bool") boolean IsFutureFinished(@Cast("arrow::FutureState") byte state);
// Targeting ..\FutureImpl.java


// Targeting ..\FutureWaiter.java


// Targeting ..\FutureStorageBase.java


// Targeting ..\FutureStorage.java



// A Future<Status> just stores a Status.

// ---------------------------------------------------------------------
// Public API

/** \brief EXPERIMENTAL A std::future-like class with more functionality.
 * 
 *  A Future represents the results of a past or future computation.
 *  The Future API has two sides: a producer side and a consumer side.
 * 
 *  The producer API allows creating a Future and setting its result or
 *  status, possibly after running a computation function.
 * 
 *  The consumer API allows querying a Future's current state, wait for it
 *  to complete, or wait on multiple Futures at once (using WaitForAll,
 *  WaitForAny or AsCompletedIterator). */

/** \brief Wait for all the futures to end, or for the given timeout to expire.
 * 
 *  {@code true} is returned if all the futures completed before the timeout was reached,
 *  {@code false} otherwise. */

/** \brief Wait for all the futures to end, or for the given timeout to expire.
 * 
 *  {@code true} is returned if all the futures completed before the timeout was reached,
 *  {@code false} otherwise. */

/** \brief Wait for one of the futures to end, or for the given timeout to expire.
 * 
 *  The indices of all completed futures are returned.  Note that some futures
 *  may not be in the returned set, but still complete concurrently. */

/** \brief Wait for one of the futures to end, or for the given timeout to expire.
 * 
 *  The indices of all completed futures are returned.  Note that some futures
 *  may not be in the returned set, but still complete concurrently. */

// #define ARROW_ASSIGN_OR_RETURN_FUTURE_IMPL(result_name, lhs, T, rexpr)
//   auto result_name = (rexpr);
//   if (ARROW_PREDICT_FALSE(!(result_name).ok())) {
//     return Future<T>::MakeFinished(std::move(result_name).status());
//   }
//   lhs = std::move(result_name).MoveValueUnsafe();

// #define ARROW_ASSIGN_OR_RETURN_FUTURE(lhs, T, rexpr)
//   ARROW_ASSIGN_OR_RETURN_FUTURE_IMPL(
//       ARROW_ASSIGN_OR_RAISE_NAME(_error_or_value, __COUNTER__), lhs, T, rexpr);

  // namespace arrow


// Parsed from arrow/util/task_group.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <functional>
// #include <memory>
// #include <utility>

// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ..\TaskGroup.java



  // namespace internal
  // namespace arrow


// Parsed from arrow/util/thread_pool.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #ifndef _WIN32
// #include <unistd.h>
// #endif

// #include <cstdint>
// #include <functional>
// #include <memory>
// #include <type_traits>
// #include <utility>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/future.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

// #if defined(_MSC_VER)
// Disable harmless warning for decorated name length limit
// #pragma warning(disable : 4503)
// #endif

/** \brief Get the capacity of the global thread pool
 * 
 *  Return the number of worker threads in the thread pool to which
 *  Arrow dispatches various CPU-bound tasks.  This is an ideal number,
 *  not necessarily the exact number of threads at a given point in time.
 * 
 *  You can change this number using SetCpuThreadPoolCapacity(). */

///
///
@Namespace("arrow") public static native int GetCpuThreadPoolCapacity();

/** \brief Set the capacity of the global thread pool
 * 
 *  Set the number of worker threads int the thread pool to which
 *  Arrow dispatches various CPU-bound tasks.
 * 
 *  The current number is returned by GetCpuThreadPoolCapacity(). */
@Namespace("arrow") public static native @ByVal Status SetCpuThreadPoolCapacity(int threads);

// Make sure that both functions returning T and Result<T> can be called
// through Executor::Submit(), and that a Future<T> is returned for both.


// Targeting ..\TaskHints.java


// Targeting ..\Executor.java


// Targeting ..\ThreadPool.java



// Return the process-global thread pool for CPU-bound tasks.
@Namespace("arrow::internal") public static native ThreadPool GetCpuThreadPool();

  // namespace internal
  // namespace arrow


// Parsed from arrow/type.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <atomic>
// #include <climits>
// #include <cstdint>
// #include <iosfwd>
// #include <limits>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/type_fwd.h"  // IWYU pragma: export
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/variant.h"
// #include "arrow/util/visibility.h"
// #include "arrow/visitor.h"
// Targeting ..\Fingerprintable.java




// Targeting ..\DataTypeLayout.java


// Targeting ..\DataType.java



@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef DataType type);
// Targeting ..\FixedWidthType.java


// Targeting ..\PrimitiveCType.java


// Targeting ..\NumberType.java


// Targeting ..\IntegerType.java


// Targeting ..\FloatingPointType.java


// Targeting ..\ParametricType.java


// Targeting ..\NestedType.java


// Targeting ..\Field.java






// Targeting ..\NullType.java



/** Concrete type class for boolean data */

/** Concrete type class for unsigned 8-bit integer data */

/** Concrete type class for signed 8-bit integer data */

/** Concrete type class for unsigned 16-bit integer data */

/** Concrete type class for signed 16-bit integer data */

/** Concrete type class for unsigned 32-bit integer data */

/** Concrete type class for signed 32-bit integer data */

/** Concrete type class for unsigned 64-bit integer data */

/** Concrete type class for signed 64-bit integer data */

/** Concrete type class for 16-bit floating-point data */

/** Concrete type class for 32-bit floating-point data (C "float") */

/** Concrete type class for 64-bit floating-point data (C "double") */
// Targeting ..\BaseListType.java


// Targeting ..\ListType.java


// Targeting ..\LargeListType.java


// Targeting ..\MapType.java


// Targeting ..\FixedSizeListType.java


// Targeting ..\BaseBinaryType.java



@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kBinaryMemoryLimit();
// Targeting ..\BinaryType.java


// Targeting ..\LargeBinaryType.java


// Targeting ..\StringType.java


// Targeting ..\LargeStringType.java


// Targeting ..\FixedSizeBinaryType.java


// Targeting ..\StructType.java


// Targeting ..\DecimalType.java


// Targeting ..\Decimal128Type.java


// Targeting ..\UnionType.java


// Targeting ..\SparseUnionType.java


// Targeting ..\DenseUnionType.java


// Targeting ..\TemporalType.java


// Targeting ..\DateType.java


// Targeting ..\Date32Type.java


// Targeting ..\Date64Type.java



@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, TimeUnit.type unit);
@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Cast("arrow::TimeUnit::type") int unit);
// Targeting ..\TimeType.java


// Targeting ..\Time32Type.java


// Targeting ..\Time64Type.java


// Targeting ..\TimestampType.java


// Targeting ..\IntervalType.java


// Targeting ..\MonthIntervalType.java


// Targeting ..\DayTimeIntervalType.java


// Targeting ..\DurationType.java


// Targeting ..\DictionaryType.java


// Targeting ..\DictionaryUnifier.java


// Targeting ..\FieldPath.java


// Targeting ..\FieldRef.java


// Targeting ..\Schema.java


// Targeting ..\SchemaBuilder.java



/** \brief Unifies schemas by merging fields by name.
 * 
 *  The behavior of field merging can be controlled via {@code Field::MergeOptions}.
 * 
 *  The resulting schema will contain the union of fields from all schemas.
 *  Fields with the same name will be merged. See {@code Field::MergeOptions}.
 *  - They are expected to be mergeable under provided {@code field_merge_options}.
 *  - The unified field will inherit the metadata from the schema where
 *    that field is first defined.
 *  - The first N fields in the schema will be ordered the same as the
 *    N fields in the first schema.
 *  The resulting schema will inherit its metadata from the first input schema.
 *  Returns an error if:
 *  - Any input schema contains fields with duplicate names.
 *  - Fields of the same name are not mergeable. */
@Namespace("arrow") public static native @ByVal SchemaResult UnifySchemas(
    @Const @ByRef SchemaVector schemas,
    @ByVal(nullValue = "arrow::Field::MergeOptions::Defaults()") Field.MergeOptions field_merge_options);
@Namespace("arrow") public static native @ByVal SchemaResult UnifySchemas(
    @Const @ByRef SchemaVector schemas);

@Namespace("arrow::internal") public static native @Cast("bool") boolean HasValidityBitmap(@Cast("arrow::Type::type") int id);

@Namespace("arrow::internal") public static native @StdString String ToString(@Cast("arrow::Type::type") int id);

@Namespace("arrow::internal") public static native @StdString String ToTypeName(@Cast("arrow::Type::type") int id);

@Namespace("arrow::internal") public static native @StdString String ToString(TimeUnit.type unit);

@Namespace("arrow::internal") public static native int GetByteWidth(@Const @ByRef DataType type);

  // namespace internal

  // namespace arrow


// Parsed from arrow/scalar.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Object model for scalar (non-Array) values. Not intended for use with large
// amounts of data
//
// NOTE: This API is experimental as of the 0.13 version and subject to change
// without deprecation warnings

// #pragma once

// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/decimal.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ..\Scalar.java


// Targeting ..\NullScalar.java


// Targeting ..\PrimitiveScalarBase.java




// Targeting ..\BooleanScalar.java


// Targeting ..\BaseInt8Type.java


// Targeting ..\BaseInt16Type.java


// Targeting ..\BaseInt32Type.java


// Targeting ..\BaseInt64Type.java


// Targeting ..\BaseUInt8Type.java


// Targeting ..\BaseUInt16Type.java


// Targeting ..\BaseUInt32Type.java


// Targeting ..\BaseUInt64Type.java


// Targeting ..\BaseHalfFloatScalar.java


// Targeting ..\BaseFloatScalar.java


// Targeting ..\BaseDoubleScalar.java


// Targeting ..\Int8Scalar.java


// Targeting ..\Int16Scalar.java


// Targeting ..\Int32Scalar.java


// Targeting ..\Int64Scalar.java


// Targeting ..\UInt8Scalar.java


// Targeting ..\UInt16Scalar.java


// Targeting ..\UInt32Scalar.java


// Targeting ..\UInt64Scalar.java


// Targeting ..\HalfFloatScalar.java


// Targeting ..\FloatScalar.java


// Targeting ..\DoubleScalar.java


// Targeting ..\BaseBinaryScalar.java


// Targeting ..\BinaryScalar.java


// Targeting ..\StringScalar.java


// Targeting ..\LargeBinaryScalar.java


// Targeting ..\LargeStringScalar.java


// Targeting ..\FixedSizeBinaryScalar.java


// Targeting ..\BaseBaseDate32Scalar.java


// Targeting ..\BaseBaseDate64Scalar.java


// Targeting ..\BaseDurationScalar.java


// Targeting ..\BaseBaseDayTimeIntervalScalar.java


// Targeting ..\BaseBaseMonthIntervalType.java


// Targeting ..\BaseTimestampScalar.java


// Targeting ..\BaseBaseTime32Scalar.java


// Targeting ..\BaseBaseTime64Scalar.java


// Targeting ..\BaseDate32Scalar.java


// Targeting ..\BaseDate64Scalar.java


// Targeting ..\Date32Scalar.java


// Targeting ..\Date64Scalar.java


// Targeting ..\BaseTime32Scalar.java


// Targeting ..\BaseTime64Scalar.java


// Targeting ..\Time32Scalar.java


// Targeting ..\Time64Scalar.java


// Targeting ..\TimestampScalar.java


// Targeting ..\BaseDayTimeIntervalScalar.java


// Targeting ..\BaseMonthIntervalScalar.java


// Targeting ..\MonthIntervalScalar.java


// Targeting ..\DayTimeIntervalScalar.java


// Targeting ..\DurationScalar.java


// Targeting ..\Decimal128Scalar.java


// Targeting ..\BaseListScalar.java


// Targeting ..\ListScalar.java


// Targeting ..\LargeListScalar.java


// Targeting ..\MapScalar.java


// Targeting ..\FixedSizeListScalar.java


// Targeting ..\StructScalar.java


// Targeting ..\UnionScalar.java


// Targeting ..\SparseUnionScalar.java


// Targeting ..\DenseUnionScalar.java


// Targeting ..\DictionaryScalar.java


// Targeting ..\ExtensionScalar.java



/** \} */

@Namespace("arrow::internal") public static native @ByVal Status CheckBufferLength();

@Namespace("arrow::internal") public static native @ByVal Status CheckBufferLength(@Const FixedSizeBinaryType t,
                                      @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer b);

  // namespace internal

/** \defgroup scalar-factories Scalar factory functions
 * 
 *  \{
 <p>
 *  \brief Scalar factory for null scalars */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar MakeNullScalar(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

/** \brief Scalar factory for non-null scalars */

/** \brief Type-inferring scalar factory for non-null scalars
 * 
 *  Construct a Scalar instance with a DataType determined by the input C++ type.
 *  (for example Int8Scalar for a int8_t input).
 *  Only non-parametric primitive types and String are supported. */

@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar MakeScalar(@StdString String value);
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar MakeScalar(@StdString BytePointer value);

/** \} */

  // namespace arrow


// Parsed from arrow/visitor.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ArrayVisitor.java


// Targeting ..\TypeVisitor.java


// Targeting ..\ScalarVisitor.java



  // namespace arrow


// Parsed from arrow/array.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Kitchen-sink public API for arrow::Array data structures. C++ library code
// (especially header files) in Apache Arrow should use more specific headers
// unless it's a file that uses most or all Array types in which case using
// arrow/array.h is fine.

// #pragma once

// #include "arrow/array/array_base.h"       // IWYU pragma: keep
// #include "arrow/array/array_binary.h"     // IWYU pragma: keep
// #include "arrow/array/array_decimal.h"    // IWYU pragma: keep
// #include "arrow/array/array_dict.h"       // IWYU pragma: keep
// #include "arrow/array/array_nested.h"     // IWYU pragma: keep
// #include "arrow/array/array_primitive.h"  // IWYU pragma: keep
// #include "arrow/array/data.h"             // IWYU pragma: keep
// #include "arrow/array/util.h"             // IWYU pragma: keep


// Parsed from arrow/array/data.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <atomic>  // IWYU pragma: export
// #include <cstdint>
// #include <memory>
// #include <utility>
// #include <vector>

// #include "arrow/buffer.h"
// #include "arrow/result.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

// When slicing, we do not know the null count of the sliced range without
// doing some computation. To avoid doing this eagerly, we set the null count
// to -1 (any negative number will do). When Array::null_count is called the
// first time, the null count will be computed. See ARROW-33

///
///
///
///
///
///
///
///
@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kUnknownNullCount();
// Targeting ..\ArrayData.java



/** Construct a zero-copy view of this ArrayData with the given type.
 * 
 *  This method checks if the types are layout-compatible.
 *  Nested types are traversed in depth-first order. Data buffers must have
 *  the same item sizes, even though the logical types may be different.
 *  An error is returned if the types are not layout-compatible. */
@Namespace("arrow::internal") public static native @ByVal ArrayDataResult GetArrayView(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data,
                                                @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

  // namespace internal
  // namespace arrow


// Parsed from arrow/array/util.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <vector>

// #include "arrow/array/data.h"
// #include "arrow/compare.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

/** \brief Create a strongly-typed Array instance from generic ArrayData
 *  @param data [in] the array contents
 *  @return the resulting Array instance */
@Namespace("arrow") public static native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array MakeArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data);

/** \brief Create a strongly-typed Array instance with all elements null
 *  @param type [in] the array type
 *  @param length [in] the array length
 *  @param pool [in] the memory pool to allocate memory from */
@Namespace("arrow") public static native @ByVal ArrayResult MakeArrayOfNull(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                               @Cast("int64_t") long length,
                                               MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal ArrayResult MakeArrayOfNull(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                               @Cast("int64_t") long length);

/** \brief Create an Array instance whose slots are the given scalar
 *  @param scalar [in] the value with which to fill the array
 *  @param length [in] the array length
 *  @param pool [in] the memory pool to allocate memory from */
@Namespace("arrow") public static native @ByVal ArrayResult MakeArrayFromScalar(
    @Const @ByRef Scalar scalar, @Cast("int64_t") long length, MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal ArrayResult MakeArrayFromScalar(
    @Const @ByRef Scalar scalar, @Cast("int64_t") long length);

/** Given a number of ArrayVectors, treat each ArrayVector as the
 *  chunks of a chunked array.  Then rechunk each ArrayVector such that
 *  all ArrayVectors are chunked identically.  It is mandatory that
 *  all ArrayVectors contain the same total number of elements. */
@Namespace("arrow::internal") public static native @ByVal ArrayVectorVector RechunkArraysConsistently(@Const @ByRef ArrayVectorVector arg0);

  // namespace internal
  // namespace arrow


// Parsed from arrow/array/array_base.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/array/data.h"
// #include "arrow/buffer.h"
// #include "arrow/compare.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/bit_util.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// #include "arrow/visitor.h"
// Targeting ..\Array.java



@Namespace("arrow") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef Array x);
// Targeting ..\FlatArray.java


// Targeting ..\PrimitiveArray.java


// Targeting ..\NullArray.java



  // namespace arrow


// Parsed from arrow/array/array_nested.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Array accessor classes for List, LargeList, FixedSizeList, Map, Struct, and
// Union

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/array/array_base.h"
// #include "arrow/array/data.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

// ----------------------------------------------------------------------
// ListArray

// Private helper for ListArray::SetData.
// Unfortunately, trying to define BaseListArray::SetData outside of this header
// doesn't play well with MSVC.


// Targeting ..\BaseListArray.java


// Targeting ..\BaseLargeListArray.java


// Targeting ..\ListArray.java


// Targeting ..\LargeListArray.java


// Targeting ..\MapArray.java


// Targeting ..\FixedSizeListArray.java


// Targeting ..\StructArray.java


// Targeting ..\UnionArray.java


// Targeting ..\SparseUnionArray.java


// Targeting ..\DenseUnionArray.java



  // namespace arrow


// Parsed from arrow/array/array_primitive.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Array accessor types for primitive/C-type-based arrays, such as numbers,
// boolean, and temporal types.

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/array/array_base.h"
// #include "arrow/array/data.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"  // IWYU pragma: export
// #include "arrow/type_traits.h"
// #include "arrow/util/bit_util.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\Int8Array.java


// Targeting ..\Int16Array.java


// Targeting ..\Int32Array.java


// Targeting ..\Int64Array.java


// Targeting ..\UInt8Array.java


// Targeting ..\UInt16Array.java


// Targeting ..\UInt32Array.java


// Targeting ..\UInt64Array.java


// Targeting ..\HalfFloatArray.java


// Targeting ..\FloatArray.java


// Targeting ..\DoubleArray.java


// Targeting ..\Date64Array.java


// Targeting ..\Date32Array.java


// Targeting ..\Time32Array.java


// Targeting ..\Time64Array.java


// Targeting ..\TimestampArray.java


// Targeting ..\MonthIntervalArray.java


// Targeting ..\DurationArray.java


// Targeting ..\BooleanArray.java


// Targeting ..\DayTimeIntervalArray.java



  // namespace arrow


// Parsed from arrow/array/concatenate.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

/** \brief Concatenate arrays
 * 
 *  @param arrays [in] a vector of arrays to be concatenated
 *  @param pool [in] memory to store the result will be allocated from this memory pool
 *  @return the concatenated array */
@Namespace("arrow") public static native @ByVal ArrayResult Concatenate(@Const @ByRef ArrayVector arrays,
                                           MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal ArrayResult Concatenate(@Const @ByRef ArrayVector arrays);

@Namespace("arrow") public static native @Deprecated @ByVal Status Concatenate(@Const @ByRef ArrayVector arrays, MemoryPool pool,
                   @SharedPtr Array out);

  // namespace arrow


// Parsed from arrow/array/builder_base.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>  // IWYU pragma: keep
// #include <cstdint>
// #include <limits>
// #include <memory>
// #include <utility>
// #include <vector>

// #include "arrow/array/array_base.h"
// #include "arrow/array/array_primitive.h"
// #include "arrow/buffer.h"
// #include "arrow/buffer_builder.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kMinBuilderCapacity();

///
///
@Namespace("arrow") @MemberGetter public static native @Cast("const int64_t") long kListMaximumElements();
// Targeting ..\ArrayBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_binary.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <array>
// #include <cstddef>
// #include <cstdint>
// #include <cstring>
// #include <limits>
// #include <memory>
// #include <numeric>
// #include <string>
// #include <vector>

// #include "arrow/array/array_base.h"
// #include "arrow/array/array_binary.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/array/data.h"
// #include "arrow/buffer.h"
// #include "arrow/buffer_builder.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"  // IWYU pragma: export
// #include "arrow/util/visibility.h"
// Targeting ..\BaseBinaryBuilder.java


// Targeting ..\BaseLargeBinaryBuilder.java


// Targeting ..\BinaryBuilder.java


// Targeting ..\StringBuilder.java


// Targeting ..\LargeBinaryBuilder.java


// Targeting ..\LargeStringBuilder.java


// Targeting ..\FixedSizeBinaryBuilder.java


// Targeting ..\ChunkedBinaryBuilder.java


// Targeting ..\ChunkedStringBuilder.java



  // namespace internal

  // namespace arrow


// Parsed from arrow/array/builder_decimal.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/array/array_decimal.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/array/builder_binary.h"
// #include "arrow/array/data.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/visibility.h"
// Targeting ..\Decimal128Builder.java



  // namespace arrow


// Parsed from arrow/array/builder_dict.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <cstdint>
// #include <memory>
// #include <type_traits>

// #include "arrow/array/array_base.h"
// #include "arrow/array/array_binary.h"
// #include "arrow/array/builder_adaptive.h"   // IWYU pragma: export
// #include "arrow/array/builder_base.h"       // IWYU pragma: export
// #include "arrow/array/builder_primitive.h"  // IWYU pragma: export
// #include "arrow/array/data.h"
// #include "arrow/array/util.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

// ----------------------------------------------------------------------
// Dictionary builder
// Targeting ..\DictionaryMemoTable.java



/** \brief Array builder for created encoded DictionaryArray from
 *  dense array
 * 
 *  Unlike other builders, dictionary builder does not completely
 *  reset the state on Finish calls. */

  // namespace internal

/** \brief A DictionaryArray builder that uses AdaptiveIntBuilder to return the
 *  smallest index size that can accommodate the dictionary indices */

/** \brief A DictionaryArray builder that always returns int32 dictionary
 *  indices so that data cast to dictionary form will have a consistent index
 *  type, e.g. for creating a ChunkedArray */

// ----------------------------------------------------------------------
// Binary / Unicode builders
// (compatibility aliases; those used to be derived classes with additional
//  Append() overloads, but they have been folded into DictionaryBuilderBase)

  // namespace arrow


// Parsed from arrow/array/builder_nested.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <limits>
// #include <memory>
// #include <utility>
// #include <vector>

// #include "arrow/array/array_nested.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/array/data.h"
// #include "arrow/buffer.h"
// #include "arrow/buffer_builder.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\BaseListBuilder.java


// Targeting ..\BaseLargeListBuilder.java


// Targeting ..\ListBuilder.java


// Targeting ..\LargeListBuilder.java


// Targeting ..\MapBuilder.java


// Targeting ..\FixedSizeListBuilder.java


// Targeting ..\StructBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_primitive.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <algorithm>
// #include <memory>
// #include <vector>

// #include "arrow/array/builder_base.h"
// #include "arrow/array/data.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// Targeting ..\NullBuilder.java


// Targeting ..\Int8Builder.java


// Targeting ..\Int16Builder.java


// Targeting ..\Int32Builder.java


// Targeting ..\Int64Builder.java


// Targeting ..\UInt8Builder.java


// Targeting ..\UInt16Builder.java


// Targeting ..\UInt32Builder.java


// Targeting ..\UInt64Builder.java


// Targeting ..\HalfFloatBuilder.java


// Targeting ..\FloatBuilder.java


// Targeting ..\DoubleBuilder.java


// Targeting ..\DayTimeIntervalBuilder.java



// Builders
// Targeting ..\BooleanBuilder.java



  // namespace arrow


// Parsed from arrow/array/builder_time.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Contains declarations of time related Arrow builder types.

// #pragma once

// #include <memory>

// #include "arrow/array/builder_base.h"
// #include "arrow/array/builder_primitive.h"

// TODO(ARROW-7938): this class is untested

  // namespace arrow


// Parsed from arrow/array/builder_union.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/array/array_nested.h"
// #include "arrow/array/builder_base.h"
// #include "arrow/array/data.h"
// #include "arrow/buffer_builder.h"
// #include "arrow/memory_pool.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/visibility.h"
// Targeting ..\BasicUnionBuilder.java


// Targeting ..\DenseUnionBuilder.java


// Targeting ..\SparseUnionBuilder.java



  // namespace arrow


// Parsed from arrow/chunked_array.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ChunkedArray.java


// Targeting ..\MultipleChunkIterator.java



/** \brief Evaluate binary function on two ChunkedArray objects having possibly
 *  different chunk layouts. The passed binary function / functor should have
 *  the following signature.
 * 
 *     Status(const Array&, const Array&, int64_t)
 * 
 *  The third argument is the absolute position relative to the start of each
 *  ChunkedArray. The function is executed against each contiguous pair of
 *  array segments, slicing if necessary.
 * 
 *  For example, if two arrays have chunk sizes
 * 
 *    left: [10, 10, 20]
 *    right: [15, 10, 15]
 * 
 *  Then the following invocations take place (pseudocode)
 * 
 *    func(left.chunk[0][0:10], right.chunk[0][0:10], 0)
 *    func(left.chunk[1][0:5], right.chunk[0][10:15], 10)
 *    func(left.chunk[1][5:10], right.chunk[1][0:5], 15)
 *    func(left.chunk[2][0:5], right.chunk[1][5:10], 20)
 *    func(left.chunk[2][5:20], right.chunk[2][:], 25) */

  // namespace internal
  // namespace arrow


// Parsed from arrow/config.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <string>

// #include "arrow/util/config.h"  // IWYU pragma: export
// #include "arrow/util/visibility.h"
// Targeting ..\BuildInfo.java



/** \brief Get runtime build info.
 * 
 *  The returned values correspond to exact loaded version of the Arrow library,
 *  rather than the values frozen at application compile-time through the {@code ARROW_*}
 *  preprocessor definitions. */
@Namespace("arrow") public static native @Const @ByRef BuildInfo GetBuildInfo();

  // namespace arrow


// Parsed from arrow/datum.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <type_traits>
// #include <utility>
// #include <vector>

// #include "arrow/array/data.h"
// #include "arrow/scalar.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/variant.h"  // IWYU pragma: export
// #include "arrow/util/visibility.h"
// Targeting ..\ValueDescr.java



/** \brief For use with scalar functions, returns the broadcasted Value::Shape
 *  given a vector of value descriptors. Return SCALAR unless any value is
 *  ARRAY */
@Namespace("arrow") public static native ValueDescr.Shape GetBroadcastShape(@Const @ByRef ValueDescrVector args);
// Targeting ..\Datum.java



  // namespace arrow


// Parsed from arrow/builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/array/builder_adaptive.h"   // IWYU pragma: keep
// #include "arrow/array/builder_base.h"       // IWYU pragma: keep
// #include "arrow/array/builder_binary.h"     // IWYU pragma: keep
// #include "arrow/array/builder_decimal.h"    // IWYU pragma: keep
// #include "arrow/array/builder_dict.h"       // IWYU pragma: keep
// #include "arrow/array/builder_nested.h"     // IWYU pragma: keep
// #include "arrow/array/builder_primitive.h"  // IWYU pragma: keep
// #include "arrow/array/builder_time.h"       // IWYU pragma: keep
// #include "arrow/array/builder_union.h"      // IWYU pragma: keep
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"

/** \brief Construct an empty ArrayBuilder corresponding to the data
 *  type
 *  @param pool [in] the MemoryPool to use for allocations
 *  @param type [in] an instance of DictionaryType
 *  @param out [out] the created ArrayBuilder */
@Namespace("arrow") public static native @ByVal Status MakeBuilder(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                   @UniquePtr ArrayBuilder out);

/** \brief Construct an empty DictionaryBuilder initialized optionally
 *  with a pre-existing dictionary
 *  @param pool [in] the MemoryPool to use for allocations
 *  @param type [in] an instance of DictionaryType
 *  @param dictionary [in] the initial dictionary, if any. May be nullptr
 *  @param out [out] the created ArrayBuilder */
@Namespace("arrow") public static native @ByVal Status MakeDictionaryBuilder(MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                             @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                             @UniquePtr ArrayBuilder out);

  // namespace arrow


// Parsed from arrow/extension_type.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

/** User-defined extension types. EXPERIMENTAL in 0.13.0
 *  @since 0.13.0 */

// #pragma once

// #include <memory>
// #include <string>

// #include "arrow/array/array_base.h"
// #include "arrow/array/data.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ExtensionType.java


// Targeting ..\ExtensionArray.java


// Targeting ..\ExtensionTypeRegistry.java



/** \brief Register an extension type globally. The name returned by the type's
 *  extension_name() method should be unique. This method is thread-safe
 *  @param type [in] an instance of the extension type
 *  @return Status */
@Namespace("arrow") public static native @ByVal Status RegisterExtensionType(@SharedPtr ExtensionType type);

/** \brief Delete an extension type from the global registry. This method is
 *  thread-safe
 *  @param type_name [in] the unique name of a registered extension type
 *  @return Status error if the type name is unknown */
@Namespace("arrow") public static native @ByVal Status UnregisterExtensionType(@StdString String type_name);
@Namespace("arrow") public static native @ByVal Status UnregisterExtensionType(@StdString BytePointer type_name);

/** \brief Retrieve an extension type from the global registry. Returns nullptr
 *  if not found. This method is thread-safe
 *  @return the globally-registered extension type */
@Namespace("arrow") public static native @SharedPtr ExtensionType GetExtensionType(@StdString String type_name);
@Namespace("arrow") public static native @SharedPtr ExtensionType GetExtensionType(@StdString BytePointer type_name);

@Namespace("arrow") @MemberGetter public static native byte kExtensionTypeKeyName(int i);
@Namespace("arrow") @MemberGetter public static native String kExtensionTypeKeyName();
@Namespace("arrow") @MemberGetter public static native byte kExtensionMetadataKeyName(int i);
@Namespace("arrow") @MemberGetter public static native String kExtensionMetadataKeyName();

  // namespace arrow


// Parsed from arrow/pretty_print.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <iosfwd>
// #include <string>

// #include "arrow/util/visibility.h"
// Targeting ..\PrettyPrintOptions.java



/** \brief Print human-readable representation of RecordBatch */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef RecordBatch batch, int indent, @Cast("std::ostream*") Pointer sink);

@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef RecordBatch batch, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Table */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Table table, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Array */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Array arr, int indent, @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Array */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Array arr, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of Array */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Array arr, @Const @ByRef PrettyPrintOptions options,
                   @StdString @Cast({"char*", "std::string*"}) BytePointer result);

/** \brief Print human-readable representation of ChunkedArray */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef ChunkedArray chunked_arr, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

/** \brief Print human-readable representation of ChunkedArray */
@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef ChunkedArray chunked_arr, @Const @ByRef PrettyPrintOptions options,
                   @StdString @Cast({"char*", "std::string*"}) BytePointer result);

@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Schema schema, @Const @ByRef PrettyPrintOptions options,
                   @Cast("std::ostream*") Pointer sink);

@Namespace("arrow") public static native @ByVal Status PrettyPrint(@Const @ByRef Schema schema, @Const @ByRef PrettyPrintOptions options,
                   @StdString @Cast({"char*", "std::string*"}) BytePointer result);

@Namespace("arrow") public static native @ByVal Status DebugPrint(@Const @ByRef Array arr, int indent);

  // namespace arrow


// Parsed from arrow/record_batch.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\RecordBatch.java


// Targeting ..\RecordBatchReader.java



  // namespace arrow


// Parsed from arrow/table.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/chunked_array.h"  // IWYU pragma: keep
// #include "arrow/record_batch.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\Table.java


// Targeting ..\TableBatchReader.java


// Targeting ..\ConcatenateTablesOptions.java



/** \brief Construct table from multiple input tables. */

///
///
@Namespace("arrow") public static native @ByVal TableResult ConcatenateTables(
    @Const @ByRef TableVector tables,
    @ByVal(nullValue = "arrow::ConcatenateTablesOptions::Defaults()") ConcatenateTablesOptions options,
    MemoryPool memory_pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal TableResult ConcatenateTables(
    @Const @ByRef TableVector tables);

/** \brief Promotes a table to conform to the given schema.
 * 
 *  If a field in the schema does not have a corresponding column in the
 *  table, a column of nulls will be added to the resulting table.
 *  If the corresponding column is of type Null, it will be promoted to
 *  the type specified by schema, with null values filled.
 *  Returns an error:
 *  - if the corresponding column's type is not compatible with the
 *    schema.
 *  - if there is a column in the table that does not exist in the schema.
 * 
 *  @param table [in] the input Table
 *  @param schema [in] the target schema to promote to
 *  @param pool [in] The memory pool to be used if null-filled arrays need to
 *  be created. */
@Namespace("arrow") public static native @ByVal TableResult PromoteTableToSchema(
    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table table, @Const @SharedPtr @ByRef Schema schema,
    MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow") public static native @ByVal TableResult PromoteTableToSchema(
    @SharedPtr @Cast({"", "std::shared_ptr<arrow::Table>"}) Table table, @Const @SharedPtr @ByRef Schema schema);

  // namespace arrow


// Parsed from arrow/table_builder.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <vector>

// #include "arrow/array/builder_base.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\RecordBatchBuilder.java



  // namespace arrow


// Parsed from arrow/tensor.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/buffer.h"
// #include "arrow/compare.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/type_traits.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow") public static native @Cast("bool") boolean is_tensor_supported(@Cast("arrow::Type::type") int type_id);

@Namespace("arrow::internal") public static native void ComputeRowMajorStrides(@Const @ByRef FixedWidthType type, @Cast("int64_t*") @StdVector LongPointer shape,
                            @Cast("int64_t*") @StdVector LongPointer strides);
@Namespace("arrow::internal") public static native void ComputeRowMajorStrides(@Const @ByRef FixedWidthType type, @Cast("int64_t*") @StdVector LongBuffer shape,
                            @Cast("int64_t*") @StdVector LongBuffer strides);
@Namespace("arrow::internal") public static native void ComputeRowMajorStrides(@Const @ByRef FixedWidthType type, @Cast("int64_t*") @StdVector long[] shape,
                            @Cast("int64_t*") @StdVector long[] strides);

@Namespace("arrow::internal") public static native @Cast("bool") boolean IsTensorStridesContiguous(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                               @Cast("int64_t*") @StdVector LongPointer shape,
                               @Cast("int64_t*") @StdVector LongPointer strides);
@Namespace("arrow::internal") public static native @Cast("bool") boolean IsTensorStridesContiguous(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                               @Cast("int64_t*") @StdVector LongBuffer shape,
                               @Cast("int64_t*") @StdVector LongBuffer strides);
@Namespace("arrow::internal") public static native @Cast("bool") boolean IsTensorStridesContiguous(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                               @Cast("int64_t*") @StdVector long[] shape,
                               @Cast("int64_t*") @StdVector long[] strides);

@Namespace("arrow::internal") public static native @ByVal Status ValidateTensorParameters(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                @SharedPtr ArrowBuffer data,
                                @Cast("int64_t*") @StdVector LongPointer shape,
                                @Cast("int64_t*") @StdVector LongPointer strides,
                                @Const @ByRef StringVector dim_names);
@Namespace("arrow::internal") public static native @ByVal Status ValidateTensorParameters(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                @SharedPtr ArrowBuffer data,
                                @Cast("int64_t*") @StdVector LongBuffer shape,
                                @Cast("int64_t*") @StdVector LongBuffer strides,
                                @Const @ByRef StringVector dim_names);
@Namespace("arrow::internal") public static native @ByVal Status ValidateTensorParameters(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                                @SharedPtr ArrowBuffer data,
                                @Cast("int64_t*") @StdVector long[] shape,
                                @Cast("int64_t*") @StdVector long[] strides,
                                @Const @ByRef StringVector dim_names);


// Targeting ..\Tensor.java



  // namespace arrow


// Parsed from arrow/io/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/io/buffered.h"
// #include "arrow/io/compressed.h"
// #include "arrow/io/file.h"
// #include "arrow/io/hdfs.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/io/memory.h"


// Parsed from arrow/io/caching.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"
// Targeting ..\CacheOptions.java


// Targeting ..\ReadRangeCache.java



  // namespace internal
  // namespace io
  // namespace arrow


// Parsed from arrow/io/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once
// Targeting ..\FileMode.java


// Targeting ..\BufferInputStream.java



  // namespace io
  // namespace arrow


// Parsed from arrow/io/interfaces.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/io/type_fwd.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/type_fwd.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ReadRange.java


// Targeting ..\AsyncContext.java


// Targeting ..\FileInterface.java


// Targeting ..\Seekable.java


// Targeting ..\Writable.java


// Targeting ..\Readable.java


// Targeting ..\OutputStream.java


// Targeting ..\InputStream.java


// Targeting ..\RandomAccessFile.java


// Targeting ..\WritableFile.java


// Targeting ..\ReadWriteFileInterface.java



/** \brief Return an iterator on an input stream
 * 
 *  The iterator yields a fixed-size block on each Next() call, except the
 *  last block in the stream which may be smaller.
 *  Once the end of stream is reached, Next() returns nullptr
 *  (unlike InputStream::Read() which returns an empty buffer). */
@Namespace("arrow::io") public static native @ByVal BufferIteratorResult MakeInputStreamIterator(
    @SharedPtr InputStream stream, @Cast("int64_t") long block_size);

  // namespace io
  // namespace arrow


// Parsed from arrow/io/concurrency.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/io/interfaces.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/checked_cast.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\SharedExclusiveCheckerSharedLockGuard.java


// Targeting ..\SharedExclusiveCheckerExclusiveLockGuard.java


// Targeting ..\SharedExclusiveChecker.java


// Targeting ..\BufferedInputStreamConcurrencyWrapper.java


// Targeting ..\CompressedInputStreamConcurrencyWrapper.java


// Targeting ..\ReadableFileRandomAccessFileConcurrencyWrapper.java


// Targeting ..\BufferReaderRandomAccessFileConcurrencyWrapper.java



  // namespace internal
  // namespace io
  // namespace arrow


// Parsed from arrow/io/buffered.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Buffered stream implementations

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ..\BufferedOutputStream.java


// Targeting ..\BufferedInputStream.java



  // namespace io
  // namespace arrow


// Parsed from arrow/io/compressed.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Compressed stream implementations

// #pragma once

// #include <memory>
// #include <string>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"


// Targeting ..\CompressedOutputStream.java


// Targeting ..\CompressedInputStream.java



  // namespace io
  // namespace arrow


// Parsed from arrow/io/file.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// IO interface implementations for OS files

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"
// Targeting ..\FileOutputStream.java


// Targeting ..\ReadableFile.java


// Targeting ..\MemoryMappedFile.java



  // namespace io
  // namespace arrow


// Parsed from arrow/io/hdfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <vector>

// #include "arrow/io/interfaces.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ObjectType.java


// Targeting ..\FileStatistics.java


// Targeting ..\IOFileSystem.java


// Targeting ..\HdfsPathInfo.java


// Targeting ..\HdfsConnectionConfig.java


// Targeting ..\HadoopFileSystem.java


// Targeting ..\HdfsReadableFile.java


// Targeting ..\HdfsOutputStream.java



@Namespace("arrow::io") public static native @ByVal Status HaveLibHdfs();

  // namespace io
  // namespace arrow


// Parsed from arrow/io/memory.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Public API for different memory sharing / IO mechanisms

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <vector>

// #include "arrow/io/concurrency.h"
// #include "arrow/io/interfaces.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"
// Targeting ..\BufferOutputStream.java


// Targeting ..\MockOutputStream.java


// Targeting ..\FixedSizeBufferWriter.java


// Targeting ..\BufferReader.java



  // namespace io
  // namespace arrow


// Parsed from arrow/io/slow.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Slow stream implementations, mainly for testing and benchmarking

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <utility>

// #include "arrow/io/interfaces.h"
// #include "arrow/util/visibility.h"
// Targeting ..\LatencyGenerator.java


// Targeting ..\InputStreamSlowInputStreamBase.java


// Targeting ..\RandomAccessFileSlowInputStreamBase.java


// Targeting ..\SlowInputStream.java


// Targeting ..\SlowRandomAccessFile.java



  // namespace io
  // namespace arrow


// Parsed from arrow/filesystem/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/filesystem/filesystem.h"  // IWYU pragma: export
// #include "arrow/filesystem/hdfs.h"        // IWYU pragma: export
// #include "arrow/filesystem/localfs.h"     // IWYU pragma: export
// #include "arrow/filesystem/mockfs.h"      // IWYU pragma: export
// #include "arrow/filesystem/s3fs.h"        // IWYU pragma: export


// Parsed from arrow/filesystem/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

/** \brief FileSystem entry type */
@Namespace("arrow::fs") public enum FileType {
  /** Entry is not found */
  
///
  NotFound((byte)0),
  /** Entry exists but its type is unknown
   * 
   *  This can designate a special file such as a Unix socket or character
   *  device, or Windows NUL / CON / ... */
  Unknown((byte)1),
  /** Entry is a regular file */
  File((byte)2),
  /** Entry is a directory */
  Directory((byte)3);

    public final byte value;
    private FileType(byte v) { this.value = v; }
    private FileType(FileType e) { this.value = e.value; }
    public FileType intern() { for (FileType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\S3FileSystem.java


// #endif

  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/filesystem.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <chrono>
// #include <cstdint>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/filesystem/type_fwd.h"
// #include "arrow/io/type_fwd.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// #include "arrow/util/windows_fixup.h"

// A system clock time point expressed as a 64-bit (or more) number of
// nanoseconds since the epoch.

@Namespace("arrow::fs") public static native @StdString String ToString(FileType arg0);
@Namespace("arrow::fs") public static native @StdString BytePointer ToString(@Cast("arrow::fs::FileType") byte arg0);

@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, FileType arg1);
@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Cast("arrow::fs::FileType") byte arg1);

@Namespace("arrow::fs") @MemberGetter public static native @Cast("const int64_t") long kNoSize();
public static final long kNoSize = kNoSize();
@Namespace("arrow::fs") @MemberGetter public static native @ByRef @Cast("const arrow::fs::TimePoint*") Pointer kNoTime();
// Targeting ..\FileInfo.java



@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef FileInfo arg1);
// Targeting ..\FileSelector.java


// Targeting ..\FileSystem.java


// Targeting ..\SubTreeFileSystem.java


// Targeting ..\SlowFileSystem.java



/** \defgroup filesystem-factories Functions for creating FileSystem instances
 * 
 *  \{
 <p>
 *  \brief Create a new FileSystem by URI
 * 
 *  Recognized schemes are "file", "mock", "hdfs" and "s3fs".
 * 
 *  @param uri [in] a URI-based path, ex: file:///some/local/path
 *  @param out_path [out] (optional) Path inside the filesystem.
 *  @return out_fs FileSystem instance. */


/** \brief Create a new FileSystem by URI
 * 
 *  Same as FileSystemFromUri, but in addition also recognize non-URIs
 *  and treat them as local filesystem paths.  Only absolute local filesystem
 *  paths are allowed. */
@Namespace("arrow::fs") public static native @ByVal FileSystemResult FileSystemFromUriOrPath(
    @StdString String uri, @StdString @Cast({"char*", "std::string*"}) BytePointer out_path/*=nullptr*/);
@Namespace("arrow::fs") public static native @ByVal FileSystemResult FileSystemFromUriOrPath(
    @StdString String uri);
@Namespace("arrow::fs") public static native @ByVal FileSystemResult FileSystemFromUriOrPath(
    @StdString BytePointer uri, @StdString @Cast({"char*", "std::string*"}) BytePointer out_path/*=nullptr*/);
@Namespace("arrow::fs") public static native @ByVal FileSystemResult FileSystemFromUriOrPath(
    @StdString BytePointer uri);
// Targeting ..\FileSystemGlobalOptions.java



/** Experimental: optional global initialization routine
 * 
 *  This is for environments (such as manylinux) where the path
 *  to TLS CA certificates needs to be configured at runtime. */
@Namespace("arrow::fs") public static native @ByVal Status Initialize(@Const @ByRef FileSystemGlobalOptions options);

  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/hdfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/filesystem/filesystem.h"
// #include "arrow/io/hdfs.h"
// #include "arrow/util/uri.h"
// Targeting ..\HdfsOptions.java



/** HDFS-backed FileSystem implementation.
 * 
 *  implementation notes:
 *  - This is a wrapper of arrow/io/hdfs, so we can use FileSystem API to handle hdfs. */

  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/localfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/filesystem/filesystem.h"
// Targeting ..\Uri.java




// Targeting ..\LocalFileSystemOptions.java


// Targeting ..\LocalFileSystem.java



// Return whether the string is detected as a local absolute path.
@Namespace("arrow::fs::internal") public static native @Cast("bool") boolean DetectAbsolutePath(@StdString String s);
@Namespace("arrow::fs::internal") public static native @Cast("bool") boolean DetectAbsolutePath(@StdString BytePointer s);

  // namespace internal

  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/mockfs.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/filesystem/filesystem.h"
// #include "arrow/util/windows_fixup.h"
// Targeting ..\MockDirInfo.java


// Targeting ..\MockFileInfo.java


// Targeting ..\MockFileSystem.java



  // namespace internal
  // namespace fs
  // namespace arrow


// Parsed from arrow/filesystem/path_forest.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/filesystem/filesystem.h"

// #include <algorithm>
// #include <iosfwd>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/compare.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/sort.h"
// Targeting ..\PathForest.java



@Namespace("arrow::fs") public static native @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer os, @Const @ByRef PathForest tree);

  // namespace fs
  // namespace arrow


// Parsed from arrow/csv/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/csv/options.h"
// #include "arrow/csv/reader.h"


// Parsed from arrow/csv/options.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <unordered_map>
// #include <vector>

// #include "arrow/util/visibility.h"
// Targeting ..\TimestampParser.java



// Silly workaround for https://github.com/michaeljones/breathe/issues/453
@Namespace("arrow::csv") @MemberGetter public static native byte kDefaultEscapeChar();
// Targeting ..\CsvParseOptions.java


// Targeting ..\ConvertOptions.java


// Targeting ..\ReadOptions.java



  // namespace csv
  // namespace arrow


// Parsed from arrow/csv/reader.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/csv/options.h"  // IWYU pragma: keep
// #include "arrow/record_batch.h"
// #include "arrow/result.h"
// #include "arrow/type.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/visibility.h"
  // namespace io
// Targeting ..\TableReader.java


// Targeting ..\StreamingReader.java



  // namespace csv
  // namespace arrow


// Parsed from arrow/json/options.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <memory>

// #include "arrow/util/visibility.h"

@Namespace("arrow::json") public enum UnexpectedFieldBehavior {
  /** Unexpected JSON fields are ignored */
  Ignore((byte)0),
  /** Unexpected JSON fields error out */
  Error((byte)1),
  /** Unexpected JSON fields are type-inferred and included in the output */
  InferType((byte)2);

    public final byte value;
    private UnexpectedFieldBehavior(byte v) { this.value = v; }
    private UnexpectedFieldBehavior(UnexpectedFieldBehavior e) { this.value = e.value; }
    public UnexpectedFieldBehavior intern() { for (UnexpectedFieldBehavior e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\JsonParseOptions.java



  // namespace json
  // namespace arrow


// Parsed from arrow/json/reader.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/json/options.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
  // namespace io

/** A class that reads an entire JSON file into a Arrow Table
 * 
 *  The file is expected to consist of individual line-separated JSON objects */

@Namespace("arrow::json") public static native @ByVal RecordBatchResult ParseOne(@ByVal JsonParseOptions options,
                                                           @SharedPtr ArrowBuffer json);

  // namespace json
  // namespace arrow


// Parsed from arrow/compute/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// NOTE: API is EXPERIMENTAL and will change without going through a
// deprecation cycle

// #pragma once

/** \defgroup compute-concrete-options Concrete option classes for compute functions
 *  \{
 *  \} */

// #include "arrow/compute/api_aggregate.h"  // IWYU pragma: export
// #include "arrow/compute/api_scalar.h"     // IWYU pragma: export
// #include "arrow/compute/api_vector.h"     // IWYU pragma: export
// #include "arrow/compute/cast.h"           // IWYU pragma: export
// #include "arrow/compute/exec.h"           // IWYU pragma: export
// #include "arrow/compute/function.h"       // IWYU pragma: export
// #include "arrow/compute/kernel.h"         // IWYU pragma: export
// #include "arrow/compute/registry.h"       // IWYU pragma: export
// #include "arrow/datum.h"                  // IWYU pragma: export


// Parsed from arrow/compute/api_aggregate.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Eager evaluation convenience APIs for invoking common functions, including
// necessary memory allocations

// #pragma once

// #include "arrow/compute/function.h"
// #include "arrow/datum.h"
// #include "arrow/result.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\CountOptions.java


// Targeting ..\MinMaxOptions.java



/** \}
 <p>
 *  \brief Count non-null (or null) values in an array.
 * 
 *  @param options [in] counting options, see CountOptions for more information
 *  @param datum [in] to count
 *  @param ctx [in] the function execution context, optional
 *  @return out resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Count(@Const @ByRef Datum datum, @ByVal(nullValue = "arrow::compute::CountOptions::Defaults()") CountOptions options,
                    ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Count(@Const @ByRef Datum datum);

/** \brief Compute the mean of a numeric array.
 * 
 *  @param value [in] datum to compute the mean, expecting Array
 *  @param ctx [in] the function execution context, optional
 *  @return datum of the computed mean as a DoubleScalar
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Mean(@Const @ByRef Datum value, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Mean(@Const @ByRef Datum value);

/** \brief Sum values of a numeric array.
 * 
 *  @param value [in] datum to sum, expecting Array or ChunkedArray
 *  @param ctx [in] the function execution context, optional
 *  @return datum of the computed sum as a Scalar
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Sum(@Const @ByRef Datum value, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Sum(@Const @ByRef Datum value);

/** \brief Calculate the min / max of a numeric array
 * 
 *  This function returns both the min and max as a struct scalar, with type
 *  struct<min: T, max: T>, where T is ht einput type
 * 
 *  @param value [in] input datum, expecting Array or ChunkedArray
 *  @param options [in] see MinMaxOptions for more information
 *  @param ctx [in] the function execution context, optional
 *  @return resulting datum as a struct<min: T, max: T> scalar
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */


/** \brief Calculate the min / max of a numeric array.
 * 
 *  This function returns both the min and max as a collection. The resulting
 *  datum thus consists of two scalar datums: {Datum(min), Datum(max)}
 * 
 *  @param array [in] input array
 *  @param options [in] see MinMaxOptions for more information
 *  @param ctx [in] the function execution context, optional
 *  @return resulting datum containing a {min, max} collection
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */


  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/api_scalar.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Eager evaluation convenience APIs for invoking common functions, including
// necessary memory allocations

// #pragma once

// #include <string>
// #include <utility>

// #include "arrow/compute/exec.h"  // IWYU pragma: keep
// #include "arrow/compute/function.h"
// #include "arrow/datum.h"
// #include "arrow/result.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\ArithmeticOptions.java


// Targeting ..\MatchSubstringOptions.java


// Targeting ..\SetLookupOptions.java


// Targeting ..\StrptimeOptions.java



@Namespace("arrow::compute") public enum CompareOperator {
  EQUAL((byte)0),
  NOT_EQUAL((byte)1),
  GREATER((byte)2),
  GREATER_EQUAL((byte)3),
  LESS((byte)4),
  LESS_EQUAL((byte)5);

    public final byte value;
    private CompareOperator(byte v) { this.value = v; }
    private CompareOperator(CompareOperator e) { this.value = e.value; }
    public CompareOperator intern() { for (CompareOperator e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\CompareOptions.java



/** \}
 <p>
 *  \brief Add two values together. Array values must be the same length. If
 *  either addend is null the result will be null.
 * 
 *  @param left [in] the first addend
 *  @param right [in] the second addend
 *  @param options [in] arithmetic options (overflow handling), optional
 *  @param ctx [in] the function execution context, optional
 *  @return the elementwise sum */

///
@Namespace("arrow::compute") public static native @ByVal DatumResult Add(@Const @ByRef Datum left, @Const @ByRef Datum right,
                  @ByVal(nullValue = "arrow::compute::ArithmeticOptions()") ArithmeticOptions options,
                  ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Add(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Subtract two values. Array values must be the same length. If the
 *  minuend or subtrahend is null the result will be null.
 * 
 *  @param left [in] the value subtracted from (minuend)
 *  @param right [in] the value by which the minuend is reduced (subtrahend)
 *  @param options [in] arithmetic options (overflow handling), optional
 *  @param ctx [in] the function execution context, optional
 *  @return the elementwise difference */

///
@Namespace("arrow::compute") public static native @ByVal DatumResult Subtract(@Const @ByRef Datum left, @Const @ByRef Datum right,
                       @ByVal(nullValue = "arrow::compute::ArithmeticOptions()") ArithmeticOptions options,
                       ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Subtract(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Multiply two values. Array values must be the same length. If either
 *  factor is null the result will be null.
 * 
 *  @param left [in] the first factor
 *  @param right [in] the second factor
 *  @param options [in] arithmetic options (overflow handling), optional
 *  @param ctx [in] the function execution context, optional
 *  @return the elementwise product */

///
///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Multiply(@Const @ByRef Datum left, @Const @ByRef Datum right,
                       @ByVal(nullValue = "arrow::compute::ArithmeticOptions()") ArithmeticOptions options,
                       ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Multiply(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Compare a numeric array with a scalar.
 * 
 *  @param left [in] datum to compare, must be an Array
 *  @param right [in] datum to compare, must be a Scalar of the same type than
 *             left Datum.
 *  @param options [in] compare options
 *  @param ctx [in] the function execution context, optional
 *  @return resulting datum
 * 
 *  Note on floating point arrays, this uses ieee-754 compare semantics.
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal DatumResult Compare(@Const @ByRef Datum left, @Const @ByRef Datum right,
                      @ByVal CompareOptions options, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Compare(@Const @ByRef Datum left, @Const @ByRef Datum right,
                      @ByVal CompareOptions options);

/** \brief Invert the values of a boolean datum
 *  @param value [in] datum to invert
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Invert(@Const @ByRef Datum value, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Invert(@Const @ByRef Datum value);

/** \brief Element-wise AND of two boolean datums which always propagates nulls
 *  (null and false is null).
 * 
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult And(@Const @ByRef Datum left, @Const @ByRef Datum right, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult And(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Element-wise AND of two boolean datums with a Kleene truth table
 *  (null and false is false).
 * 
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult KleeneAnd(@Const @ByRef Datum left, @Const @ByRef Datum right,
                        ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult KleeneAnd(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Element-wise OR of two boolean datums which always propagates nulls
 *  (null and true is null).
 * 
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Or(@Const @ByRef Datum left, @Const @ByRef Datum right, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Or(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Element-wise OR of two boolean datums with a Kleene truth table
 *  (null or true is true).
 * 
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal DatumResult KleeneOr(@Const @ByRef Datum left, @Const @ByRef Datum right, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult KleeneOr(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief Element-wise XOR of two boolean datums
 *  @param left [in] left operand (array)
 *  @param right [in] right operand (array)
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult Xor(@Const @ByRef Datum left, @Const @ByRef Datum right, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Xor(@Const @ByRef Datum left, @Const @ByRef Datum right);

/** \brief IsIn returns true for each element of {@code values} that is contained in
 *  {@code value_set}
 * 
 *  If null occurs in left, if null count in right is not 0,
 *  it returns true, else returns null.
 * 
 *  @param values [in] array-like input to look up in value_set
 *  @param value_set [in] either Array or ChunkedArray
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult IsIn(@Const @ByRef Datum values, @Const @ByRef Datum value_set,
                   ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult IsIn(@Const @ByRef Datum values, @Const @ByRef Datum value_set);

/** \brief IndexIn examines each slot in the values against a value_set array.
 *  If the value is not found in value_set, null will be output.
 *  If found, the index of occurrence within value_set (ignoring duplicates)
 *  will be output.
 * 
 *  For example given values = [99, 42, 3, null] and
 *  value_set = [3, 3, 99], the output will be = [1, null, 0, null]
 * 
 *  Note: Null in the values is considered to match
 *  a null in the value_set array. For example given
 *  values = [99, 42, 3, null] and value_set = [3, 99, null],
 *  the output will be = [1, null, 0, 2]
 * 
 *  @param values [in] array-like input
 *  @param value_set [in] either Array or ChunkedArray
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult IndexIn(@Const @ByRef Datum values, @Const @ByRef Datum value_set,
                      ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult IndexIn(@Const @ByRef Datum values, @Const @ByRef Datum value_set);

/** \brief IsValid returns true for each element of {@code values} that is not null,
 *  false otherwise
 * 
 *  @param values [in] input to examine for validity
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult IsValid(@Const @ByRef Datum values, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult IsValid(@Const @ByRef Datum values);

/** \brief IsNull returns true for each element of {@code values} that is null,
 *  false otherwise
 * 
 *  @param values [in] input to examine for nullity
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
///
///
@Namespace("arrow::compute") public static native @ByVal DatumResult IsNull(@Const @ByRef Datum values, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult IsNull(@Const @ByRef Datum values);

/** \brief FillNull replaces each null element in {@code values}
 *  with {@code fill_value}
 * 
 *  @param values [in] input to examine for nullity
 *  @param fill_value [in] scalar
 *  @param ctx [in] the function execution context, optional
 * 
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal DatumResult FillNull(@Const @ByRef Datum values, @Const @ByRef Datum fill_value,
                       ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult FillNull(@Const @ByRef Datum values, @Const @ByRef Datum fill_value);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/api_vector.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>

// #include "arrow/compute/function.h"
// #include "arrow/datum.h"
// #include "arrow/result.h"
// #include "arrow/type_fwd.h"
// Targeting ..\FilterOptions.java


// Targeting ..\TakeOptions.java


// Targeting ..\PartitionNthOptions.java



/** \}
 <p>
 *  \brief Filter with a boolean selection filter
 * 
 *  The output will be populated with values from the input at positions
 *  where the selection filter is not 0. Nulls in the filter will be handled
 *  based on options.null_selection_behavior.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  filter = [0, 1, 1, 0, null, 1], the output will be
 *  (null_selection_behavior == DROP)      = ["b", "c", "f"]
 *  (null_selection_behavior == EMIT_NULL) = ["b", "c", null, "f"]
 * 
 *  @param values [in] array to filter
 *  @param filter [in] indicates which values should be filtered out
 *  @param options [in] configures null_selection_behavior
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum */
@Namespace("arrow::compute") public static native @ByVal DatumResult Filter(@Const @ByRef Datum values, @Const @ByRef Datum filter,
                     @Const @ByRef(nullValue = "arrow::compute::FilterOptions::Defaults()") FilterOptions options,
                     ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Filter(@Const @ByRef Datum values, @Const @ByRef Datum filter);

// These internal functions are implemented in kernels/vector_selection.cc

/** \brief Return the number of selected indices in the boolean filter */
@Namespace("arrow::compute::internal") public static native @Cast("int64_t") long GetFilterOutputSize(@Const @ByRef ArrayData filter,
                            FilterOptions.NullSelectionBehavior null_selection);
@Namespace("arrow::compute::internal") public static native @Cast("int64_t") long GetFilterOutputSize(@Const @ByRef ArrayData filter,
                            @Cast("arrow::compute::FilterOptions::NullSelectionBehavior") int null_selection);

/** \brief Compute uint64 selection indices for use with Take given a boolean
 *  filter */
@Namespace("arrow::compute::internal") public static native @ByVal ArrayDataResult GetTakeIndices(
    @Const @ByRef ArrayData filter, FilterOptions.NullSelectionBehavior null_selection,
    MemoryPool memory_pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow::compute::internal") public static native @ByVal ArrayDataResult GetTakeIndices(
    @Const @ByRef ArrayData filter, FilterOptions.NullSelectionBehavior null_selection);
@Namespace("arrow::compute::internal") public static native @ByVal ArrayDataResult GetTakeIndices(
    @Const @ByRef ArrayData filter, @Cast("arrow::compute::FilterOptions::NullSelectionBehavior") int null_selection,
    MemoryPool memory_pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow::compute::internal") public static native @ByVal ArrayDataResult GetTakeIndices(
    @Const @ByRef ArrayData filter, @Cast("arrow::compute::FilterOptions::NullSelectionBehavior") int null_selection);

  // namespace internal

/** \brief Take from an array of values at indices in another array
 * 
 *  The output array will be of the same type as the input values
 *  array, with elements taken from the values array at the given
 *  indices. If an index is null then the taken element will be null.
 * 
 *  For example given values = ["a", "b", "c", null, "e", "f"] and
 *  indices = [2, 1, null, 3], the output will be
 *  = [values[2], values[1], null, values[3]]
 *  = ["c", "b", null, null]
 * 
 *  @param values [in] datum from which to take
 *  @param indices [in] which values to take
 *  @param options [in] options
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum */
@Namespace("arrow::compute") public static native @ByVal DatumResult Take(@Const @ByRef Datum values, @Const @ByRef Datum indices,
                   @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options,
                   ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Take(@Const @ByRef Datum values, @Const @ByRef Datum indices);

/** \brief Take with Array inputs and output */

///
///
@Namespace("arrow::compute") public static native @ByVal ArrayResult Take(@Const @ByRef Array values, @Const @ByRef Array indices,
                                    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options,
                                    ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal ArrayResult Take(@Const @ByRef Array values, @Const @ByRef Array indices);

/** \brief Returns indices that partition an array around n-th
 *  sorted element.
 * 
 *  Find index of n-th(0 based) smallest value and perform indirect
 *  partition of an array around that element. Output indices[0 ~ n-1]
 *  holds values no greater than n-th element, and indices[n+1 ~ end]
 *  holds values no less than n-th element. Elements in each partition
 *  is not sorted. Nulls will be partitioned to the end of the output.
 *  Output is not guaranteed to be stable.
 * 
 *  @param values [in] array to be partitioned
 *  @param n [in] pivot array around sorted n-th element
 *  @param ctx [in] the function execution context, optional
 *  @return offsets indices that would partition an array */

///
///
///
@Namespace("arrow::compute") public static native @ByVal ArrayResult NthToIndices(@Const @ByRef Array values, @Cast("int64_t") long n,
                                            ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal ArrayResult NthToIndices(@Const @ByRef Array values, @Cast("int64_t") long n);

/** \brief Returns the indices that would sort an array.
 * 
 *  Perform an indirect sort of array. The output array will contain
 *  indices that would sort an array, which would be the same length
 *  as input. Nulls will be stably partitioned to the end of the output.
 * 
 *  For example given values = [null, 1, 3.3, null, 2, 5.3], the output
 *  will be [1, 4, 2, 5, 0, 3]
 * 
 *  @param values [in] array to sort
 *  @param ctx [in] the function execution context, optional
 *  @return offsets indices that would sort an array */

///
///
///
@Namespace("arrow::compute") public static native @ByVal ArrayResult SortToIndices(@Const @ByRef Array values,
                                             ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal ArrayResult SortToIndices(@Const @ByRef Array values);

/** \brief Compute unique elements from an array-like object
 * 
 *  Note if a null occurs in the input it will NOT be included in the output.
 * 
 *  @param datum [in] array-like input
 *  @param ctx [in] the function execution context, optional
 *  @return result as Array
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal ArrayResult Unique(@Const @ByRef Datum datum, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal ArrayResult Unique(@Const @ByRef Datum datum);

// Constants for accessing the output of ValueCounts
@Namespace("arrow::compute") @MemberGetter public static native byte kValuesFieldName(int i);
@Namespace("arrow::compute") @MemberGetter public static native String kValuesFieldName();
@Namespace("arrow::compute") @MemberGetter public static native byte kCountsFieldName(int i);
@Namespace("arrow::compute") @MemberGetter public static native String kCountsFieldName();
@Namespace("arrow::compute") @MemberGetter public static native int kValuesFieldIndex();

///
///
///
///
@Namespace("arrow::compute") @MemberGetter public static native int kCountsFieldIndex();

/** \brief Return counts of unique elements from an array-like object.
 * 
 *  Note that the counts do not include counts for nulls in the array.  These can be
 *  obtained separately from metadata.
 * 
 *  For floating point arrays there is no attempt to normalize -0.0, 0.0 and NaN values
 *  which can lead to unexpected results if the input Array has these values.
 * 
 *  @param value [in] array-like input
 *  @param ctx [in] the function execution context, optional
 *  @return counts An array of  <input type "Values", int64_t "Counts"> structs.
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal ArrayResult ValueCounts(@Const @ByRef Datum value,
                                           ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal ArrayResult ValueCounts(@Const @ByRef Datum value);

/** \brief Dictionary-encode values in an array-like object
 *  @param data [in] array-like input
 *  @param ctx [in] the function execution context, optional
 *  @return result with same shape and type as input
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal DatumResult DictionaryEncode(@Const @ByRef Datum data, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult DictionaryEncode(@Const @ByRef Datum data);

// ----------------------------------------------------------------------
// Deprecated functions

@Namespace("arrow::compute") public static native @Deprecated @ByVal ChunkedArrayResult Take(
    @Const @ByRef ChunkedArray values, @Const @ByRef Array indices,
    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options, ExecContext context/*=nullptr*/);
@Namespace("arrow::compute") public static native @Deprecated @ByVal ChunkedArrayResult Take(
    @Const @ByRef ChunkedArray values, @Const @ByRef Array indices);

@Namespace("arrow::compute") public static native @Deprecated @ByVal ChunkedArrayResult Take(
    @Const @ByRef ChunkedArray values, @Const @ByRef ChunkedArray indices,
    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options, ExecContext context/*=nullptr*/);
@Namespace("arrow::compute") public static native @Deprecated @ByVal ChunkedArrayResult Take(
    @Const @ByRef ChunkedArray values, @Const @ByRef ChunkedArray indices);

@Namespace("arrow::compute") public static native @Deprecated @ByVal ChunkedArrayResult Take(
    @Const @ByRef Array values, @Const @ByRef ChunkedArray indices,
    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options, ExecContext context/*=nullptr*/);
@Namespace("arrow::compute") public static native @Deprecated @ByVal ChunkedArrayResult Take(
    @Const @ByRef Array values, @Const @ByRef ChunkedArray indices);

@Namespace("arrow::compute") public static native @Deprecated @ByVal RecordBatchResult Take(
    @Const @ByRef RecordBatch batch, @Const @ByRef Array indices,
    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options, ExecContext context/*=nullptr*/);
@Namespace("arrow::compute") public static native @Deprecated @ByVal RecordBatchResult Take(
    @Const @ByRef RecordBatch batch, @Const @ByRef Array indices);

@Namespace("arrow::compute") public static native @Deprecated @ByVal TableResult Take(@Const @ByRef Table table, @Const @ByRef Array indices,
                                    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options,
                                    ExecContext context/*=nullptr*/);
@Namespace("arrow::compute") public static native @Deprecated @ByVal TableResult Take(@Const @ByRef Table table, @Const @ByRef Array indices);

@Namespace("arrow::compute") public static native @Deprecated @ByVal TableResult Take(@Const @ByRef Table table, @Const @ByRef ChunkedArray indices,
                                    @Const @ByRef(nullValue = "arrow::compute::TakeOptions::Defaults()") TakeOptions options,
                                    ExecContext context/*=nullptr*/);
@Namespace("arrow::compute") public static native @Deprecated @ByVal TableResult Take(@Const @ByRef Table table, @Const @ByRef ChunkedArray indices);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/kernel.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// NOTE: API is EXPERIMENTAL and will change without going through a
// deprecation cycle

// #pragma once

// #include <cstddef>
// #include <cstdint>
// #include <functional>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/buffer.h"
// #include "arrow/compute/exec.h"
// #include "arrow/datum.h"
// #include "arrow/memory_pool.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\FunctionOptions.java


// Targeting ..\KernelState.java


// Targeting ..\KernelContext.java



// A macro to invoke for error control flow after invoking functions (such as
// kernel init or exec functions) that propagate errors via KernelContext.
// #define ARROW_CTX_RETURN_IF_ERROR(CTX)
//   do {
//     if (ARROW_PREDICT_FALSE((CTX)->HasError())) {
//       Status s = (CTX)->status();
//       (CTX)->ResetStatus();
//       return s;
//     }
//   } while (0)

/** \brief The standard kernel execution API that must be implemented for
 *  SCALAR and VECTOR kernel types. This includes both stateless and stateful
 *  kernels. Kernels depending on some execution state access that state via
 *  subclasses of KernelState set on the KernelContext object. May be used for
 *  SCALAR and VECTOR kernel kinds. Implementations should endeavor to write
 *  into pre-allocated memory if they are able, though for some kernels
 *  (e.g. in cases when a builder like StringBuilder) must be employed this may
 *  not be possible. */
// Targeting ..\TypeMatcher.java



/** \brief Match any DataType instance having the same DataType::id. */
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher SameTypeId(@Cast("arrow::Type::type") int type_id);

/** \brief Match any TimestampType instance having the same unit, but the time
 *  zones can be different. */
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher TimestampTypeUnit(TimeUnit.type unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher TimestampTypeUnit(@Cast("arrow::TimeUnit::type") int unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher Time32TypeUnit(TimeUnit.type unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher Time32TypeUnit(@Cast("arrow::TimeUnit::type") int unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher Time64TypeUnit(TimeUnit.type unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher Time64TypeUnit(@Cast("arrow::TimeUnit::type") int unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher DurationTypeUnit(TimeUnit.type unit);
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher DurationTypeUnit(@Cast("arrow::TimeUnit::type") int unit);

// \brief Match any integer type
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher Integer();

// Match types using 32-bit varbinary representation
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher BinaryLike();

// Match types using 64-bit varbinary representation
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher LargeBinaryLike();

// \brief Match any primitive type (boolean or any type representable as a C
// Type)
@Namespace("arrow::compute::match") public static native @SharedPtr TypeMatcher Primitive();


// Targeting ..\InputType.java


// Targeting ..\OutputType.java


// Targeting ..\KernelSignature.java


// Targeting ..\SimdLevel.java


// Targeting ..\NullHandling.java


// Targeting ..\MemAllocation.java


// Targeting ..\KernelInitArgs.java



/** \brief Common initializer function for all kernel types.
 *  If an error occurs it will be stored in the KernelContext; nullptr will be returned. */
// Targeting ..\Kernel.java


// Targeting ..\ArrayKernel.java


// Targeting ..\ScalarKernel.java



// ----------------------------------------------------------------------
// VectorKernel (for VectorFunction)

/** \brief See VectorKernel::finalize member for usage */
// Targeting ..\VectorKernel.java



// ----------------------------------------------------------------------
// ScalarAggregateKernel (for ScalarAggregateFunction)

// Finalize returns Datum to permit multiple return values

///
// Targeting ..\ScalarAggregateKernel.java



  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/exec.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// NOTE: API is EXPERIMENTAL and will change without going through a
// deprecation cycle

// #pragma once

// #include <cstdint>
// #include <limits>
// #include <memory>
// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/array/data.h"
// #include "arrow/datum.h"
// #include "arrow/memory_pool.h"
// #include "arrow/result.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\CpuInfo.java



  // namespace internal

// It seems like 64K might be a good default chunksize to use for execution
// based on the experience of other query processing systems. The current
// default is not to chunk contiguous arrays, though, but this may change in
// the future once parallel execution is implemented
@Namespace("arrow::compute") @MemberGetter public static native @Cast("const int64_t") long kDefaultExecChunksize();
public static final long kDefaultExecChunksize = kDefaultExecChunksize();
// Targeting ..\ExecContext.java


// Targeting ..\SelectionVector.java


// Targeting ..\ExecBatch.java



/** \defgroup compute-call-function One-shot calls to compute functions
 * 
 *  \{
 <p>
 *  \brief One-shot invoker for all types of functions.
 * 
 *  Does kernel dispatch, argument checking, iteration of ChunkedArray inputs,
 *  and wrapping of outputs. */

///
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString String func_name, @Const @ByRef DatumVector args,
                           @Const FunctionOptions options, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString String func_name, @Const @ByRef DatumVector args,
                           @Const FunctionOptions options);
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString BytePointer func_name, @Const @ByRef DatumVector args,
                           @Const FunctionOptions options, ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString BytePointer func_name, @Const @ByRef DatumVector args,
                           @Const FunctionOptions options);

/** \brief Variant of CallFunction which uses a function's default options.
 * 
 *  NB: Some functions require FunctionOptions be provided. */
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString String func_name, @Const @ByRef DatumVector args,
                           ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString String func_name, @Const @ByRef DatumVector args);
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString BytePointer func_name, @Const @ByRef DatumVector args,
                           ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult CallFunction(@StdString BytePointer func_name, @Const @ByRef DatumVector args);

/** \} */

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/function.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// NOTE: API is EXPERIMENTAL and will change without going through a
// deprecation cycle.

// #pragma once

// #include <string>
// #include <utility>
// #include <vector>

// #include "arrow/compute/kernel.h"
// #include "arrow/compute/type_fwd.h"
// #include "arrow/datum.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

/** \defgroup compute-functions Abstract compute function API
 * 
 *  \{
 <p>
 *  \brief Base class for specifying options configuring a function's behavior,
 *  such as error handling. */
// Targeting ..\Arity.java


// Targeting ..\Function.java




// Targeting ..\ScalarFunction.java


// Targeting ..\VectorFunction.java


// Targeting ..\ScalarAggregateFunction.java


// Targeting ..\MetaFunction.java



/** \} */

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/cast.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/compute/function.h"
// #include "arrow/compute/kernel.h"
// #include "arrow/datum.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\CastOptions.java



/** \} */

// Cast functions are _not_ registered in the FunctionRegistry, though they use
// the same execution machinery



/** \brief Return true if a cast function is defined */

///
@Namespace("arrow::compute") public static native @Cast("bool") boolean CanCast(@Const @ByRef DataType from_type, @Const @ByRef DataType to_type);

// ----------------------------------------------------------------------
// Convenience invocation APIs for a number of kernels

/** \brief Cast from one array type to another
 *  @param value [in] array to cast
 *  @param to_type [in] type to cast to
 *  @param options [in] casting options
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting array
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal ArrayResult Cast(@Const @ByRef Array value, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type,
                                    @Const @ByRef(nullValue = "arrow::compute::CastOptions::Safe()") CastOptions options,
                                    ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal ArrayResult Cast(@Const @ByRef Array value, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type);

/** \brief Cast from one array type to another
 *  @param value [in] array to cast
 *  @param options [in] casting options. The "to_type" field must be populated
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting array
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */

///
@Namespace("arrow::compute") public static native @ByVal DatumResult Cast(@Const @ByRef Datum value, @Const @ByRef CastOptions options,
                   ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Cast(@Const @ByRef Datum value, @Const @ByRef CastOptions options);

/** \brief Cast from one value to another
 *  @param value [in] datum to cast
 *  @param to_type [in] type to cast to
 *  @param options [in] casting options
 *  @param ctx [in] the function execution context, optional
 *  @return the resulting datum
 * 
 *  @since 1.0.0
 *  \note API not yet finalized */
@Namespace("arrow::compute") public static native @ByVal DatumResult Cast(@Const @ByRef Datum value, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type,
                   @Const @ByRef(nullValue = "arrow::compute::CastOptions::Safe()") CastOptions options,
                   ExecContext ctx/*=nullptr*/);
@Namespace("arrow::compute") public static native @ByVal DatumResult Cast(@Const @ByRef Datum value, @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type);

  // namespace compute
  // namespace arrow


// Parsed from arrow/compute/registry.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// NOTE: API is EXPERIMENTAL and will change without going through a
// deprecation cycle

// #pragma once

// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/util/visibility.h"
// Targeting ..\FunctionRegistry.java



/** \brief Return the process-global function registry */
@Namespace("arrow::compute") public static native FunctionRegistry GetFunctionRegistry();

  // namespace compute
  // namespace arrow


// Parsed from arrow/ipc/api.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include "arrow/ipc/dictionary.h"
// #include "arrow/ipc/feather.h"
// #include "arrow/ipc/json_simple.h"
// #include "arrow/ipc/message.h"
// #include "arrow/ipc/reader.h"
// #include "arrow/ipc/writer.h"


// Parsed from arrow/ipc/type_fwd.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

@Namespace("arrow::ipc") public enum MetadataVersion {
  /** 0.1.0 */
  V1((byte)0),

  /** 0.2.0 */
  V2((byte)1),

  /** 0.3.0 to 0.7.1 */
  V3((byte)2),

  /** 0.8.0 to 0.17.0 */
  V4((byte)3),

  /** >= 1.0.0 */
  V5((byte)4);

    public final byte value;
    private MetadataVersion(byte v) { this.value = v; }
    private MetadataVersion(MetadataVersion e) { this.value = e.value; }
    public MetadataVersion intern() { for (MetadataVersion e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
@Namespace("arrow::ipc") public enum MessageType {
  NONE(0),
  SCHEMA(1),
  DICTIONARY_BATCH(2),
  RECORD_BATCH(3),
  TENSOR(4),
  SPARSE_TENSOR(5);

    public final int value;
    private MessageType(int v) { this.value = v; }
    private MessageType(MessageType e) { this.value = e.value; }
    public MessageType intern() { for (MessageType e : values()) if (e.value == value) return e; return this; }
    @Override public String toString() { return intern().name(); }
}
// Targeting ..\RecordBatchStreamWriter.java



  // namespace feather
  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/dictionary.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Tools for dictionaries in IPC context

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <unordered_map>
// #include <utility>
// #include <vector>

// #include "arrow/memory_pool.h"
// #include "arrow/status.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\DictionaryMemo.java



@Namespace("arrow::ipc") public static native @ByVal Status CollectDictionaries(@Const @ByRef RecordBatch batch, DictionaryMemo memo);

  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/feather.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Public API for the "Feather" file format, originally created at
// http://github.com/wesm/feather

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <vector>

// #include "arrow/result.h"
// #include "arrow/util/compression.h"
// #include "arrow/util/visibility.h"

  // namespace io

@Namespace("arrow::ipc::feather") @MemberGetter public static native int kFeatherV1Version();
public static final int kFeatherV1Version = kFeatherV1Version();
@Namespace("arrow::ipc::feather") @MemberGetter public static native int kFeatherV2Version();
public static final int kFeatherV2Version = kFeatherV2Version();
// Targeting ..\Reader.java


// Targeting ..\WriteProperties.java



@Namespace("arrow::ipc::feather") public static native @ByVal Status WriteTable(@Const @ByRef Table table, OutputStream dst,
                  @Const @ByRef(nullValue = "arrow::ipc::feather::WriteProperties::Defaults()") WriteProperties properties);
@Namespace("arrow::ipc::feather") public static native @ByVal Status WriteTable(@Const @ByRef Table table, OutputStream dst);

  // namespace feather
  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/json_simple.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Implement a simple JSON representation format for arrays

// #pragma once

// #include <memory>
// #include <string>

// #include "arrow/status.h"
// #include "arrow/util/string_view.h"
// #include "arrow/util/visibility.h"

@Namespace("arrow::ipc::internal::json") public static native @ByVal Status ArrayFromJSON(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType arg0, @StdString String json,
                     @SharedPtr Array out);
@Namespace("arrow::ipc::internal::json") public static native @ByVal Status ArrayFromJSON(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType arg0, @StdString BytePointer json,
                     @SharedPtr Array out);

  // namespace json
  // namespace internal
  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/options.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// #pragma once

// #include <cstdint>
// #include <vector>

// #include "arrow/ipc/type_fwd.h"
// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/compression.h"
// #include "arrow/util/visibility.h"

// ARROW-109: We set this number arbitrarily to help catch user mistakes. For
// deeply nested schemas, it is expected the user will indicate explicitly the
// maximum allowed recursion depth
@Namespace("arrow::ipc") @MemberGetter public static native int kMaxNestingDepth();
// Targeting ..\IpcWriteOptions.java



// #ifndef ARROW_NO_DEPRECATED_API
// Targeting ..\IpcReadOptions.java





  // namespace internal
  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/message.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// C++ object model and user API for interprocess schema messaging

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <string>
// #include <utility>

// #include "arrow/io/type_fwd.h"
// #include "arrow/ipc/type_fwd.h"
// #include "arrow/result.h"
// #include "arrow/status.h"
// #include "arrow/type_fwd.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"
// Targeting ..\Message.java




///
///
@Namespace("arrow::ipc") public static native @StdString String FormatMessageType(MessageType type);
@Namespace("arrow::ipc") public static native @StdString BytePointer FormatMessageType(@Cast("arrow::ipc::MessageType") int type);
// Targeting ..\MessageDecoderListener.java


// Targeting ..\AssignMessageDecoderListener.java


// Targeting ..\MessageDecoder.java


// Targeting ..\MessageReader.java



/** \brief Read encapsulated RPC message from position in file
 * 
 *  Read a length-prefixed message flatbuffer starting at the indicated file
 *  offset. If the message has a body with non-zero length, it will also be
 *  read
 * 
 *  The metadata_length includes at least the length prefix and the flatbuffer
 * 
 *  @param offset [in] the position in the file where the message starts. The
 *  first 4 bytes after the offset are the message length
 *  @param metadata_length [in] the total number of bytes to read from file
 *  @param file [in] the seekable file interface to read from
 *  @return the message read */
@Namespace("arrow::ipc") public static native @ByVal MessageUniqueResult ReadMessage(@Cast("const int64_t") long offset,
                                             int metadata_length,
                                             RandomAccessFile file);

/** \brief Advance stream to an 8-byte offset if its position is not a multiple
 *  of 8 already
 *  @param stream [in] an input stream
 *  @param alignment [in] the byte multiple for the metadata prefix, usually 8
 *  or 64, to ensure the body starts on a multiple of that alignment
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(InputStream stream, int alignment/*=8*/);
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(InputStream stream);

/** \brief Advance stream to an 8-byte offset if its position is not a multiple
 *  of 8 already
 *  @param stream [in] an output stream
 *  @param alignment [in] the byte multiple for the metadata prefix, usually 8
 *  or 64, to ensure the body starts on a multiple of that alignment
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(OutputStream stream, int alignment/*=8*/);
@Namespace("arrow::ipc") public static native @ByVal Status AlignStream(OutputStream stream);

/** \brief Return error Status if file position is not a multiple of the
 *  indicated alignment */

///
///
@Namespace("arrow::ipc") public static native @ByVal Status CheckAligned(FileInterface stream, int alignment/*=8*/);
@Namespace("arrow::ipc") public static native @ByVal Status CheckAligned(FileInterface stream);

/** \brief Read encapsulated IPC message (metadata and body) from InputStream
 * 
 *  Returns null if there are not enough bytes available or the
 *  message length is 0 (e.g. EOS in a stream)
 * 
 *  @param stream [in] an input stream
 *  @param pool [in] an optional MemoryPool to copy metadata on the CPU, if required
 *  @return Message */

///
///
///
@Namespace("arrow::ipc") public static native @ByVal MessageUniqueResult ReadMessage(InputStream stream,
                                             MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow::ipc") public static native @ByVal MessageUniqueResult ReadMessage(InputStream stream);

/** \brief Feed data from InputStream to MessageDecoder to decode an
 *  encapsulated IPC message (metadata and body)
 * 
 *  This API is EXPERIMENTAL.
 * 
 *  @param decoder [in] a decoder
 *  @param stream [in] an input stream
 *  @return Status
 * 
 *  @since 0.17.0 */

///
///
///
@Namespace("arrow::ipc") public static native @ByVal Status DecodeMessage(MessageDecoder decoder, InputStream stream);

/** Write encapsulated IPC message Does not make assumptions about
 *  whether the stream is aligned already. Can write legacy (pre
 *  version 0.15.0) IPC message if option set
 * 
 *  continuation: 0xFFFFFFFF
 *  message_size: int32
 *  message: const void*
 *  padding
 * 
 * 
 *  @param message [in] a buffer containing the metadata to write
 *  @param options [in] IPC writing options, including alignment and
 *  legacy message support
 *  @param file [in,out] the OutputStream to write to
 *  @param message_length [out] the total size of the payload written including
 *  padding
 *  @return Status */


  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/reader.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Read Arrow files and streams

// #pragma once

// #include <cstddef>
// #include <cstdint>
// #include <memory>
// #include <utility>
// #include <vector>

// #include "arrow/ipc/message.h"
// #include "arrow/ipc/options.h"
// #include "arrow/record_batch.h"
// #include "arrow/result.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

  // namespace io


///
// Targeting ..\RecordBatchStreamReader.java


// Targeting ..\RecordBatchFileReader.java


// Targeting ..\Listener.java


// Targeting ..\CollectListener.java


// Targeting ..\StreamDecoder.java



// Generic read functions; does not copy data if the input supports zero copy reads

/** \brief Read Schema from stream serialized as a single IPC message
 *  and populate any dictionary-encoded fields into a DictionaryMemo
 * 
 *  @param stream [in] an InputStream
 *  @param dictionary_memo [in] for recording dictionary-encoded fields
 *  @return the output Schema
 * 
 *  If record batches follow the schema, it is better to use
 *  RecordBatchStreamReader */

///
@Namespace("arrow::ipc") public static native @ByVal SchemaResult ReadSchema(InputStream stream,
                                           DictionaryMemo dictionary_memo);

/** \brief Read Schema from encapsulated Message
 * 
 *  @param message [in] the message containing the Schema IPC metadata
 *  @param dictionary_memo [in] DictionaryMemo for recording dictionary-encoded
 *  fields. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @return the resulting Schema */

///
@Namespace("arrow::ipc") public static native @ByVal SchemaResult ReadSchema(@Const @ByRef Message message,
                                           DictionaryMemo dictionary_memo);

/** Read record batch as encapsulated IPC message with metadata size prefix and
 *  header
 * 
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param options [in] IPC options for reading
 *  @param stream [in] the file where the batch is located
 *  @return the read record batch */

///
@Namespace("arrow::ipc") public static native @ByVal RecordBatchResult ReadRecordBatch(
    @Const @SharedPtr @ByRef Schema schema, @Const DictionaryMemo dictionary_memo,
    @Const @ByRef IpcReadOptions options, InputStream stream);

/** \brief Read record batch from message
 * 
 *  @param message [in] a Message containing the record batch metadata
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param options [in] IPC options for reading
 *  @return the read record batch */

///
@Namespace("arrow::ipc") public static native @ByVal RecordBatchResult ReadRecordBatch(
    @Const @ByRef Message message, @Const @SharedPtr @ByRef Schema schema,
    @Const DictionaryMemo dictionary_memo, @Const @ByRef IpcReadOptions options);

/** Read record batch from file given metadata and schema
 * 
 *  @param metadata [in] a Message containing the record batch metadata
 *  @param schema [in] the record batch schema
 *  @param dictionary_memo [in] DictionaryMemo which has any
 *  dictionaries. Can be nullptr if you are sure there are no
 *  dictionary-encoded fields
 *  @param file [in] a random access file
 *  @param options [in] options for deserialization
 *  @return the read record batch */

///
@Namespace("arrow::ipc") public static native @ByVal RecordBatchResult ReadRecordBatch(
    @Const @ByRef ArrowBuffer metadata, @Const @SharedPtr @ByRef Schema schema,
    @Const DictionaryMemo dictionary_memo, @Const @ByRef IpcReadOptions options,
    RandomAccessFile file);

/** \brief Read arrow::Tensor as encapsulated IPC message in file
 * 
 *  @param file [in] an InputStream pointed at the start of the message
 *  @return the read tensor */

///
@Namespace("arrow::ipc") public static native @ByVal TensorResult ReadTensor(InputStream file);

/** \brief EXPERIMENTAL: Read arrow::Tensor from IPC message
 * 
 *  @param message [in] a Message containing the tensor metadata and body
 *  @return the read tensor */

///
@Namespace("arrow::ipc") public static native @ByVal TensorResult ReadTensor(@Const @ByRef Message message);

/** \brief EXPERIMENTAL: Read arrow::SparseTensor as encapsulated IPC message in file
 * 
 *  @param file [in] an InputStream pointed at the start of the message
 *  @return the read sparse tensor */

///
@Namespace("arrow::ipc") public static native @ByVal SparseTensorResult ReadSparseTensor(InputStream file);

/** \brief EXPERIMENTAL: Read arrow::SparseTensor from IPC message
 * 
 *  @param message [in] a Message containing the tensor metadata and body
 *  @return the read sparse tensor */
@Namespace("arrow::ipc") public static native @ByVal SparseTensorResult ReadSparseTensor(@Const @ByRef Message message);

// These internal APIs may change without warning or deprecation

/** \brief EXPERIMENTAL: Read arrow::SparseTensorFormat::type from a metadata
 *  @param metadata [in] a Buffer containing the sparse tensor metadata
 *  @return the count of the body buffers */
@Namespace("arrow::ipc::internal") public static native @ByVal SizeTResult ReadSparseTensorBodyBufferCount(@Const @ByRef ArrowBuffer metadata);

/** \brief EXPERIMENTAL: Read arrow::SparseTensor from an IpcPayload
 *  @param payload [in] a IpcPayload contains a serialized SparseTensor
 *  @return the read sparse tensor */
@Namespace("arrow::ipc::internal") public static native @ByVal SparseTensorResult ReadSparseTensorPayload(@Const @ByRef IpcPayload payload);

// For fuzzing targets
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcStream(@Cast("const uint8_t*") BytePointer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcStream(@Cast("const uint8_t*") ByteBuffer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcStream(@Cast("const uint8_t*") byte[] data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcFile(@Cast("const uint8_t*") BytePointer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcFile(@Cast("const uint8_t*") ByteBuffer data, @Cast("int64_t") long size);
@Namespace("arrow::ipc::internal") public static native @ByVal Status FuzzIpcFile(@Cast("const uint8_t*") byte[] data, @Cast("int64_t") long size);

  // namespace internal

  // namespace ipc
  // namespace arrow


// Parsed from arrow/ipc/writer.h

// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// Implement Arrow streaming binary format

// #pragma once

// #include <cstdint>
// #include <memory>
// #include <vector>

// #include "arrow/ipc/dictionary.h"  // IWYU pragma: export
// #include "arrow/ipc/message.h"
// #include "arrow/ipc/options.h"
// #include "arrow/result.h"
// #include "arrow/util/macros.h"
// #include "arrow/util/visibility.h"

  // namespace io
// Targeting ..\IpcPayload.java


// Targeting ..\RecordBatchWriter.java



/** Create a new IPC stream writer from stream sink and schema. User is
 *  responsible for closing the actual OutputStream.
 * 
 *  @param sink [in] output stream to write to
 *  @param schema [in] the schema of the record batches to be written
 *  @param options [in] options for serialization
 *  @return Result<std::shared_ptr<RecordBatchWriter>> */

///
@Namespace("arrow::ipc") public static native @ByVal RecordBatchWriterSharedResult NewStreamWriter(
    OutputStream sink, @Const @SharedPtr @ByRef Schema schema,
    @Const @ByRef(nullValue = "arrow::ipc::IpcWriteOptions::Defaults()") IpcWriteOptions options);
@Namespace("arrow::ipc") public static native @ByVal RecordBatchWriterSharedResult NewStreamWriter(
    OutputStream sink, @Const @SharedPtr @ByRef Schema schema);

/** Create a new IPC file writer from stream sink and schema
 * 
 *  @param sink [in] output stream to write to
 *  @param schema [in] the schema of the record batches to be written
 *  @param options [in] options for serialization, optional
 *  @param metadata [in] custom metadata for File Footer, optional
 *  @return Result<std::shared_ptr<RecordBatchWriter>> */

///
@Namespace("arrow::ipc") public static native @ByVal RecordBatchWriterSharedResult NewFileWriter(
    OutputStream sink, @Const @SharedPtr @ByRef Schema schema,
    @Const @ByRef(nullValue = "arrow::ipc::IpcWriteOptions::Defaults()") IpcWriteOptions options,
    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow::ipc") public static native @ByVal RecordBatchWriterSharedResult NewFileWriter(
    OutputStream sink, @Const @SharedPtr @ByRef Schema schema);

/** \brief Low-level API for writing a record batch (without schema)
 *  to an OutputStream as encapsulated IPC message. See Arrow format
 *  documentation for more detail.
 * 
 *  @param batch [in] the record batch to write
 *  @param buffer_start_offset [in] the start offset to use in the buffer metadata,
 *  generally should be 0
 *  @param dst [in] an OutputStream
 *  @param metadata_length [out] the size of the length-prefixed flatbuffer
 *  including padding to a 64-byte boundary
 *  @param body_length [out] the size of the contiguous buffer block plus
 *  @param options [in] options for serialization
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch, @Cast("int64_t") long buffer_start_offset,
                        OutputStream dst, IntPointer metadata_length,
                        @Cast("int64_t*") LongPointer body_length, @Const @ByRef IpcWriteOptions options);
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch, @Cast("int64_t") long buffer_start_offset,
                        OutputStream dst, IntBuffer metadata_length,
                        @Cast("int64_t*") LongBuffer body_length, @Const @ByRef IpcWriteOptions options);
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatch(@Const @ByRef RecordBatch batch, @Cast("int64_t") long buffer_start_offset,
                        OutputStream dst, int[] metadata_length,
                        @Cast("int64_t*") long[] body_length, @Const @ByRef IpcWriteOptions options);

/** \brief Serialize record batch as encapsulated IPC message in a new buffer
 * 
 *  @param batch [in] the record batch
 *  @param options [in] the IpcWriteOptions to use for serialization
 *  @return the serialized message */

///
@Namespace("arrow::ipc") public static native @ByVal BufferResult SerializeRecordBatch(@Const @ByRef RecordBatch batch,
                                                     @Const @ByRef IpcWriteOptions options);

/** \brief Serialize record batch as encapsulated IPC message in a new buffer
 * 
 *  @param batch [in] the record batch
 *  @param mm [in] a MemoryManager to allocate memory from
 *  @return the serialized message */

///
///
@Namespace("arrow::ipc") public static native @ByVal BufferResult SerializeRecordBatch(@Const @ByRef RecordBatch batch,
                                                     @SharedPtr MemoryManager mm);

/** \brief Write record batch to OutputStream
 * 
 *  @param batch [in] the record batch to write
 *  @param options [in] the IpcWriteOptions to use for serialization
 *  @param out [in] the OutputStream to write the output to
 *  @return Status
 * 
 *  If writing to pre-allocated memory, you can use
 *  arrow::ipc::GetRecordBatchSize to compute how much space is required */

///
@Namespace("arrow::ipc") public static native @ByVal Status SerializeRecordBatch(@Const @ByRef RecordBatch batch, @Const @ByRef IpcWriteOptions options,
                            OutputStream out);

/** \brief Serialize schema as encapsulated IPC message
 * 
 *  @param schema [in] the schema to write
 *  @param dictionary_memo [in] a DictionaryMemo for recording dictionary ids
 *  @param pool [in] a MemoryPool to allocate memory from
 *  @return the serialized schema */
@Namespace("arrow::ipc") public static native @ByVal BufferResult SerializeSchema(@Const @ByRef Schema schema,
                                                DictionaryMemo dictionary_memo,
                                                MemoryPool pool/*=arrow::default_memory_pool()*/);
@Namespace("arrow::ipc") public static native @ByVal BufferResult SerializeSchema(@Const @ByRef Schema schema,
                                                DictionaryMemo dictionary_memo);

/** \brief Write multiple record batches to OutputStream, including schema
 *  @param batches [in] a vector of batches. Must all have same schema
 *  @param options [in] options for serialization
 *  @param dst [out] an OutputStream
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status WriteRecordBatchStream(@Const @ByRef RecordBatchVector batches,
                              @Const @ByRef IpcWriteOptions options, OutputStream dst);

/** \brief Compute the number of bytes needed to write an IPC payload
 *      including metadata
 * 
 *  @param payload [in] the IPC payload to write
 *  @param options [in] write options
 *  @return the size of the complete encapsulated message */

///
@Namespace("arrow::ipc") public static native @Cast("int64_t") long GetPayloadSize(@Const @ByRef IpcPayload payload,
                       @Const @ByRef(nullValue = "arrow::ipc::IpcWriteOptions::Defaults()") IpcWriteOptions options);
@Namespace("arrow::ipc") public static native @Cast("int64_t") long GetPayloadSize(@Const @ByRef IpcPayload payload);

/** \brief Compute the number of bytes needed to write a record batch including metadata
 * 
 *  @param batch [in] the record batch to write
 *  @param size [out] the size of the complete encapsulated message
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Cast("int64_t*") LongPointer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Cast("int64_t*") LongBuffer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Cast("int64_t*") long[] size);

/** \brief Compute the number of bytes needed to write a record batch including metadata
 * 
 *  @param batch [in] the record batch to write
 *  @param options [in] options for serialization
 *  @param size [out] the size of the complete encapsulated message
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Const @ByRef IpcWriteOptions options,
                          @Cast("int64_t*") LongPointer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Const @ByRef IpcWriteOptions options,
                          @Cast("int64_t*") LongBuffer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchSize(@Const @ByRef RecordBatch batch, @Const @ByRef IpcWriteOptions options,
                          @Cast("int64_t*") long[] size);

/** \brief Compute the number of bytes needed to write a tensor including metadata
 * 
 *  @param tensor [in] the tensor to write
 *  @param size [out] the size of the complete encapsulated message
 *  @return Status */

///
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorSize(@Const @ByRef Tensor tensor, @Cast("int64_t*") LongPointer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorSize(@Const @ByRef Tensor tensor, @Cast("int64_t*") LongBuffer size);
@Namespace("arrow::ipc") public static native @ByVal Status GetTensorSize(@Const @ByRef Tensor tensor, @Cast("int64_t*") long[] size);

/** \brief EXPERIMENTAL: Convert arrow::Tensor to a Message with minimal memory
 *  allocation
 * 
 *  @param tensor [in] the Tensor to write
 *  @param pool [in] MemoryPool to allocate space for metadata
 *  @return the resulting Message */

///
///
///
@Namespace("arrow::ipc") public static native @ByVal MessageUniqueResult GetTensorMessage(@Const @ByRef Tensor tensor, MemoryPool pool);

/** \brief Write arrow::Tensor as a contiguous message.
 * 
 *  The metadata and body are written assuming 64-byte alignment. It is the
 *  user's responsibility to ensure that the OutputStream has been aligned
 *  to a 64-byte multiple before writing the message.
 * 
 *  The message is written out as followed:
 *  <pre>{@code
 *  <metadata size> <metadata> <tensor data>
 *  }</pre>
 * 
 *  @param tensor [in] the Tensor to write
 *  @param dst [in] the OutputStream to write to
 *  @param metadata_length [out] the actual metadata length, including padding
 *  @param body_length [out] the actual message body length
 *  @return Status */

///
///
@Namespace("arrow::ipc") public static native @ByVal Status WriteTensor(@Const @ByRef Tensor tensor, OutputStream dst, IntPointer metadata_length,
                   @Cast("int64_t*") LongPointer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteTensor(@Const @ByRef Tensor tensor, OutputStream dst, IntBuffer metadata_length,
                   @Cast("int64_t*") LongBuffer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteTensor(@Const @ByRef Tensor tensor, OutputStream dst, int[] metadata_length,
                   @Cast("int64_t*") long[] body_length);

/** \brief EXPERIMENTAL: Convert arrow::SparseTensor to a Message with minimal memory
 *  allocation
 * 
 *  The message is written out as followed:
 *  <pre>{@code
 *  <metadata size> <metadata> <sparse index> <sparse tensor body>
 *  }</pre>
 * 
 *  @param sparse_tensor [in] the SparseTensor to write
 *  @param pool [in] MemoryPool to allocate space for metadata
 *  @return the resulting Message */

///
@Namespace("arrow::ipc") public static native @ByVal MessageUniqueResult GetSparseTensorMessage(@Const @ByRef SparseTensor sparse_tensor,
                                                        MemoryPool pool);

/** \brief EXPERIMENTAL: Write arrow::SparseTensor as a contiguous message. The metadata,
 *  sparse index, and body are written assuming 64-byte alignment. It is the
 *  user's responsibility to ensure that the OutputStream has been aligned
 *  to a 64-byte multiple before writing the message.
 * 
 *  @param sparse_tensor [in] the SparseTensor to write
 *  @param dst [in] the OutputStream to write to
 *  @param metadata_length [out] the actual metadata length, including padding
 *  @param body_length [out] the actual message body length
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status WriteSparseTensor(@Const @ByRef SparseTensor sparse_tensor, OutputStream dst,
                         IntPointer metadata_length, @Cast("int64_t*") LongPointer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteSparseTensor(@Const @ByRef SparseTensor sparse_tensor, OutputStream dst,
                         IntBuffer metadata_length, @Cast("int64_t*") LongBuffer body_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteSparseTensor(@Const @ByRef SparseTensor sparse_tensor, OutputStream dst,
                         int[] metadata_length, @Cast("int64_t*") long[] body_length);

/** \brief Compute IpcPayload for the given schema
 *  @param schema [in] the Schema that is being serialized
 *  @param options [in] options for serialization
 *  @param dictionary_memo [in,out] class to populate with assigned dictionary ids
 *  @param out [out] the returned vector of IpcPayloads
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status GetSchemaPayload(@Const @ByRef Schema schema, @Const @ByRef IpcWriteOptions options,
                        DictionaryMemo dictionary_memo, IpcPayload out);

/** \brief Compute IpcPayload for a dictionary
 *  @param id [in] the dictionary id
 *  @param dictionary [in] the dictionary values
 *  @param options [in] options for serialization
 *  @param payload [out] the output IpcPayload
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status GetDictionaryPayload(@Cast("int64_t") long id, @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                            @Const @ByRef IpcWriteOptions options, IpcPayload payload);

/** \brief Compute IpcPayload for a dictionary
 *  @param id [in] the dictionary id
 *  @param is_delta [in] whether the dictionary is a delta dictionary
 *  @param dictionary [in] the dictionary values
 *  @param options [in] options for serialization
 *  @param payload [out] the output IpcPayload
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status GetDictionaryPayload(@Cast("int64_t") long id, @Cast("bool") boolean is_delta,
                            @SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array dictionary,
                            @Const @ByRef IpcWriteOptions options, IpcPayload payload);

/** \brief Compute IpcPayload for the given record batch
 *  @param batch [in] the RecordBatch that is being serialized
 *  @param options [in] options for serialization
 *  @param out [out] the returned IpcPayload
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status GetRecordBatchPayload(@Const @ByRef RecordBatch batch, @Const @ByRef IpcWriteOptions options,
                             IpcPayload out);

/** \brief Write an IPC payload to the given stream.
 *  @param payload [in] the payload to write
 *  @param options [in] options for serialization
 *  @param dst [in] The stream to write the payload to.
 *  @param metadata_length [out] the length of the serialized metadata
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status WriteIpcPayload(@Const @ByRef IpcPayload payload, @Const @ByRef IpcWriteOptions options,
                       OutputStream dst, IntPointer metadata_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteIpcPayload(@Const @ByRef IpcPayload payload, @Const @ByRef IpcWriteOptions options,
                       OutputStream dst, IntBuffer metadata_length);
@Namespace("arrow::ipc") public static native @ByVal Status WriteIpcPayload(@Const @ByRef IpcPayload payload, @Const @ByRef IpcWriteOptions options,
                       OutputStream dst, int[] metadata_length);

/** \brief Compute IpcPayload for the given sparse tensor
 *  @param sparse_tensor [in] the SparseTensor that is being serialized
 *  @param pool [in,out] for any required temporary memory allocations
 *  @param out [out] the returned IpcPayload
 *  @return Status */
@Namespace("arrow::ipc") public static native @ByVal Status GetSparseTensorPayload(@Const @ByRef SparseTensor sparse_tensor, MemoryPool pool,
                              IpcPayload out);
// Targeting ..\IpcPayloadWriter.java



/** Create a new IPC payload stream writer from stream sink. User is
 *  responsible for closing the actual OutputStream.
 * 
 *  @param sink [in] output stream to write to
 *  @param options [in] options for serialization
 *  @return Result<std::shared_ptr<IpcPayloadWriter>> */

///
@Namespace("arrow::ipc::internal") public static native @ByVal IpcPayloadWriterResult MakePayloadStreamWriter(
    OutputStream sink, @Const @ByRef(nullValue = "arrow::ipc::IpcWriteOptions::Defaults()") IpcWriteOptions options);
@Namespace("arrow::ipc::internal") public static native @ByVal IpcPayloadWriterResult MakePayloadStreamWriter(
    OutputStream sink);

/** Create a new IPC payload file writer from stream sink.
 * 
 *  @param sink [in] output stream to write to
 *  @param schema [in] the schema of the record batches to be written
 *  @param options [in] options for serialization, optional
 *  @param metadata [in] custom metadata for File Footer, optional
 *  @return Status */

///
@Namespace("arrow::ipc::internal") public static native @ByVal IpcPayloadWriterResult MakePayloadFileWriter(
    OutputStream sink, @Const @SharedPtr @ByRef Schema schema,
    @Const @ByRef(nullValue = "arrow::ipc::IpcWriteOptions::Defaults()") IpcWriteOptions options,
    @Const @Cast("const arrow::KeyValueMetadata*") @SharedPtr @ByRef(nullValue = "std::shared_ptr<const arrow::KeyValueMetadata>(nullptr)") KeyValueMetadata metadata);
@Namespace("arrow::ipc::internal") public static native @ByVal IpcPayloadWriterResult MakePayloadFileWriter(
    OutputStream sink, @Const @SharedPtr @ByRef Schema schema);

/** Create a new RecordBatchWriter from IpcPayloadWriter and schema.
 * 
 *  @param sink [in] the IpcPayloadWriter to write to
 *  @param schema [in] the schema of the record batches to be written
 *  @param options [in] options for serialization
 *  @return Result<std::unique_ptr<RecordBatchWriter>> */
@Namespace("arrow::ipc::internal") public static native @ByVal RecordBatchWriterUniqueResult OpenRecordBatchWriter(
    @UniquePtr IpcPayloadWriter sink, @Const @SharedPtr @ByRef Schema schema,
    @Const @ByRef(nullValue = "arrow::ipc::IpcWriteOptions::Defaults()") IpcWriteOptions options);
@Namespace("arrow::ipc::internal") public static native @ByVal RecordBatchWriterUniqueResult OpenRecordBatchWriter(
    @UniquePtr IpcPayloadWriter sink, @Const @SharedPtr @ByRef Schema schema);

  // namespace internal
  // namespace ipc
  // namespace arrow


}
