// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** Represents an expression tree */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class Expression extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Expression(Pointer p) { super(p); }


  /** Returns true iff the expressions are identical; does not check for equivalence.
   *  For example, (A and B) is not equal to (B and A) nor is (A and not A) equal to
   *  (false). */
  public native @Cast("bool") boolean Equals(@Const @ByRef Expression other);

  /** Overload for the common case of checking for equality to a specific scalar. */

  /** If true, this Expression is a ScalarExpression wrapping a null scalar. */
  public native @Cast("bool") boolean IsNull();

  /** Validate this expression for execution against a schema. This will check that all
   *  reference fields are present (fields not in the schema will be replaced with null)
   *  and all subexpressions are executable. Returns the type to which this expression
   *  will evaluate. */
  
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  public native @ByVal DataTypeResult Validate(@Const @ByRef Schema schema);

  /** \brief Simplify to an equivalent Expression given assumed constraints on input.
   *  This can be used to do less filtering work using predicate push down.
   * 
   *  Both expressions must pass validation against a schema before Assume may be used.
   * 
   *  Two expressions can be considered equivalent for a given subset of possible inputs
   *  if they yield identical results. Formally, if given.Evaluate(input).Equals(input)
   *  then Assume guarantees that:
   *      expr.Assume(given).Evaluate(input).Equals(expr.Evaluate(input))
   * 
   *  For example if we are given that all inputs will
   *  satisfy ("a"_ == 1) then the expression ("a"_ > 0 and "b"_ > 0) is equivalent to
   *  ("b"_ > 0). It is impossible that the comparison ("a"_ > 0) will evaluate false
   *  given ("a"_ == 1), so both expressions will yield identical results. Thus we can
   *  write:
   *      ("a"_ > 0 and "b"_ > 0).Assume("a"_ == 1).Equals("b"_ > 0)
   * 
   *  filter.Assume(partition) is trivial if filter and partition are disjoint or if
   *  partition is a subset of filter. FIXME(bkietz) write this better
   *  - If the two are disjoint, then (false) may be substituted for filter.
   *  - If partition is a subset of filter then (true) may be substituted for filter.
   * 
   *  filter.Assume(partition) is straightforward if both filter and partition are simple
   *  comparisons.
   *  - filter may be a superset of partition, in which case the filter is
   *    satisfied by all inputs:
   *      ("a"_ > 0).Assume("a"_ == 1).Equals(true)
   *  - filter may be disjoint with partition, in which case there are no inputs which
   *    satisfy filter:
   *      ("a"_ < 0).Assume("a"_ == 1).Equals(false)
   *  - If neither of these is the case, partition provides no information which can
   *    simplify filter:
   *      ("a"_ == 1).Assume("a"_ > 0).Equals("a"_ == 1)
   *      ("a"_ == 1).Assume("b"_ == 1).Equals("a"_ == 1)
   * 
   *  If filter is compound, Assume can be distributed across the boolean operator. To
   *  prove this is valid, we again demonstrate that the simplified expression will yield
   *  identical results. For conjunction of filters lhs and rhs:
   *      (lhs.Assume(p) and rhs.Assume(p)).Evaluate(input)
   *      == Intersection(lhs.Assume(p).Evaluate(input), rhs.Assume(p).Evaluate(input))
   *      == Intersection(lhs.Evaluate(input), rhs.Evaluate(input))
   *      == (lhs and rhs).Evaluate(input)
   *  - The proof for disjunction is symmetric; just replace Intersection with Union. Thus
   *    we can write:
   *      (lhs and rhs).Assume(p).Equals(lhs.Assume(p) and rhs.Assume(p))
   *      (lhs or rhs).Assume(p).Equals(lhs.Assume(p) or rhs.Assume(p))
   *  - For negation:
   *      (not e.Assume(p)).Evaluate(input)
   *      == Difference(input, e.Assume(p).Evaluate(input))
   *      == Difference(input, e.Evaluate(input))
   *      == (not e).Evaluate(input)
   *  - Thus we can write:
   *      (not e).Assume(p).Equals(not e.Assume(p))
   * 
   *  If the partition expression is a conjunction then each of its subexpressions is
   *  true for all input and can be used independently:
   *      filter.Assume(lhs).Assume(rhs).Evaluate(input)
   *      == filter.Assume(lhs).Evaluate(input)
   *      == filter.Evaluate(input)
   *  - Thus we can write:
   *      filter.Assume(lhs and rhs).Equals(filter.Assume(lhs).Assume(rhs))
   * 
   *  FIXME(bkietz) disjunction proof
   *      filter.Assume(lhs or rhs).Equals(filter.Assume(lhs) and filter.Assume(rhs))
   *  - This may not result in a simpler expression so it is only used when
   *      filter.Assume(lhs).Equals(filter.Assume(rhs))
   * 
   *  If the partition expression is a negation then we can use the above relations by
   *  replacing comparisons with their complements and using the properties:
   *      (not (a and b)).Equals(not a or not b)
   *      (not (a or b)).Equals(not a and not b) */
  public native @SharedPtr @ByVal Expression Assume(@Const @ByRef Expression given);

  /** Indicates if the expression is satisfiable.
   * 
   *  This is a shortcut to check if the expression is neither null nor false. */
  
  ///
  public native @Cast("bool") boolean IsSatisfiable();

  /** Indicates if the expression is satisfiable given an other expression.
   * 
   *  This behaves like IsSatisfiable, but it simplifies the current expression
   *  with the given {@code other} information. */
  public native @Cast("bool") boolean IsSatisfiableWith(@Const @ByRef Expression other);

  /** returns a debug string representing this expression */
  public native @StdString String ToString();

  /** serialize/deserialize an Expression. */
  public native @ByVal BufferResult Serialize();
  public static native @ByVal ExpressionResult Deserialize(@Const @ByRef ArrowBuffer arg0);

  /** \brief Return the expression's type identifier */
  public native ExpressionType.type type();

  /** Copy this expression into a shared pointer. */
  public native @SharedPtr @ByVal Expression Copy();

  public native @ByVal InExpression In(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Array>"}) Array set);

  public native @ByVal IsValidExpression IsValid();

  public native @ByVal CastExpression CastTo(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type,
                          @ByVal(nullValue = "arrow::compute::CastOptions()") CastOptions options);
  public native @ByVal CastExpression CastTo(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

  public native @ByVal CastExpression CastLike(@Const @ByRef Expression expr,
                            @ByVal(nullValue = "arrow::compute::CastOptions()") CastOptions options);
  public native @ByVal CastExpression CastLike(@Const @ByRef Expression expr);
}
