// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Base class for file format implementation */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class FileFormat extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileFormat(Pointer p) { super(p); }


  /** \brief The name identifying the kind of file format */
  public native @StdString String type_name();

  /** \brief Return true if fragments of this format can benefit from parallel scanning. */
  public native @Cast("bool") boolean splittable();

  /** \brief Indicate if the FileSource is supported/readable by this format. */
  public native @ByVal BoolResult IsSupported(@Const @ByRef FileSource source);

  /** \brief Return the schema of the file if possible. */
  public native @ByVal SchemaResult Inspect(@Const @ByRef FileSource source);

  /** \brief Open a FileFragment for scanning.
   *  May populate lazy properties of the FileFragment. */
  public native @ByVal ScanTaskIteratorResult ScanFile(@SharedPtr ScanOptions options,
                                              @SharedPtr ScanContext context,
                                              FileFragment file);

  /** \brief Open a fragment */
  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source, @SharedPtr @ByVal Expression partition_expression,
        @SharedPtr @ByVal Schema physical_schema);

  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source, @SharedPtr @ByVal Expression partition_expression);

  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source, @SharedPtr @ByVal(nullValue = "std::shared_ptr<arrow::Schema>(nullptr)") Schema physical_schema);
  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source);

  /** \brief Write a fragment. If the parent directory of destination does not exist, it
   *  will be created. */
  public native @ByVal WriteTaskResult WriteFragment(
        @ByVal WritableFileSource destination, @SharedPtr @ByVal Fragment fragment,
        @SharedPtr ScanOptions options,
        @SharedPtr ScanContext scan_context);  // FIXME(bkietz) make this pure virtual
}
