// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief A Dataset of FileFragments.
 * 
 *  A FileSystemDataset is composed of one or more FileFragment. The fragments
 *  are independent and don't need to share the same format and/or filesystem. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class FileSystemDataset extends Dataset {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileSystemDataset(Pointer p) { super(p); }

  /** \brief Create a FileSystemDataset.
   * 
   *  @param schema [in] the schema of the dataset
   *  @param root_partition [in] the partition expression of the dataset
   *  @param format [in] the format of each FileFragment.
   *  @param fragments [in] list of fragments to create the dataset from
   * 
   *  Note that all fragment must be of {@code FileFragment} type. The type are
   *  erased to simplify callers.
   * 
   *  @return A constructed dataset. */
  
  ///
  public static native @ByVal FileSystemDatasetResult Make(
        @SharedPtr @ByVal Schema schema, @SharedPtr @ByVal Expression root_partition,
        @SharedPtr FileFormat format,
        @ByVal FileFragmentVector fragments);

  /** \brief Write to a new format and filesystem location, preserving partitioning.
   * 
   *  @param plan [in] the WritePlan to execute.
   *  @param scan_options [in] options in which to scan fragments
   *  @param scan_context [in] context in which to scan fragments before writing. */
  public static native @ByVal FileSystemDatasetResult Write(
        @Const @ByRef WritePlan plan, @SharedPtr ScanOptions scan_options,
        @SharedPtr ScanContext scan_context);

  /** \brief Return the type name of the dataset. */
  public native @StdString String type_name();

  /** \brief Replace the schema of the dataset. */
  public native @ByVal DatasetResult ReplaceSchema(
        @SharedPtr @ByVal Schema schema);

  /** \brief Return the path of files. */
  public native @ByVal StringVector files();

  /** \brief Return the format. */
  public native @SharedPtr FileFormat format();

  public native @StdString String ToString();
}
