// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief A FileFormat implementation that reads from Parquet files */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class ParquetFileFormat extends FileFormat {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ParquetFileFormat(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ParquetFileFormat(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ParquetFileFormat position(long position) {
        return (ParquetFileFormat)super.position(position);
    }
    @Override public ParquetFileFormat getPointer(long i) {
        return new ParquetFileFormat(this).position(position + i);
    }

  public ParquetFileFormat() { super((Pointer)null); allocate(); }
  private native void allocate();

  /** Convenience constructor which copies properties from a parquet::ReaderProperties.
   *  memory_pool will be ignored. */
  public ParquetFileFormat(@Const @ByRef ReaderProperties reader_properties) { super((Pointer)null); allocate(reader_properties); }
  private native void allocate(@Const @ByRef ReaderProperties reader_properties);

  public native @StdString String type_name();

  public native @Cast("bool") boolean splittable();

  // Note: the default values are exposed in the python bindings and documented
  //       in the docstrings, if any of the default values gets changed please
  //       update there as well.
    /** \defgroup parquet-file-format-reader-properties properties which correspond to
     *  members of parquet::ReaderProperties.
     * 
     *  We don't embed parquet::ReaderProperties directly because we get memory_pool from
     *  ScanContext at scan time and provide differing defaults.
     * 
     *  \{ */
    @Name("reader_options.use_buffered_stream") public native @Cast("bool") boolean reader_options_use_buffered_stream(); public native ParquetFileFormat reader_options_use_buffered_stream(boolean setter);
    @Name("reader_options.buffer_size") public native @Cast("int64_t") long reader_options_buffer_size(); public native ParquetFileFormat reader_options_buffer_size(long setter);
    
    ///
    ///
    @Name("reader_options.file_decryption_properties") public native @SharedPtr FileDecryptionProperties reader_options_file_decryption_properties(); public native ParquetFileFormat reader_options_file_decryption_properties(FileDecryptionProperties setter);
    /** \}
     <p>
     *  \defgroup parquet-file-format-arrow-reader-properties properties which correspond
     *  to members of parquet::ArrowReaderProperties.
     * 
     *  We don't embed parquet::ReaderProperties directly because we get batch_size from
     *  ScanOptions at scan time, and we will never pass use_threads == true (since we
     *  defer parallelization of the scan). Additionally column names (rather than
     *  indices) are used to indicate dictionary columns.
     * 
     *  \{ */
    @Name("reader_options.dict_columns") public native @ByRef StringUnorderedSet reader_options_dict_columns(); public native ParquetFileFormat reader_options_dict_columns(StringUnorderedSet setter);
    /** \} */

  public native @ByVal BoolResult IsSupported(@Const @ByRef FileSource source);

  /** \brief Return the schema of the file if possible. */
  public native @ByVal SchemaResult Inspect(@Const @ByRef FileSource source);

  /** \brief Open a file for scanning */
  public native @ByVal ScanTaskIteratorResult ScanFile(@SharedPtr ScanOptions options,
                                      @SharedPtr ScanContext context,
                                      FileFragment file);

  /** \brief Create a Fragment, restricted to the specified row groups. */
  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source, @SharedPtr @ByVal Expression partition_expression,
        @StdVector RowGroupInfo row_groups,
        @SharedPtr @ByVal(nullValue = "std::shared_ptr<arrow::Schema>(nullptr)") Schema physical_schema);
  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source, @SharedPtr @ByVal Expression partition_expression,
        @StdVector RowGroupInfo row_groups);

  /** \brief Create a Fragment targeting all RowGroups. */
  public native @ByVal FileFragmentResult MakeFragment(
        @ByVal FileSource source, @SharedPtr @ByVal Expression partition_expression,
        @SharedPtr @ByVal Schema physical_schema);

  /** \brief Return a FileReader on the given source. */
  public native @ByVal FileReaderResult GetReader(
        @Const @ByRef FileSource source, ScanOptions arg1/*=nullptr*/, ScanContext arg2/*=nullptr*/);
  public native @ByVal FileReaderResult GetReader(
        @Const @ByRef FileSource source);
}
