// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Represents a parquet's RowGroup with extra information. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class RowGroupInfo extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RowGroupInfo(Pointer p) { super(p); }

  public RowGroupInfo() { super((Pointer)null); allocate(); }
  private native void allocate();

  /** \brief Construct a RowGroup from an identifier. */
  public RowGroupInfo(int id) { super((Pointer)null); allocate(id); }
  private native void allocate(int id);

  /** \brief Construct a RowGroup from an identifier with statistics. */
  public RowGroupInfo(int id, @Cast("int64_t") long num_rows, @Cast("int64_t") long total_byte_size,
                 @SharedPtr StructScalar statistics) { super((Pointer)null); allocate(id, num_rows, total_byte_size, statistics); }
  private native void allocate(int id, @Cast("int64_t") long num_rows, @Cast("int64_t") long total_byte_size,
                 @SharedPtr StructScalar statistics);

  /** \brief Transform a vector of identifiers into a vector of RowGroupInfos */
  public static native @StdVector RowGroupInfo FromIdentifiers(@StdVector IntPointer ids);
  public static native @StdVector RowGroupInfo FromIdentifiers(@StdVector IntBuffer ids);
  public static native @StdVector RowGroupInfo FromIdentifiers(@StdVector int[] ids);
  public static native @StdVector RowGroupInfo FromCount(int count);

  /** \brief Return the RowGroup's identifier (index in the file). */
  
  ///
  public native int id();

  /** \brief Return the RowGroup's number of rows.
   * 
   *  If statistics are not provided, return -1. */
  
  ///
  public native @Cast("int64_t") long num_rows();

  /** \brief Return the RowGroup's total size in bytes.
   * 
   *  If statistics are not provided, return -1. */
  public native @Cast("int64_t") long total_byte_size();

  /** \brief Return the RowGroup's statistics as a StructScalar with a field for
   *  each column with statistics.
   *  Each field will also be a StructScalar with "min" and "max" fields. */
  public native @SharedPtr StructScalar statistics();

  /** \brief Indicate if statistics are set. */
  
  ///
  public native @Cast("bool") boolean HasStatistics();

  /** \brief Indicate if the RowGroup's statistics satisfy the predicate.
   * 
   *  This will return true if the RowGroup was not initialized with statistics
   *  (rather than silently reading metadata for a complete check). */
  public native @Cast("bool") boolean Satisfy(@Const @ByRef Expression predicate);

  /** \brief Indicate if the other RowGroup points to the same RowGroup. */
  public native @Cast("bool") boolean Equals(@Const @ByRef RowGroupInfo other);
}
