// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Scanner is a materialized scan operation with context and options
 *  bound. A scanner is the class that glues ScanTask, Fragment,
 *  and Dataset. In python pseudo code, it performs the following:
 * 
 *   def Scan():
 *     for fragment in self.dataset.GetFragments(this.options.filter):
 *       for scan_task in fragment.Scan(this.options):
 *         yield scan_task */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class Scanner extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Scanner(Pointer p) { super(p); }

  public Scanner(@SharedPtr @ByVal Dataset dataset, @SharedPtr ScanOptions scan_options,
            @SharedPtr ScanContext scan_context) { super((Pointer)null); allocate(dataset, scan_options, scan_context); }
  private native void allocate(@SharedPtr @ByVal Dataset dataset, @SharedPtr ScanOptions scan_options,
            @SharedPtr ScanContext scan_context);

  public Scanner(@SharedPtr @ByVal Fragment fragment, @SharedPtr ScanOptions scan_options,
            @SharedPtr ScanContext scan_context) { super((Pointer)null); allocate(fragment, scan_options, scan_context); }
  private native void allocate(@SharedPtr @ByVal Fragment fragment, @SharedPtr ScanOptions scan_options,
            @SharedPtr ScanContext scan_context);

  /** \brief The Scan operator returns a stream of ScanTask. The caller is
   *  responsible to dispatch/schedule said tasks. Tasks should be safe to run
   *  in a concurrent fashion and outlive the iterator. */
  
  ///
  public native @ByVal ScanTaskIteratorResult Scan();

  /** \brief Convert a Scanner into a Table.
   * 
   *  Use this convenience utility with care. This will serially materialize the
   *  Scan result in memory before creating the Table. */
  public native @ByVal TableResult ToTable();

  /** \brief GetFragments returns an iterator over all Fragments in this scan. */
  public native @ByVal FragmentIterator GetFragments();

  public native @Const @SharedPtr @ByRef Schema schema();

  public native @SharedPtr ScanOptions options();

  public native @SharedPtr ScanContext context();
}
