// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief A declarative plan for writing fragments to a partitioned directory structure. */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class WritePlan extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public WritePlan() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public WritePlan(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public WritePlan(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public WritePlan position(long position) {
        return (WritePlan)super.position(position);
    }
    @Override public WritePlan getPointer(long i) {
        return new WritePlan(this).position(position + i);
    }

  /** The partitioning with which paths were generated */
  public native @SharedPtr Partitioning partitioning(); public native WritePlan partitioning(Partitioning setter);

  /** The schema of the Dataset which will be written */
  public native @SharedPtr @ByRef Schema schema(); public native WritePlan schema(Schema setter);

  /** The format into which fragments will be written */
  public native @SharedPtr FileFormat format(); public native WritePlan format(FileFormat setter);

  /** The FileSystem and base directory for partitioned writing */
  public native @SharedPtr FileSystem filesystem(); public native WritePlan filesystem(FileSystem setter);
  public native @StdString String partition_base_dir(); public native WritePlan partition_base_dir(String setter);

  @NoOffset public static class FragmentOrPartitionExpression extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public FragmentOrPartitionExpression(Pointer p) { super(p); }
  
    public enum Kind { EXPRESSION(0), FRAGMENT(1);

        public final int value;
        private Kind(int v) { this.value = v; }
        private Kind(Kind e) { this.value = e.value; }
        public Kind intern() { for (Kind e : values()) if (e.value == value) return e; return this; }
        @Override public String toString() { return intern().name(); }
    }

    public FragmentOrPartitionExpression(@SharedPtr @ByVal Expression partition_expr) { super((Pointer)null); allocate(partition_expr); }
    private native void allocate(@SharedPtr @ByVal Expression partition_expr);

    public FragmentOrPartitionExpression(@SharedPtr @ByVal Fragment fragment) { super((Pointer)null); allocate(fragment); }
    private native void allocate(@SharedPtr @ByVal Fragment fragment);

    public native Kind kind();

    public native @Const @SharedPtr @ByRef Expression partition_expr();
    public native @Const @SharedPtr @ByRef Fragment fragment();
  }

  /** If fragment_or_partition_expressions[i] is a Fragment, that Fragment will be
   *  written to paths[i]. If it is an Expression, a directory representing that partition
   *  expression will be created at paths[i] instead. */
  
  public native @ByRef StringVector paths(); public native WritePlan paths(StringVector setter);
}
