// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


// Builder API
@Namespace("parquet") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class ColumnChunkMetaDataBuilder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ColumnChunkMetaDataBuilder(Pointer p) { super(p); }

  // API convenience to get a MetaData reader
  public static native @UniquePtr ColumnChunkMetaDataBuilder Make(
        @SharedPtr WriterProperties props, @Const ColumnDescriptor column);

  public static native @UniquePtr ColumnChunkMetaDataBuilder Make(
        @SharedPtr WriterProperties props, @Const ColumnDescriptor column,
        Pointer contents);

  // column chunk
  // Used when a dataset is spread across multiple files
  public native void set_file_path(@StdString String path);
  public native void set_file_path(@StdString BytePointer path);
  // column metadata
  public native void SetStatistics(@Const @ByRef EncodedStatistics stats);
  // get the column descriptor
  public native @Const ColumnDescriptor descr();

  public native @Cast("int64_t") long total_compressed_size();
  // commit the metadata

  public native void Finish(@Cast("int64_t") long num_values, @Cast("int64_t") long dictionary_page_offset,
                @Cast("int64_t") long index_page_offset, @Cast("int64_t") long data_page_offset,
                @Cast("int64_t") long compressed_size, @Cast("int64_t") long uncompressed_size, @Cast("bool") boolean has_dictionary,
                @Cast("bool") boolean dictionary_fallback,
                @Const @ByRef EncodingIntMap dict_encoding_stats_,
                @Const @ByRef EncodingIntMap data_encoding_stats_);

  // The metadata contents, suitable for passing to ColumnChunkMetaData::Make
  public native @Const Pointer contents();

  // For writing metadata at end of column chunk
  public native void WriteTo(OutputStream sink);
}
