// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


/** \brief Iterative FileWriter class
 * 
 *  Start a new RowGroup or Chunk with NewRowGroup.
 *  Write column-by-column the whole column chunk. */
@Namespace("parquet::arrow") @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class FileWriter extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileWriter(Pointer p) { super(p); }

  public static native @ByVal Status Make(MemoryPool pool, @UniquePtr ParquetFileWriter writer,
                                @SharedPtr @ByVal Schema schema,
                                @SharedPtr ArrowWriterProperties arrow_properties,
                                @UniquePtr FileWriter out);

  public static native @ByVal Status Open(@Const @ByRef Schema schema, MemoryPool pool,
                                @SharedPtr OutputStream sink,
                                @SharedPtr WriterProperties properties,
                                @UniquePtr FileWriter writer);

  public static native @ByVal Status Open(@Const @ByRef Schema schema, MemoryPool pool,
                                @SharedPtr OutputStream sink,
                                @SharedPtr WriterProperties properties,
                                @SharedPtr ArrowWriterProperties arrow_properties,
                                @UniquePtr FileWriter writer);

  public native @SharedPtr @ByVal Schema schema();

  /** \brief Write a Table to Parquet. */
  public native @ByVal Status WriteTable(@Const @ByRef Table table, @Cast("int64_t") long chunk_size);

  public native @ByVal Status NewRowGroup(@Cast("int64_t") long chunk_size);
  public native @ByVal Status WriteColumnChunk(@Const @ByRef Array data);

  /** \brief Write ColumnChunk in row group using slice of a ChunkedArray */
  public native @ByVal Status WriteColumnChunk(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray data, @Cast("int64_t") long offset,
        @Cast("int64_t") long size);

  public native @ByVal Status WriteColumnChunk(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray data);
  public native @ByVal Status Close();

  public native MemoryPool memory_pool();
  public native @SharedPtr FileMetaData metadata();
}
