/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.arrow;

import java.util.Arrays;
import org.bytedeco.arrow.ArrowBuffer;
import org.bytedeco.arrow.presets.arrow;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.SharedPtr;

@Name(value={"std::vector<std::shared_ptr<arrow::Buffer> >"})
@Properties(inherit={arrow.class})
public class BufferVector
extends Pointer {
    public BufferVector(Pointer p) {
        super(p);
    }

    public BufferVector(ArrowBuffer value) {
        this(1L);
        this.put(0L, value);
    }

    public BufferVector(ArrowBuffer ... array) {
        this(array.length);
        this.put(array);
    }

    public BufferVector() {
        this.allocate();
    }

    public BufferVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native BufferVector put(@ByRef BufferVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @SharedPtr
    public native ArrowBuffer get(@Cast(value={"size_t"}) long var1);

    public native BufferVector put(@Cast(value={"size_t"}) long var1, ArrowBuffer var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @SharedPtr ArrowBuffer var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public ArrowBuffer[] get() {
        ArrowBuffer[] array = new ArrowBuffer[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public ArrowBuffer pop_back() {
        long size = this.size();
        ArrowBuffer value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public BufferVector push_back(ArrowBuffer value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public BufferVector put(ArrowBuffer value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public BufferVector put(ArrowBuffer ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @SharedPtr
        public native ArrowBuffer get();
    }
}

