// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Streaming compressor interface
 *  */
@Namespace("arrow::util") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Compressor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Compressor(Pointer p) { super(p); }


  public static class CompressResult extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public CompressResult() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public CompressResult(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public CompressResult(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public CompressResult position(long position) {
          return (CompressResult)super.position(position);
      }
      @Override public CompressResult getPointer(long i) {
          return new CompressResult((Pointer)this).offsetAddress(i);
      }
  
    public native @Cast("int64_t") long bytes_read(); public native CompressResult bytes_read(long setter);
    public native @Cast("int64_t") long bytes_written(); public native CompressResult bytes_written(long setter);
  }
  public static class FlushResult extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public FlushResult() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public FlushResult(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public FlushResult(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public FlushResult position(long position) {
          return (FlushResult)super.position(position);
      }
      @Override public FlushResult getPointer(long i) {
          return new FlushResult((Pointer)this).offsetAddress(i);
      }
  
    public native @Cast("int64_t") long bytes_written(); public native FlushResult bytes_written(long setter);
    public native @Cast("bool") boolean should_retry(); public native FlushResult should_retry(boolean setter);
  }
  public static class EndResult extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public EndResult() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public EndResult(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public EndResult(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public EndResult position(long position) {
          return (EndResult)super.position(position);
      }
      @Override public EndResult getPointer(long i) {
          return new EndResult((Pointer)this).offsetAddress(i);
      }
  
    public native @Cast("int64_t") long bytes_written(); public native EndResult bytes_written(long setter);
    public native @Cast("bool") boolean should_retry(); public native EndResult should_retry(boolean setter);
  }

  /** \brief Compress some input.
   * 
   *  If bytes_read is 0 on return, then a larger output buffer should be supplied. */
  
  ///
  public native @ByVal CompressResultResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input,
                                            @Cast("int64_t") long output_len, @Cast("uint8_t*") BytePointer output);
  public native @ByVal CompressResultResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input,
                                            @Cast("int64_t") long output_len, @Cast("uint8_t*") ByteBuffer output);
  public native @ByVal CompressResultResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input,
                                            @Cast("int64_t") long output_len, @Cast("uint8_t*") byte[] output);

  /** \brief Flush part of the compressed output.
   * 
   *  If should_retry is true on return, Flush() should be called again
   *  with a larger buffer. */
  
  ///
  ///
  public native @ByVal FlushResultResult Flush(@Cast("int64_t") long output_len, @Cast("uint8_t*") BytePointer output);
  public native @ByVal FlushResultResult Flush(@Cast("int64_t") long output_len, @Cast("uint8_t*") ByteBuffer output);
  public native @ByVal FlushResultResult Flush(@Cast("int64_t") long output_len, @Cast("uint8_t*") byte[] output);

  /** \brief End compressing, doing whatever is necessary to end the stream.
   * 
   *  If should_retry is true on return, End() should be called again
   *  with a larger buffer.  Otherwise, the Compressor should not be used anymore.
   * 
   *  End() implies Flush(). */
  public native @ByVal EndResultResult End(@Cast("int64_t") long output_len, @Cast("uint8_t*") BytePointer output);
  public native @ByVal EndResultResult End(@Cast("int64_t") long output_len, @Cast("uint8_t*") ByteBuffer output);
  public native @ByVal EndResultResult End(@Cast("int64_t") long output_len, @Cast("uint8_t*") byte[] output);

  // XXX add methods for buffer size heuristics?
}
