// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;
  // namespace detail

/** EXPERIMENTAL: Layout specification for a data type */
@Namespace("arrow") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class DataTypeLayout extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataTypeLayout(Pointer p) { super(p); }

  public enum BufferKind { FIXED_WIDTH(0), VARIABLE_WIDTH(1), BITMAP(2), ALWAYS_NULL(3);

      public final int value;
      private BufferKind(int v) { this.value = v; }
      private BufferKind(BufferKind e) { this.value = e.value; }
      public BufferKind intern() { for (BufferKind e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  /** Layout specification for a single data type buffer */
  public static class BufferSpec extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public BufferSpec() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public BufferSpec(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public BufferSpec(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public BufferSpec position(long position) {
          return (BufferSpec)super.position(position);
      }
      @Override public BufferSpec getPointer(long i) {
          return new BufferSpec((Pointer)this).offsetAddress(i);
      }
  
    public native BufferKind kind(); public native BufferSpec kind(BufferKind setter);
    public native @Cast("int64_t") long byte_width(); public native BufferSpec byte_width(long setter);  // For FIXED_WIDTH

    public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef BufferSpec other);
    public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef BufferSpec other);
  }

  public static native @ByVal BufferSpec FixedWidth(@Cast("int64_t") long w);
  public static native @ByVal BufferSpec VariableWidth();
  public static native @ByVal BufferSpec Bitmap();
  public static native @ByVal BufferSpec AlwaysNull();

  /** A vector of buffer layout specifications, one for each expected buffer */
  public native @StdVector BufferSpec buffers(); public native DataTypeLayout buffers(BufferSpec setter);
  /** Whether this type expects an associated dictionary array. */
  public native @Cast("bool") boolean has_dictionary(); public native DataTypeLayout has_dictionary(boolean setter);

  public DataTypeLayout(@StdVector BufferSpec v) { super((Pointer)null); allocate(v); }
  private native void allocate(@StdVector BufferSpec v);
}
