// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Streaming decompressor interface
 *  */
@Namespace("arrow::util") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Decompressor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Decompressor(Pointer p) { super(p); }


  public static class DecompressResult extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public DecompressResult() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public DecompressResult(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public DecompressResult(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public DecompressResult position(long position) {
          return (DecompressResult)super.position(position);
      }
      @Override public DecompressResult getPointer(long i) {
          return new DecompressResult((Pointer)this).offsetAddress(i);
      }
  
    // XXX is need_more_output necessary? (Brotli?)
    public native @Cast("int64_t") long bytes_read(); public native DecompressResult bytes_read(long setter);
    public native @Cast("int64_t") long bytes_written(); public native DecompressResult bytes_written(long setter);
    public native @Cast("bool") boolean need_more_output(); public native DecompressResult need_more_output(boolean setter);
  }

  /** \brief Decompress some input.
   * 
   *  If need_more_output is true on return, a larger output buffer needs
   *  to be supplied. */
  
  ///
  public native @ByVal DecompressResultResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input,
                                                @Cast("int64_t") long output_len, @Cast("uint8_t*") BytePointer output);
  public native @ByVal DecompressResultResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input,
                                                @Cast("int64_t") long output_len, @Cast("uint8_t*") ByteBuffer output);
  public native @ByVal DecompressResultResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input,
                                                @Cast("int64_t") long output_len, @Cast("uint8_t*") byte[] output);

  /** \brief Return whether the compressed stream is finished.
   * 
   *  This is a heuristic.  If true is returned, then it is guaranteed
   *  that the stream is finished.  If false is returned, however, it may
   *  simply be that the underlying library isn't able to provide the information. */
  public native @Cast("bool") boolean IsFinished();

  /** \brief Reinitialize decompressor, making it ready for a new compressed stream. */
  public native @ByVal Status Reset();

  // XXX add methods for buffer size heuristics?
}
