// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;

// #endif

/** \brief Options for reading Arrow IPC messages */
@Namespace("arrow::ipc") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class IpcReadOptions extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public IpcReadOptions() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public IpcReadOptions(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IpcReadOptions(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public IpcReadOptions position(long position) {
        return (IpcReadOptions)super.position(position);
    }
    @Override public IpcReadOptions getPointer(long i) {
        return new IpcReadOptions((Pointer)this).offsetAddress(i);
    }

  /** \brief The maximum permitted schema nesting depth. */
  
  ///
  public native int max_recursion_depth(); public native IpcReadOptions max_recursion_depth(int setter);

  /** \brief The memory pool to use for allocations made during IPC reading
   * 
   *  While Arrow IPC is predominantly zero-copy, it may have to allocate
   *  memory in some cases (for example if compression is enabled). */
  
  ///
  public native MemoryPool memory_pool(); public native IpcReadOptions memory_pool(MemoryPool setter);

  /** \brief EXPERIMENTAL: Top-level schema fields to include when
   *  deserializing RecordBatch.
   * 
   *  If empty (the default), return all deserialized fields.
   *  If non-empty, the values are the indices of fields in the top-level schema. */
  public native @StdVector IntPointer included_fields(); public native IpcReadOptions included_fields(IntPointer setter);

  /** \brief Use global CPU thread pool to parallelize any computational tasks
   *  like decompression */
  
  ///
  ///
  public native @Cast("bool") boolean use_threads(); public native IpcReadOptions use_threads(boolean setter);

  /** \brief EXPERIMENTAL: Convert incoming data to platform-native endianness
   * 
   *  If the endianness of the received schema is not equal to platform-native
   *  endianness, then all buffers with endian-sensitive data will be byte-swapped.
   *  This includes the value buffers of numeric types, temporal types, decimal
   *  types, as well as the offset buffers of variable-sized binary and list-like
   *  types.
   * 
   *  Endianness conversion is achieved by the RecordBatchFileReader,
   *  RecordBatchStreamReader and StreamDecoder classes. */
  public native @Cast("bool") boolean ensure_native_endian(); public native IpcReadOptions ensure_native_endian(boolean setter);

  public static native @ByVal IpcReadOptions Defaults();
}
