// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Control MinMax kernel behavior
 * 
 *  By default, null values are ignored */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class MinMaxOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MinMaxOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public MinMaxOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public MinMaxOptions position(long position) {
        return (MinMaxOptions)super.position(position);
    }
    @Override public MinMaxOptions getPointer(long i) {
        return new MinMaxOptions((Pointer)this).offsetAddress(i);
    }

  public enum Mode {
    /** Skip null values */
    SKIP(0),
    /** Any nulls will result in null output */
    EMIT_NULL(1);

      public final int value;
      private Mode(int v) { this.value = v; }
      private Mode(Mode e) { this.value = e.value; }
      public Mode intern() { for (Mode e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  public MinMaxOptions(Mode null_handling/*=arrow::compute::MinMaxOptions::SKIP*/) { super((Pointer)null); allocate(null_handling); }
  private native void allocate(Mode null_handling/*=arrow::compute::MinMaxOptions::SKIP*/);
  public MinMaxOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  public MinMaxOptions(@Cast("arrow::compute::MinMaxOptions::Mode") int null_handling/*=arrow::compute::MinMaxOptions::SKIP*/) { super((Pointer)null); allocate(null_handling); }
  private native void allocate(@Cast("arrow::compute::MinMaxOptions::Mode") int null_handling/*=arrow::compute::MinMaxOptions::SKIP*/);

  public static native @ByVal MinMaxOptions Defaults();

  public native Mode null_handling(); public native MinMaxOptions null_handling(Mode setter);
}
