// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Container to capture both exact and input-dependent output types.
 * 
 *  The value shape returned by Resolve will be determined by broadcasting the
 *  shapes of the input arguments, otherwise this is handled by the
 *  user-defined resolver function:
 * 
 *  * Any ARRAY shape -> output shape is ARRAY
 *  * All SCALAR shapes -> output shape is SCALAR */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class OutputType extends Pointer {
    static { Loader.load(); }

  /** \brief An enum indicating whether the value type is an invariant fixed
   *  value or one that's computed by a kernel-defined resolver function. */
  public enum ResolveKind { FIXED(0), COMPUTED(1);

      public final int value;
      private ResolveKind(int v) { this.value = v; }
      private ResolveKind(ResolveKind e) { this.value = e.value; }
      public ResolveKind intern() { for (ResolveKind e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  /** Type resolution function. Given input types and shapes, return output
   *  type and shape. This function SHOULD _not_ be used to check for arity,
   *  that is to be performed one or more layers above. May make use of kernel
   *  state to know what type to output in some cases. */

  /** \brief Output an exact type, but with shape determined by promoting the
   *  shapes of the inputs (any ARRAY argument yields ARRAY). */
  public OutputType(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type) { super((Pointer)null); allocate(type); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type);

  /** \brief Output the exact type and shape provided by a ValueDescr */
  public OutputType(@ByVal ValueDescr descr) { super((Pointer)null); allocate(descr); }
  private native void allocate(@ByVal ValueDescr descr);  // NOLINT implicit construction

  public OutputType(@ByVal @Cast("arrow::compute::OutputType::Resolver*") Pointer resolver) { super((Pointer)null); allocate(resolver); }
  private native void allocate(@ByVal @Cast("arrow::compute::OutputType::Resolver*") Pointer resolver);

  public OutputType(@Const @ByRef OutputType other) { super((Pointer)null); allocate(other); }
  private native void allocate(@Const @ByRef OutputType other);

  /** \brief Return the shape and type of the expected output value of the
   *  kernel given the value descriptors (shapes and types) of the input
   *  arguments. The resolver may make use of state information kept in the
   *  KernelContext. */
  public native @ByVal ValueDescrResult Resolve(KernelContext ctx,
                               @Const @ByRef ValueDescrVector args);

  /** \brief The exact output value type for the FIXED kind. */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type();

  /** \brief For use with COMPUTED resolution strategy. It may be more
   *  convenient to invoke this with OutputType::Resolve returned from this
   *  method. */
  public native @Cast("const arrow::compute::OutputType::Resolver*") @ByRef Pointer resolver();

  /** \brief Render a human-readable string representation. */
  public native @StdString String ToString();

  /** \brief Return the kind of type resolution of this output type, whether
   *  fixed/invariant or computed by a resolver. */
  public native ResolveKind kind();

  /** \brief If the shape is ANY, then Resolve will compute the shape based on
   *  the input arguments. */
  public native ValueDescr.Shape shape();
}
