// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** Concrete Array class for sparse union data */
@Namespace("arrow") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class SparseUnionArray extends UnionArray {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SparseUnionArray(Pointer p) { super(p); }


  public SparseUnionArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data) { super((Pointer)null); allocate(data); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::ArrayData>"}) ArrayData data);

  
  ///
  ///
  public SparseUnionArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("int64_t") long length, @ByVal ArrayVector children,
                     @SharedPtr ArrowBuffer type_ids, @Cast("int64_t") long offset/*=0*/) { super((Pointer)null); allocate(type, length, children, type_ids, offset); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("int64_t") long length, @ByVal ArrayVector children,
                     @SharedPtr ArrowBuffer type_ids, @Cast("int64_t") long offset/*=0*/);
  public SparseUnionArray(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("int64_t") long length, @ByVal ArrayVector children,
                     @SharedPtr ArrowBuffer type_ids) { super((Pointer)null); allocate(type, length, children, type_ids); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType type, @Cast("int64_t") long length, @ByVal ArrayVector children,
                     @SharedPtr ArrowBuffer type_ids);

  /** \brief Construct SparseUnionArray from type_ids and children
   * 
   *  This function does the bare minimum of validation of the input types.
   * 
   *  @param type_ids [in] An array of logical type ids for the union type
   *  @param children [in] Vector of children Arrays containing the data for each type.
   *  @param type_codes [in] Vector of type codes. */
  
  ///
  ///
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children,
                                               @Cast("arrow::SparseUnionArray::type_code_t*") @StdVector BytePointer type_codes);
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children,
                                               @Cast("arrow::SparseUnionArray::type_code_t*") @StdVector ByteBuffer type_codes);
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children,
                                               @Cast("arrow::SparseUnionArray::type_code_t*") @StdVector byte[] type_codes);

  /** \brief Construct SparseUnionArray with custom field names from type_ids and children
   * 
   *  This function does the bare minimum of validation of the input types.
   * 
   *  @param type_ids [in] An array of logical type ids for the union type
   *  @param children [in] Vector of children Arrays containing the data for each type.
   *  @param field_names [in] Vector of strings containing the name of each field.
   *  @param type_codes [in] Vector of type codes. */
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children,
                                               @ByVal(nullValue = "std::vector<std::string>{}") StringVector field_names,
                                               @Cast("arrow::SparseUnionArray::type_code_t*") @StdVector BytePointer type_codes/*={}*/);
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children);
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children,
                                               @ByVal(nullValue = "std::vector<std::string>{}") StringVector field_names,
                                               @Cast("arrow::SparseUnionArray::type_code_t*") @StdVector ByteBuffer type_codes/*={}*/);
  public static native @ByVal ArrayResult Make(@Const @ByRef Array type_ids, @ByVal ArrayVector children,
                                               @ByVal(nullValue = "std::vector<std::string>{}") StringVector field_names,
                                               @Cast("arrow::SparseUnionArray::type_code_t*") @StdVector byte[] type_codes/*={}*/);

  public native @Const SparseUnionType union_type();
}
