// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Push style stream decoder that receives data from user.
 * 
 *  This class decodes the Apache Arrow IPC streaming format data.
 * 
 *  This API is EXPERIMENTAL.
 * 
 *  @see https://arrow.apache.org/docs/format/Columnar.html#ipc-streaming-format
 * 
 *  @since 0.17.0 */
@Namespace("arrow::ipc") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class StreamDecoder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StreamDecoder(Pointer p) { super(p); }

  /** \brief Construct a stream decoder.
   * 
   *  @param listener [in] a Listener that must implement
   *  Listener::OnRecordBatchDecoded() to receive decoded record batches
   *  @param options [in] any IPC reading options (optional) */
  public StreamDecoder(@SharedPtr Listener listener,
                  @ByVal(nullValue = "arrow::ipc::IpcReadOptions::Defaults()") IpcReadOptions options) { super((Pointer)null); allocate(listener, options); }
  private native void allocate(@SharedPtr Listener listener,
                  @ByVal(nullValue = "arrow::ipc::IpcReadOptions::Defaults()") IpcReadOptions options);
  public StreamDecoder(@SharedPtr Listener listener) { super((Pointer)null); allocate(listener); }
  private native void allocate(@SharedPtr Listener listener);

  /** \brief Feed data to the decoder as a raw data.
   * 
   *  If the decoder can read one or more record batches by the data,
   *  the decoder calls listener->OnRecordBatchDecoded() with a
   *  decoded record batch multiple times.
   * 
   *  @param data [in] a raw data to be processed. This data isn't
   *  copied. The passed memory must be kept alive through record
   *  batch processing.
   *  @param size [in] raw data size.
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status Consume(@Cast("const uint8_t*") BytePointer data, @Cast("int64_t") long size);
  public native @ByVal Status Consume(@Cast("const uint8_t*") ByteBuffer data, @Cast("int64_t") long size);
  public native @ByVal Status Consume(@Cast("const uint8_t*") byte[] data, @Cast("int64_t") long size);

  /** \brief Feed data to the decoder as a Buffer.
   * 
   *  If the decoder can read one or more record batches by the
   *  Buffer, the decoder calls listener->RecordBatchReceived() with a
   *  decoded record batch multiple times.
   * 
   *  @param buffer [in] a Buffer to be processed.
   *  @return Status */
  public native @ByVal Status Consume(@SharedPtr ArrowBuffer buffer);

  /** @return the shared schema of the record batches in the stream */
  
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  ///
  public native @SharedPtr @ByVal Schema schema();

  /** \brief Return the number of bytes needed to advance the state of
   *  the decoder.
   * 
   *  This method is provided for users who want to optimize performance.
   *  Normal users don't need to use this method.
   * 
   *  Here is an example usage for normal users:
   * 
   *  ~~~{.cpp}
   *  decoder.Consume(buffer1);
   *  decoder.Consume(buffer2);
   *  decoder.Consume(buffer3);
   *  ~~~
   * 
   *  Decoder has internal buffer. If consumed data isn't enough to
   *  advance the state of the decoder, consumed data is buffered to
   *  the internal buffer. It causes performance overhead.
   * 
   *  If you pass next_required_size() size data to each Consume()
   *  call, the decoder doesn't use its internal buffer. It improves
   *  performance.
   * 
   *  Here is an example usage to avoid using internal buffer:
   * 
   *  ~~~{.cpp}
   *  buffer1 = get_data(decoder.next_required_size());
   *  decoder.Consume(buffer1);
   *  buffer2 = get_data(decoder.next_required_size());
   *  decoder.Consume(buffer2);
   *  ~~~
   * 
   *  Users can use this method to avoid creating small chunks. Record
   *  batch data must be contiguous data. If users pass small chunks
   *  to the decoder, the decoder needs concatenate small chunks
   *  internally. It causes performance overhead.
   * 
   *  Here is an example usage to reduce small chunks:
   * 
   *  ~~~{.cpp}
   *  buffer = AllocateResizableBuffer();
   *  while ((small_chunk = get_data(&small_chunk_size))) {
   *    auto current_buffer_size = buffer->size();
   *    buffer->Resize(current_buffer_size + small_chunk_size);
   *    memcpy(buffer->mutable_data() + current_buffer_size,
   *           small_chunk,
   *           small_chunk_size);
   *    if (buffer->size() < decoder.next_required_size()) {
   *      continue;
   *    }
   *    std::shared_ptr<arrow::Buffer> chunk(buffer.release());
   *    decoder.Consume(chunk);
   *    buffer = AllocateResizableBuffer();
   *  }
   *  if (buffer->size() > 0) {
   *    std::shared_ptr<arrow::Buffer> chunk(buffer.release());
   *    decoder.Consume(chunk);
   *  }
   *  ~~~
   * 
   *  @return the number of bytes needed to advance the state of the
   *  decoder */
  public native @Cast("int64_t") long next_required_size();

  /** \brief Return current read statistics */
  public native @ByVal ReadStats stats();
}
