// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Options for writing a dataset. */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class FileSystemDatasetWriteOptions extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public FileSystemDatasetWriteOptions() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FileSystemDatasetWriteOptions(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileSystemDatasetWriteOptions(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public FileSystemDatasetWriteOptions position(long position) {
        return (FileSystemDatasetWriteOptions)super.position(position);
    }
    @Override public FileSystemDatasetWriteOptions getPointer(long i) {
        return new FileSystemDatasetWriteOptions((Pointer)this).offsetAddress(i);
    }

  /** Options for individual fragment writing. */
  public native @SharedPtr FileWriteOptions file_write_options(); public native FileSystemDatasetWriteOptions file_write_options(FileWriteOptions setter);

  /** FileSystem into which a dataset will be written. */
  public native @SharedPtr FileSystem filesystem(); public native FileSystemDatasetWriteOptions filesystem(FileSystem setter);

  /** Root directory into which the dataset will be written. */
  public native @StdString String base_dir(); public native FileSystemDatasetWriteOptions base_dir(String setter);

  /** Partitioning used to generate fragment paths. */
  public native @SharedPtr Partitioning partitioning(); public native FileSystemDatasetWriteOptions partitioning(Partitioning setter);

  /** Maximum number of partitions any batch may be written into, default is 1K. */
  public native int max_partitions(); public native FileSystemDatasetWriteOptions max_partitions(int setter);

  /** Template string used to generate fragment basenames.
   *  {i} will be replaced by an auto incremented integer. */
  public native @StdString String basename_template(); public native FileSystemDatasetWriteOptions basename_template(String setter);

  public native @SharedPtr FileFormat format();
}
